/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide.events;

import java.util.Vector;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.integration.ide.UMLSupport;
import org.netbeans.modules.uml.integration.ide.dialogs.IProgressIndicator;
import org.netbeans.modules.uml.integration.ide.dialogs.IProgressIndicatorFactory;
import org.netbeans.modules.uml.ui.support.ProductHelper;

public class EventHandler {
    private static final short PROGRESS_THRESHOLD = 3;
    private static final short PRESET_MAXIMUM = 200;
    private Vector runnableQueue = new Vector();
    private WorkerThread worker = new WorkerThread();
    private ProgressThread progress = null;
    private ITaskExecutor executor = defaultExecutor;
    public static final ITaskExecutor defaultExecutor = new ITaskExecutor(){

        public void executeTask(Object object) {
            if (ProductHelper.getCoreProduct().getRoundTripController().getMode() == 1) {
                ((Runnable)object).run();
            }
        }
    };
    private IProgressIndicatorFactory progressFactory = null;
    private boolean working = false;

    public EventHandler(String string) {
        if (string != null) {
            this.worker.setName(string);
        }
    }

    public void setTaskExecutor(ITaskExecutor iTaskExecutor) {
        this.executor = iTaskExecutor;
    }

    public ITaskExecutor getTaskExecutor() {
        return this.executor;
    }

    public IProgressIndicatorFactory getProgressFactory() {
        return this.progressFactory;
    }

    public void setProgressFactory(IProgressIndicatorFactory iProgressIndicatorFactory) {
        this.progressFactory = iProgressIndicatorFactory;
        if (this.progressFactory != null) {
            if (this.progress == null) {
                this.progress = new ProgressThread();
            }
            if (!this.progress.isAlive()) {
                this.progress.start();
            }
        }
    }

    public void startWorker() {
        this.worker.start();
    }

    public void stopWorker() {
        this.worker.interrupt();
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Vector vector = this.runnableQueue;
        synchronized (vector) {
            this.runnableQueue.clear();
            if (this.progress != null && this.progress.isAlive()) {
                this.progress.killProgress();
            }
        }
    }

    public void queueRunnable(Object object) {
        this.queueRunnable(object, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueRunnable(Object object, int n) {
        Vector vector = this.runnableQueue;
        synchronized (vector) {
            if (n <= -1 || n > this.runnableQueue.size()) {
                this.runnableQueue.add(object);
            } else {
                this.runnableQueue.add(n, object);
            }
            if (this.progress != null && this.progressFactory != null && !this.progress.isWorking()) {
                if (this.runnableQueue.size() > 3) {
                    this.showProgressIndicator(this.runnableQueue.size() + 1);
                }
            } else if (this.worker.isAlive() && this.progress != null && this.progress.isWorking()) {
                this.progress.addTasks(1);
            }
            this.runnableQueue.notify();
        }
    }

    public void showProgressIndicator(int n) {
        if (this.progressFactory == null || this.progress == null) {
            throw new IllegalStateException("Cannot show progress indicator");
        }
        this.progress.startProgress(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getNextRunnable() throws InterruptedException {
        Vector vector = this.runnableQueue;
        synchronized (vector) {
            while (this.runnableQueue.size() == 0) {
                this.runnableQueue.wait();
            }
            Object e = this.runnableQueue.elementAt(0);
            this.runnableQueue.remove(0);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        Vector vector = this.runnableQueue;
        synchronized (vector) {
            return this.runnableQueue.size() > 0 || this.working;
        }
    }

    private class ProgressThread
    extends Thread {
        private IProgressIndicator indicator = null;
        private boolean needed = true;
        private int taskCount = 0;
        private int position = 0;
        private int completedTasks = 0;

        private ProgressThread() {
        }

        public void incrementProgress() {
            int n;
            if (this.indicator == null) {
                return;
            }
            if ((n = ++this.completedTasks * 200 / this.taskCount) > this.position) {
                this.position = n;
                this.indicator.setProgress(null, this.position);
            }
        }

        public void setTaskCount(int n) {
            this.taskCount = n;
        }

        public void addTasks(int n) {
            this.taskCount += n;
        }

        public void setNeeded(boolean bl) {
            this.needed = bl;
        }

        public IProgressIndicator getIndicator() {
            return this.indicator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startProgress(int n) {
            if (EventHandler.this.progressFactory != null && this.indicator == null) {
                ProgressThread progressThread = this;
                synchronized (progressThread) {
                    if (this.indicator != null) {
                        return;
                    }
                    this.indicator = EventHandler.this.progressFactory.getProgressIndicator();
                    if (this.indicator != null) {
                        this.indicator.setMaxRange(200);
                        this.taskCount = n;
                        this.completedTasks = 0;
                        this.position = 3;
                        this.indicator.setProgress(UMLSupport.getString("Dialog.RoundtripProgress.Text"), 3);
                        Log.out((String)"Done starting progress indicator");
                        if (this.isAlive()) {
                            this.notify();
                        } else {
                            this.start();
                        }
                    }
                }
            }
        }

        public boolean isWorking() {
            return this.indicator != null && this.isAlive();
        }

        public void endProgress() {
            if (this.indicator != null) {
                this.indicator.done();
            }
        }

        public void killProgress() {
            this.setNeeded(false);
            if (this.indicator != null) {
                this.indicator.done();
            } else if (this.isAlive()) {
                this.interrupt();
            }
        }

        public synchronized void run() {
            while (this.needed) {
                try {
                    while (this.indicator == null) {
                        this.wait();
                    }
                    Log.out((String)"Showing progress indicator");
                    this.indicator.show();
                    this.indicator = null;
                }
                catch (InterruptedException interruptedException) {
                    this.indicator = null;
                    break;
                }
                catch (Exception exception) {
                    Log.stackTrace((Throwable)exception);
                }
            }
        }
    }

    private class WorkerThread
    extends Thread {
        private boolean interrupted = false;

        private WorkerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.interrupted = false;
            try {
                while (!this.interrupted) {
                    Object object = EventHandler.this.getNextRunnable();
                    try {
                        EventHandler.this.working = true;
                        if (EventHandler.this.executor == null) continue;
                        EventHandler.this.executor.executeTask(object);
                    }
                    catch (Throwable throwable) {
                        Log.stackTrace((Throwable)throwable);
                    }
                    finally {
                        try {
                            if (EventHandler.this.progress != null && EventHandler.this.progress.isWorking()) {
                                EventHandler.this.progress.incrementProgress();
                                if (EventHandler.this.runnableQueue.size() == 0) {
                                    EventHandler.this.progress.endProgress();
                                }
                            }
                        }
                        catch (Exception exception) {}
                        EventHandler.this.working = false;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void interrupt() {
            this.interrupted = true;
            super.interrupt();
        }
    }

    public static interface ITaskExecutor {
        public void executeTask(Object var1) throws Exception;
    }
}

