/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.integration.ide.dialogs.IProgressIndicator;

public class ProgressIndicator
extends JDialog
implements IProgressIndicator {
    private static final long serialVersionUID = 1L;
    private JPanel mProgressControls;
    private JLabel mMessage;
    private JProgressBar mProgress;

    public ProgressIndicator(Frame frame) {
        super(frame);
        this.initComponents();
        ImageIcon imageIcon = new ImageIcon(ProgressIndicator.class.getResource("ProgressBackground.jpg"));
        this.getContentPane().add((Component)new ImagePanel(imageIcon.getImage()), "Center");
        Border border = this.mProgress.getBorder();
        EmptyBorder emptyBorder = new EmptyBorder(0, 5, 5, 5);
        CompoundBorder compoundBorder = new CompoundBorder(emptyBorder, border);
        this.mProgress.setBorder(compoundBorder);
        this.setSize(400, 130);
        try {
            this.setLocationRelativeTo(null);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Log.out((String)"Used only with JDK 1.4");
        }
    }

    public ProgressIndicator(String string) {
        this((Frame)null);
        this.setTitle(string);
    }

    public ProgressIndicator(Frame frame, String string) {
        this(frame);
        this.setTitle(string);
    }

    public void setMaxRange(int n) {
        this.mProgress.setMaximum(n);
        this.update(this.getGraphics());
    }

    public int getMaxRange() {
        return this.mProgress.getMaximum();
    }

    public void setMinRange(int n) {
        this.mProgress.setMinimum(n);
    }

    public void setProgress(String string, int n) {
        if (string != null && string.length() > 0) {
            this.mMessage.setText(string);
        }
        this.mProgress.setValue(n);
        this.update(this.getGraphics());
    }

    public void incrementProgress(String string) {
        if (string != null && string.length() > 0) {
            this.mMessage.setText(string);
        }
        this.mProgress.setValue(this.mProgress.getValue() + 1);
        this.update(this.getGraphics());
    }

    public void show() {
        super.show();
        this.update(this.getGraphics());
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.update(this.getGraphics());
    }

    public void done() {
        this.closeDialog(null);
    }

    private void initComponents() {
        this.mProgressControls = new JPanel();
        this.mMessage = new JLabel();
        this.mProgress = new JProgressBar();
        this.setCursor(new Cursor(3));
        this.setName("GDProgressIndicator");
        this.setTitle("Progress Inddicator");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProgressIndicator.this.closeDialog(windowEvent);
            }
        });
        this.mProgressControls.setLayout(new BorderLayout());
        this.mProgressControls.setBorder(new BevelBorder(0));
        this.mMessage.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.mMessage.setText("Processing...");
        this.mProgressControls.add((Component)this.mMessage, "North");
        this.mProgressControls.add((Component)this.mProgress, "South");
        this.getContentPane().add((Component)this.mProgressControls, "South");
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    class ImagePanel
    extends JComponent {
        Image image;

        public ImagePanel(Image image) {
            this.image = image;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }
    }
}

