/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide;

import java.util.Vector;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IEnumerationLiteral;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.roundtripframework.IChangeRequest;
import org.netbeans.modules.uml.core.roundtripframework.IRoundTripEnumLiteralEventsSink;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.integration.ide.RoundTripSource;
import org.netbeans.modules.uml.integration.ide.events.LiteralInfo;
import org.netbeans.modules.uml.integration.ide.listeners.IEnumLiteralChangeListener;

public class RoundTripEnumLiteralEventsSink
extends RoundTripSource
implements IRoundTripEnumLiteralEventsSink {
    private static Vector changeListeners = new Vector();

    public void onPreEnumLiteralChangeRequest(IChangeRequest iChangeRequest, IResultCell iResultCell) {
    }

    public void onEnumLiteralChangeRequest(IChangeRequest iChangeRequest, IResultCell iResultCell) {
        try {
            this.fireLiteralChangeEvent(iChangeRequest, false);
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
        }
    }

    protected void fireLiteralChangeEvent(IChangeRequest iChangeRequest, boolean bl) {
        int n = iChangeRequest.getState();
        IEnumerationLiteral iEnumerationLiteral = null;
        IEnumerationLiteral iEnumerationLiteral2 = null;
        try {
            iEnumerationLiteral = (IEnumerationLiteral)iChangeRequest.getBefore();
            iEnumerationLiteral2 = (IEnumerationLiteral)iChangeRequest.getAfter();
        }
        catch (ClassCastException classCastException) {
            Log.stackTrace((Throwable)classCastException);
        }
        switch (n) {
            case 2: {
                if (!this.isValidEvent((INamedElement)iEnumerationLiteral2)) break;
                LiteralInfo literalInfo = new LiteralInfo(iEnumerationLiteral2);
                this.fireEnumLiteralAddedEvent(literalInfo, bl);
                this.scheduleForNavigation((IElement)iEnumerationLiteral2);
                break;
            }
            case 1: {
                if (!this.isValidEvent((INamedElement)iEnumerationLiteral)) break;
                LiteralInfo literalInfo = new LiteralInfo(iEnumerationLiteral);
                this.fireEnumLiteralDeletedEvent(literalInfo, bl);
                break;
            }
            case 0: {
                if (!this.isValidEvent((INamedElement)iEnumerationLiteral) || !this.isValidEvent((INamedElement)iEnumerationLiteral2)) break;
                LiteralInfo literalInfo = new LiteralInfo(iEnumerationLiteral);
                LiteralInfo literalInfo2 = new LiteralInfo(iEnumerationLiteral2);
                if (literalInfo.getContainingClass() == null) {
                    literalInfo.setContainingClass(literalInfo2.getContainingClass());
                }
                this.fireEnumLiteralChangedEvent(literalInfo, literalInfo2, bl);
            }
        }
    }

    protected void fireEnumLiteralAddedEvent(final LiteralInfo literalInfo, final boolean bl) {
        if (!this.isValidEvent(literalInfo, literalInfo.getContainingClass())) {
            return;
        }
        for (int i = 0; i < changeListeners.size(); ++i) {
            final IEnumLiteralChangeListener iEnumLiteralChangeListener = (IEnumLiteralChangeListener)changeListeners.elementAt(i);
            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                public void work() {
                    RoundTripEnumLiteralEventsSink.this.setDefaultProject(literalInfo);
                    iEnumLiteralChangeListener.enumLiteralAdded(literalInfo, bl);
                }
            };
            this.queue(roundtripThread);
        }
    }

    protected void fireEnumLiteralDeletedEvent(final LiteralInfo literalInfo, final boolean bl) {
        if (!this.isValidEvent(literalInfo, literalInfo.getContainingClass())) {
            return;
        }
        for (int i = 0; i < changeListeners.size(); ++i) {
            final IEnumLiteralChangeListener iEnumLiteralChangeListener = (IEnumLiteralChangeListener)changeListeners.elementAt(i);
            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                public void work() {
                    RoundTripEnumLiteralEventsSink.this.setDefaultProject(literalInfo);
                    iEnumLiteralChangeListener.enumLiteralDeleted(literalInfo, bl);
                }
            };
            this.queue(roundtripThread);
        }
    }

    protected void fireEnumLiteralChangedEvent(final LiteralInfo literalInfo, final LiteralInfo literalInfo2, final boolean bl) {
        if (!this.isValidEvent(literalInfo, literalInfo.getContainingClass())) {
            return;
        }
        for (int i = 0; i < changeListeners.size(); ++i) {
            final IEnumLiteralChangeListener iEnumLiteralChangeListener = (IEnumLiteralChangeListener)changeListeners.elementAt(i);
            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                public void work() {
                    RoundTripEnumLiteralEventsSink.this.setDefaultProject(literalInfo2);
                    iEnumLiteralChangeListener.enumLiteralChanged(literalInfo, literalInfo2, bl);
                }
            };
            this.queue(roundtripThread);
        }
    }

    public static void addEnumLiteralChangeListener(IEnumLiteralChangeListener iEnumLiteralChangeListener) {
        if (iEnumLiteralChangeListener != null && !changeListeners.contains(iEnumLiteralChangeListener)) {
            changeListeners.add(iEnumLiteralChangeListener);
        }
    }

    public static void removeEnumLiteralChangeListener(IEnumLiteralChangeListener iEnumLiteralChangeListener) {
        if (iEnumLiteralChangeListener != null) {
            changeListeners.remove(iEnumLiteralChangeListener);
        }
    }
}

