/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.uml.core.IApplication;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.FileSysManip;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProject;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.integration.ide.UMLSupport;
import org.netbeans.modules.uml.ui.controls.newdialog.INewDialogDiagramDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.INewDialogProjectDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.INewDialogTabDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialog;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialogDiagramDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialogProjectDetails;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeControl;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductDiagramManager;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductProjectManager;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeItem;
import org.netbeans.modules.uml.ui.swing.projecttree.DesignCenterSwingModel;
import org.netbeans.modules.uml.ui.swing.projecttree.ISwingProjectTreeModel;
import org.netbeans.modules.uml.ui.swing.projecttree.JProjectTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductProjectManager
implements IProductProjectManager {
    private IProject mCurrentProject;

    public void setCurrentProject(IProject iProject) {
        this.mCurrentProject = iProject;
    }

    public IProject getCurrentProject() {
        return this.mCurrentProject;
    }

    public void displayNewProjectDialog() {
        NewDialogProjectDetails newDialogProjectDetails = new NewDialogProjectDetails();
        newDialogProjectDetails.setAllowFromRESelection(false);
        newDialogProjectDetails.setMode("Analysis");
        this.displayNewProjectDialog((INewDialogProjectDetails)newDialogProjectDetails);
    }

    public void displayInsertProjectDialog(IWorkspace iWorkspace) {
        IProject iProject;
        IApplication iApplication;
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.toString().toLowerCase().endsWith(UMLSupport.getString("Dialog.InsertProject.ProjectExtension"));
            }

            public String getDescription() {
                return UMLSupport.getString("Dialog.InsertProject.FileFilter.Description");
            }
        });
        if (jFileChooser.showOpenDialog(jFileChooser) == 0 && (file = jFileChooser.getSelectedFile()) != null && (iApplication = UMLSupport.getUMLSupport().getApplication()) != null && (iProject = iApplication.openProject(file.getAbsolutePath())) != null) {
            this.insertProjectIntoWorkspace(iWorkspace, iProject);
        }
    }

    private boolean insertProjectIntoWorkspace(IWorkspace iWorkspace, IProject iProject) {
        boolean bl = false;
        IApplication iApplication = UMLSupport.getUMLSupport().getApplication();
        if (iApplication != null) {
            IWorkspace iWorkspace2;
            JProjectTree jProjectTree;
            ISwingProjectTreeModel iSwingProjectTreeModel;
            IWSProject iWSProject = iApplication.importProject(iWorkspace, iProject);
            bl = true;
            IProjectTreeControl iProjectTreeControl = ProductHelper.getDesignCenterTree();
            if (iProjectTreeControl != null && iProjectTreeControl instanceof JProjectTree && (iSwingProjectTreeModel = (jProjectTree = (JProjectTree)iProjectTreeControl).getProjectModel()) != null && (iWorkspace2 = iSwingProjectTreeModel.getWorkspace()) != null && iWorkspace2.equals(iWorkspace) && iSwingProjectTreeModel instanceof DesignCenterSwingModel) {
                ITreeItem iTreeItem = ((DesignCenterSwingModel)iSwingProjectTreeModel).getWorkspaceNode(iWorkspace, null);
                ((DesignCenterSwingModel)iSwingProjectTreeModel).addProject(iProject.getName(), iTreeItem, iProject);
            }
            iWorkspace.setIsDirty(true);
        }
        return bl;
    }

    public void displayNewProjectDialog(INewDialogProjectDetails iNewDialogProjectDetails) {
        NewDialog newDialog;
        IProject iProject = null;
        if (iNewDialogProjectDetails == null) {
            iNewDialogProjectDetails = new NewDialogProjectDetails();
            iNewDialogProjectDetails.setAllowFromRESelection(false);
        }
        if ((newDialog = new NewDialog()) != null) {
            INewDialogProjectDetails iNewDialogProjectDetails2;
            INewDialogTabDetails iNewDialogTabDetails;
            newDialog.addTab(3);
            if (iNewDialogProjectDetails != null) {
                newDialog.specifyDefaults((INewDialogTabDetails)iNewDialogProjectDetails);
            }
            if ((iNewDialogTabDetails = newDialog.display(null)) != null && iNewDialogTabDetails instanceof INewDialogProjectDetails && (iProject = this.newProject(iNewDialogProjectDetails2 = (INewDialogProjectDetails)iNewDialogTabDetails)) != null) {
                this.doPostNewProject(iProject, iNewDialogProjectDetails);
            }
        }
    }

    public IProject newProject(INewDialogProjectDetails iNewDialogProjectDetails) {
        IProject iProject = null;
        if (iNewDialogProjectDetails != null) {
            String string = iNewDialogProjectDetails.getLocation();
            String string2 = iNewDialogProjectDetails.getName();
            String string3 = FileSysManip.createFullPath((String)string, (String)string2, (String)".etd");
            IApplication iApplication = UMLSupport.getUMLSupport().getApplication();
            if (iApplication != null) {
                iProject = iApplication.getProjectByFileName(string3);
            }
        }
        return iProject;
    }

    public void doPostNewProject(IProject iProject, INewDialogProjectDetails iNewDialogProjectDetails) {
        if (iProject != null) {
            boolean bl = true;
            if (iNewDialogProjectDetails != null) {
                bl = iNewDialogProjectDetails.getPromptToCreateDiagram();
            }
            if (bl) {
                IProject iProject2 = iProject;
                this.queryUserForNewDiagram((INamespace)iProject2, 0, 65535);
            }
        }
    }

    public IDiagram queryUserForNewDiagram(INamespace iNamespace, int n, int n2) {
        INewDialogDiagramDetails iNewDialogDiagramDetails;
        IDiagram iDiagram = null;
        NewDialog newDialog = new NewDialog();
        newDialog.addTab(4);
        NewDialogDiagramDetails newDialogDiagramDetails = new NewDialogDiagramDetails();
        newDialogDiagramDetails.setNamespace(iNamespace);
        newDialogDiagramDetails.setDiagramKind(n);
        newDialogDiagramDetails.setAvailableDiagramKinds(n2);
        newDialog.specifyDefaults((INewDialogTabDetails)newDialogDiagramDetails);
        INewDialogTabDetails iNewDialogTabDetails = newDialog.display(null);
        if (iNewDialogTabDetails != null && iNewDialogTabDetails instanceof INewDialogDiagramDetails && (iNewDialogDiagramDetails = (INewDialogDiagramDetails)iNewDialogTabDetails) != null) {
            INamespace iNamespace2 = iNewDialogDiagramDetails.getNamespace();
            String string = iNewDialogDiagramDetails.getName();
            int n3 = iNewDialogDiagramDetails.getDiagramKind();
            if (string != null && string.length() > 0) {
                iDiagram = this.newDiagram(iNamespace2, n3, string);
            }
        }
        return iDiagram;
    }

    public IDiagram newDiagram(INamespace iNamespace, int n, String string) {
        IDiagram iDiagram = null;
        IProductDiagramManager iProductDiagramManager = ProductHelper.getProductDiagramManager();
        if (iProductDiagramManager != null && iDiagram == null) {
            if (iNamespace != null) {
                iDiagram = iProductDiagramManager.createDiagram(n, iNamespace, string, null);
            } else {
                IProject iProject;
                IProductProjectManager iProductProjectManager = ProductHelper.getProductProjectManager();
                if (iProductProjectManager != null && (iProject = iProductProjectManager.getCurrentProject()) != null) {
                    iDiagram = iProductDiagramManager.createDiagram(n, (INamespace)iProject, string, null);
                }
            }
        }
        return iDiagram;
    }

    public ArrayList<IProject> getOpenProjects() {
        return null;
    }
}

