/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.uml.core.coreapplication.IPreferenceManager2;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElement;
import org.netbeans.modules.uml.integration.ide.UMLSupport;
import org.netbeans.modules.uml.util.DummyCorePreference;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class Preferences {
    public static final String PSK_YES = "PSK_YES";
    public static final String PSK_NO = "PSK_NO";
    public static final String PSK_ASK = "PSK_ASK";
    public static final String PSK_NEVER = "PSK_NEVER";
    public static final String PSK_ALWAYS = "PSK_ALWAYS";
    public static final String COLLECTION_OVERRIDE = "UML_COLLECTION_OVERRIDE_DEFAULT";
    public static final String USE_GENERICS_DEFAULT = "UML_USE_GENERICS_DEFAULT";
    public static final String RECONNECT_LINKS = "UML_Reconnect to Presentation Boundary";
    public static final String CONFIRM_SOURCE_DELETE = "ArtifactDeleteDeletesFile";
    private static boolean promptSaveWorkspace;
    private static boolean reconnectLinks;
    private static String defaultWorkspaceLocation;
    private static String defaultElementName;
    private static String collectionOverride;
    private static String confirmSourceDelete;
    private static IPreferenceManager2 prefMan;
    private static String REL_DEF_WKS_LOC;
    private static String DEF_WKS_FILE;
    private static HashMap watches;
    private static HashMap watchers;
    private static HashMap preferenceCache;

    public static synchronized void addPreferenceWatcher(String string, PreferenceWatcher preferenceWatcher, boolean bl) {
        if (preferenceWatcher == null) {
            throw new IllegalArgumentException("Can't add null watcher");
        }
        Preferences.addWatch(string);
        if (string == null) {
            string = "";
        }
        if (watchers == null) {
            watchers = new HashMap();
        }
        ArrayList arrayList = null;
        if (watchers.containsKey(string)) {
            arrayList = (ArrayList)watchers.get(string);
        } else {
            arrayList = new ArrayList();
            watchers.put(string, arrayList);
        }
        if (!arrayList.contains(preferenceWatcher)) {
            arrayList.add(preferenceWatcher);
        }
        if (bl && string.length() > 0) {
            Log.out((String)("Preferences.addPreferenceWatcher: Firing initial event for " + string + " to " + preferenceWatcher));
            preferenceWatcher.preferenceChanged(string, null, Preferences.getPreference(string));
        }
    }

    public static synchronized void removePreferenceWatcher(PreferenceWatcher preferenceWatcher) {
        if (preferenceWatcher == null) {
            throw new IllegalArgumentException("Can't remove null watcher");
        }
        if (watchers == null) {
            return;
        }
        Iterator iterator = watchers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            ArrayList arrayList = (ArrayList)watchers.get(string);
            if (arrayList == null || !arrayList.remove(preferenceWatcher) || arrayList.size() != 0) continue;
            try {
                iterator.remove();
                Preferences.removeWatch(string);
            }
            catch (Exception exception) {
                Log.stackTrace((Throwable)exception);
            }
        }
    }

    public static synchronized void addWatch(String string) {
        if (string == null) {
            return;
        }
        if (watches == null) {
            watches = new HashMap();
        }
        if (!watches.containsKey(string)) {
            watches.put(string, null);
        }
    }

    public static synchronized void removeWatch(String string) {
        if (watches != null && string != null) {
            watches.remove(string);
        }
    }

    public static void readPreferences() {
        if (!Preferences.initPreferenceManager()) {
            return;
        }
        try {
            Preferences.clearCache();
            java.util.prefs.Preferences preferences = NbPreferences.forModule(DummyCorePreference.class);
            reconnectLinks = preferences.getBoolean(RECONNECT_LINKS, true);
            promptSaveWorkspace = true;
            defaultElementName = NbBundle.getMessage(Preferences.class, (String)"UNNAMED");
            collectionOverride = preferences.get(COLLECTION_OVERRIDE, "java.util.ArrayList");
            confirmSourceDelete = Preferences.getPreference(CONFIRM_SOURCE_DELETE);
            Preferences.readWatchedPreferences();
        }
        catch (ClobberedException clobberedException) {
            Log.stackTrace((Throwable)clobberedException);
            UMLSupport.reviveDescribe();
            Preferences.readPreferences();
        }
    }

    public static void clearCache() {
        preferenceCache.clear();
    }

    private static synchronized void readWatchedPreferences() {
        if (watches == null || watchers == null) {
            return;
        }
        Iterator iterator = watches.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null) {
                try {
                    iterator.remove();
                }
                catch (Exception exception) {}
                continue;
            }
            String string2 = Preferences.getPreference(string);
            String string3 = (String)watches.get(string);
            if (string2 == null && string3 == null || string2 != null && string2.equals(string3) || string3 != null && string3.equals(string2)) continue;
            watches.put(string, string2);
            Preferences.firePreferenceChanged(string, string3, string2);
        }
    }

    private static void firePreferenceChanged(String string, String string2, String string3) {
        if (watchers == null) {
            return;
        }
        Collection collection = Preferences.getWatchers(string);
        Preferences.firePreferenceChanged(collection, string, string2, string3);
        collection = Preferences.getWatchers("");
        Preferences.firePreferenceChanged(collection, string, string2, string3);
    }

    private static void firePreferenceChanged(Collection collection, String string, String string2, String string3) {
        if (collection == null) {
            return;
        }
        for (PreferenceWatcher preferenceWatcher : collection) {
            if (preferenceWatcher == null) continue;
            try {
                preferenceWatcher.preferenceChanged(string, string2, string3);
            }
            catch (Exception exception) {
                Log.stackTrace((Throwable)exception);
            }
        }
    }

    private static Collection getWatchers(String string) {
        return (Collection)watchers.get(string);
    }

    public static void reset() {
        prefMan = null;
    }

    public static boolean isPromptProjectLocation() {
        throw new UnsupportedOperationException("This pref is no long valid.");
    }

    public static boolean isPromptSaveWorkspace() {
        return promptSaveWorkspace;
    }

    public static boolean isPromptWksLocation() {
        throw new UnsupportedOperationException("This pref is no long valid.");
    }

    public static boolean isReconnectLinks() {
        return reconnectLinks;
    }

    public static boolean isCreateNewDiagram() {
        return true;
    }

    public static boolean getUseGenericsDefault() {
        return NbPreferences.forModule(DummyCorePreference.class).getBoolean(USE_GENERICS_DEFAULT, true);
    }

    public static String getDefaultWorkspacePath() {
        if (defaultWorkspaceLocation == null || defaultWorkspaceLocation.trim().length() == 0) {
            UMLSupport uMLSupport = UMLSupport.getUMLSupport();
            String string = UMLSupport.getUMLSupport().getIDEManager().getDefaultWorkspaceDirectory();
            Log.out((String)("readPreferences: IDE's workspace folder : " + string));
            try {
                File file = null;
                file = string != null && string.trim().length() > 0 ? new File(new File(string), DEF_WKS_FILE) : new File(new File(uMLSupport.getApplication().getInstallLocation()).getParentFile().getParentFile(), REL_DEF_WKS_LOC);
                return file.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (defaultWorkspaceLocation != null && defaultWorkspaceLocation.trim().length() == 0) {
            defaultWorkspaceLocation = null;
        }
        return defaultWorkspaceLocation;
    }

    public static boolean isDefaultWorkspacePathEmpty() {
        return defaultWorkspaceLocation == null || defaultWorkspaceLocation.trim().length() == 0;
    }

    public static void setDefaultWorkspacePath(String string) {
        throw new UnsupportedOperationException("DefaultWSLocation pref is no long valid.");
    }

    public static void setPromptWksLocation(boolean bl) {
        throw new UnsupportedOperationException("This pref is no long valid.");
    }

    public static void setDeleteFileWithArtifact(String string) {
        confirmSourceDelete = string;
        Preferences.setPreference(CONFIRM_SOURCE_DELETE, string);
    }

    public static String getDeleteFileWithArtifact() {
        return confirmSourceDelete;
    }

    public static void setReconnectLinks(boolean bl) {
        reconnectLinks = bl;
        Preferences.setPreference(RECONNECT_LINKS, bl ? PSK_YES : PSK_NO);
    }

    public static String getDefaultElementName() {
        return NbBundle.getMessage(Preferences.class, (String)"UNNAMED");
    }

    public static String getCollectionOverride() {
        if (collectionOverride == null) {
            collectionOverride = Preferences.getPreference(COLLECTION_OVERRIDE);
        }
        return collectionOverride;
    }

    public static void removePreference(String string) {
        String string2;
        if (string == null || !Preferences.initPreferenceManager()) {
            return;
        }
        int n = string.lastIndexOf("|");
        String string3 = n != -1 ? string.substring(0, n) : "";
        IPropertyElement iPropertyElement = prefMan.getPreferenceElement(string3, string2 = string.substring(n + 1));
        if (iPropertyElement != null) {
            Log.out((String)("removePreference(): Removing preference - " + string));
            prefMan.removePreference(iPropertyElement);
        } else {
            Log.out((String)("removePreference(): Could not locate preference to delete - " + string));
        }
    }

    private static boolean getBooleanPreference(String string) {
        String string2 = Preferences.getPreference(string);
        if (string2 == null && UMLSupport.isClobbered()) {
            throw new ClobberedException();
        }
        return PSK_YES.equals(Preferences.getPreference(string));
    }

    private static String getPreference(String string) {
        if (string == null || !Preferences.initPreferenceManager()) {
            return null;
        }
        if (preferenceCache.containsKey(string)) {
            return (String)preferenceCache.get(string);
        }
        int n = string.lastIndexOf("|");
        String string2 = n != -1 ? string.substring(0, n) : "";
        String string3 = string.substring(n + 1);
        try {
            String string4 = prefMan.getPreferenceValue(string2, string3);
            if (string4 != null && string4.trim().length() == 0) {
                string4 = null;
            }
            preferenceCache.put(string, string4);
            return string4;
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
            return null;
        }
    }

    private static void setPreference(String string, String string2) {
        int n;
        if (string == null || !Preferences.initPreferenceManager()) {
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        String string3 = (n = string.lastIndexOf("|")) != -1 ? string.substring(0, n) : "";
        String string4 = string.substring(n + 1);
        try {
            prefMan.setPreferenceValue(string3, string4, string2);
            preferenceCache.put(string, string2);
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
        }
    }

    private static boolean initPreferenceManager() {
        if (!UMLSupport.getUMLSupport().isConnected()) {
            return false;
        }
        prefMan = null;
        try {
            UMLSupport.getUMLSupport();
            prefMan = UMLSupport.getProduct().getPreferenceManager();
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
        }
        boolean bl = prefMan != null;
        return bl;
    }

    static {
        prefMan = null;
        REL_DEF_WKS_LOC = "Workspaces/Default/Default.etw";
        DEF_WKS_FILE = "Default.etw";
        preferenceCache = new HashMap();
    }

    static class ClobberedException
    extends RuntimeException {
        ClobberedException() {
        }
    }

    public static interface PreferenceWatcher {
        public void preferenceChanged(String var1, String var2, String var3);
    }
}

