/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.includeview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.navigation.includeview.IncludeNode;
import org.netbeans.modules.cnd.navigation.services.HierarchyFactory;
import org.netbeans.modules.cnd.navigation.services.IncludedModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class IncludeHierarchyPanel
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    public static final String ICON_PATH = "org/netbeans/modules/cnd/navigation/includeview/resources/tree.png";
    private AbstractNode root;
    private transient ExplorerManager explorerManager = new ExplorerManager();
    private CsmUID<CsmFile> object;
    private boolean recursive = true;
    private boolean plain = true;
    private boolean whoIncludes = true;
    private Action[] actions;
    private Action close;
    private ButtonGroup buttonGroup1;
    private JToggleButton directOnlyButton;
    private JScrollPane hierarchyPane;
    private JPanel jPanel2;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JButton refreshButton;
    private JToolBar toolBar;
    private JToggleButton treeButton;
    private JToggleButton whoIncludesButton;
    private JToggleButton whoIsIncludedButton;
    private static final int WHO_INCLUDES = 1;
    private static final int WHO_IS_INCLUDED = 2;
    private static final int DIRECT_ONLY = 3;
    private static final int TREE = 4;

    public IncludeHierarchyPanel(boolean bl) {
        this.initComponents();
        if (!bl) {
            this.toolBar.remove(0);
            this.toolBar.remove(0);
            this.directOnlyButton.setFocusable(true);
            this.treeButton.setFocusable(true);
            this.whoIncludesButton.setFocusable(true);
            this.whoIsIncludedButton.setFocusable(true);
        }
        this.setName(NbBundle.getMessage(this.getClass(), (String)"CTL_IncludeViewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"HINT_IncludeViewTopComponent"));
        this.getTreeView().setRootVisible(false);
        Children.SortedArray sortedArray = new Children.SortedArray();
        this.actions = bl ? new Action[]{new RefreshAction(), null, new WhoIncludesAction(), new WhoIsIncludedAction(), null, new DirectOnlyAction(), new TreeAction()} : new Action[]{new WhoIncludesAction(), new WhoIsIncludedAction(), null, new DirectOnlyAction(), new TreeAction()};
        this.root = new AbstractNode((Children)sortedArray){

            public Action[] getActions(boolean bl) {
                return IncludeHierarchyPanel.this.actions;
            }
        };
        this.getExplorerManager().setRootContext((Node)this.root);
    }

    public void setClose(Action action) {
        this.close = action;
    }

    public BeanTreeView getTreeView() {
        return (BeanTreeView)this.hierarchyPane;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.refreshButton = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.whoIncludesButton = new JToggleButton();
        this.whoIsIncludedButton = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.directOnlyButton = new JToggleButton();
        this.treeButton = new JToggleButton();
        this.jPanel2 = new JPanel();
        this.hierarchyPane = new BeanTreeView();
        this.setLayout(new GridBagLayout());
        this.toolBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setMaximumSize(new Dimension(182, 26));
        this.toolBar.setMinimumSize(new Dimension(182, 26));
        this.toolBar.setOpaque(false);
        this.toolBar.setPreferredSize(new Dimension(182, 26));
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/includeview/resources/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.refreshButton.toolTipText"));
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setMaximumSize(new Dimension(24, 24));
        this.refreshButton.setMinimumSize(new Dimension(24, 24));
        this.refreshButton.setPreferredSize(new Dimension(24, 24));
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IncludeHierarchyPanel.this.refreshButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.refreshButton);
        this.toolBar.add(this.jSeparator1);
        this.buttonGroup1.add(this.whoIncludesButton);
        this.whoIncludesButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/includeview/resources/who_includes.png")));
        this.whoIncludesButton.setText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.whoIncludesButton.text"));
        this.whoIncludesButton.setToolTipText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.whoIncludesButton.toolTipText"));
        this.whoIncludesButton.setFocusable(false);
        this.whoIncludesButton.setHorizontalTextPosition(0);
        this.whoIncludesButton.setMaximumSize(new Dimension(24, 24));
        this.whoIncludesButton.setMinimumSize(new Dimension(24, 24));
        this.whoIncludesButton.setPreferredSize(new Dimension(24, 24));
        this.whoIncludesButton.setVerticalTextPosition(3);
        this.whoIncludesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IncludeHierarchyPanel.this.whoIncludesButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.whoIncludesButton);
        this.buttonGroup1.add(this.whoIsIncludedButton);
        this.whoIsIncludedButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/includeview/resources/who_is_included.png")));
        this.whoIsIncludedButton.setText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.whoIsIncludedButton.text"));
        this.whoIsIncludedButton.setToolTipText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.whoIsIncludedButton.toolTipText"));
        this.whoIsIncludedButton.setFocusable(false);
        this.whoIsIncludedButton.setHorizontalTextPosition(0);
        this.whoIsIncludedButton.setMaximumSize(new Dimension(24, 24));
        this.whoIsIncludedButton.setMinimumSize(new Dimension(24, 24));
        this.whoIsIncludedButton.setPreferredSize(new Dimension(24, 24));
        this.whoIsIncludedButton.setVerticalTextPosition(3);
        this.whoIsIncludedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IncludeHierarchyPanel.this.whoIsIncludedButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.whoIsIncludedButton);
        this.toolBar.add(this.jSeparator2);
        this.directOnlyButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/includeview/resources/direct_only.png")));
        this.directOnlyButton.setText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.directOnlyButton.text"));
        this.directOnlyButton.setToolTipText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.directOnlyButton.toolTipText"));
        this.directOnlyButton.setFocusable(false);
        this.directOnlyButton.setHorizontalTextPosition(0);
        this.directOnlyButton.setMaximumSize(new Dimension(24, 24));
        this.directOnlyButton.setMinimumSize(new Dimension(24, 24));
        this.directOnlyButton.setPreferredSize(new Dimension(24, 24));
        this.directOnlyButton.setVerticalTextPosition(3);
        this.directOnlyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IncludeHierarchyPanel.this.directOnlyButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.directOnlyButton);
        this.treeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/navigation/includeview/resources/tree.png")));
        this.treeButton.setText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.treeButton.text"));
        this.treeButton.setToolTipText(NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.treeButton.toolTipText"));
        this.treeButton.setFocusable(false);
        this.treeButton.setHorizontalTextPosition(0);
        this.treeButton.setMaximumSize(new Dimension(24, 24));
        this.treeButton.setMinimumSize(new Dimension(24, 24));
        this.treeButton.setPreferredSize(new Dimension(24, 24));
        this.treeButton.setVerticalTextPosition(3);
        this.treeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IncludeHierarchyPanel.this.treeButtonActionPerformed(actionEvent);
            }
        });
        this.toolBar.add(this.treeButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)this.toolBar, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("SplitPane.shadow")));
        this.jPanel2.setMinimumSize(new Dimension(1, 1));
        this.jPanel2.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.hierarchyPane, gridBagConstraints);
    }

    private void refreshButtonActionPerformed(ActionEvent actionEvent) {
        CsmFile csmFile;
        if (this.object != null && (csmFile = (CsmFile)this.object.getObject()) != null) {
            this.update(csmFile);
        }
    }

    private void whoIncludesButtonActionPerformed(ActionEvent actionEvent) {
        this.setWhoIncludes(true);
    }

    private void whoIsIncludedButtonActionPerformed(ActionEvent actionEvent) {
        this.setWhoIncludes(false);
    }

    private void directOnlyButtonActionPerformed(ActionEvent actionEvent) {
        this.setRecursive(!this.directOnlyButton.isSelected());
    }

    private void treeButtonActionPerformed(ActionEvent actionEvent) {
        this.setPlain(!this.treeButton.isSelected());
    }

    private void setRecursive(boolean bl) {
        CsmFile csmFile;
        if (this.object != null && (csmFile = (CsmFile)this.object.getObject()) != null) {
            this.recursive = bl;
            this.updateButtons();
            this.update(csmFile);
        }
    }

    private void setPlain(boolean bl) {
        CsmFile csmFile;
        if (this.object != null && (csmFile = (CsmFile)this.object.getObject()) != null) {
            this.plain = bl;
            this.updateButtons();
            this.update(csmFile);
        }
    }

    private void setWhoIncludes(boolean bl) {
        CsmFile csmFile;
        if (this.object != null && (csmFile = (CsmFile)this.object.getObject()) != null) {
            this.whoIncludes = bl;
            this.updateButtons();
            this.update(csmFile);
        }
    }

    public void setFile(CsmFile csmFile) {
        this.object = csmFile.getUID();
        if (csmFile.isHeaderFile()) {
            this.recursive = false;
            this.plain = true;
            this.whoIncludes = true;
        } else {
            this.recursive = true;
            this.plain = false;
            this.whoIncludes = false;
        }
        this.updateButtons();
        this.update(csmFile);
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.hierarchyPane.requestFocusInWindow();
    }

    private void updateButtons() {
        this.whoIncludesButton.setSelected(this.whoIncludes);
        this.whoIsIncludedButton.setSelected(!this.whoIncludes);
        this.directOnlyButton.setSelected(!this.recursive);
        this.treeButton.setSelected(!this.plain);
    }

    private synchronized void update(final CsmFile csmFile) {
        if (csmFile != null) {
            final Children children = this.root.getChildren();
            if (!Children.MUTEX.isReadAccess()) {
                Children.MUTEX.writeAccess(new Runnable(){

                    public void run() {
                        children.remove(children.getNodes());
                        IncludedModel includedModel = HierarchyFactory.getInstance().buildIncludeHierarchyModel(csmFile, IncludeHierarchyPanel.this.actions, IncludeHierarchyPanel.this.whoIncludes, IncludeHierarchyPanel.this.plain, IncludeHierarchyPanel.this.recursive);
                        includedModel.setCloseWindowAction(IncludeHierarchyPanel.this.close);
                        IncludeNode includeNode = new IncludeNode(csmFile, includedModel, null);
                        children.add(new Node[]{includeNode});
                        try {
                            IncludeHierarchyPanel.this.getExplorerManager().setSelectedNodes(new Node[]{includeNode});
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable((Node)includeNode){
                            final /* synthetic */ Node val$node;
                            {
                                this.val$node = node;
                            }

                            public void run() {
                                ((BeanTreeView)IncludeHierarchyPanel.this.hierarchyPane).expandNode(this.val$node);
                            }
                        });
                    }
                });
            }
        } else {
            final Children children = this.root.getChildren();
            if (!Children.MUTEX.isReadAccess()) {
                Children.MUTEX.writeAccess(new Runnable(){

                    public void run() {
                        children.remove(children.getNodes());
                    }
                });
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private ImageIcon getButtonIcon(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "/org/netbeans/modules/cnd/navigation/includeview/resources/who_includes.png";
                break;
            }
            case 2: {
                string = "/org/netbeans/modules/cnd/navigation/includeview/resources/who_is_included.png";
                break;
            }
            case 3: {
                string = "/org/netbeans/modules/cnd/navigation/includeview/resources/direct_only.png";
                break;
            }
            case 4: {
                string = "/org/netbeans/modules/cnd/navigation/includeview/resources/tree.png";
            }
        }
        return new ImageIcon(this.getClass().getResource(string));
    }

    private String getButtonTooltip(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "IncludeHierarchyPanel.whoIncludesButton.toolTipText";
                break;
            }
            case 2: {
                string = "IncludeHierarchyPanel.whoIsIncludedButton.toolTipText";
                break;
            }
            case 3: {
                string = "IncludeHierarchyPanel.directOnlyButton.toolTipText";
                break;
            }
            case 4: {
                string = "IncludeHierarchyPanel.treeButton.toolTipText";
            }
        }
        return NbBundle.getMessage(this.getClass(), (String)string);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("IncludeView");
    }

    private class TreeAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public TreeAction() {
            this.putValue("Name", IncludeHierarchyPanel.this.getButtonTooltip(4));
            this.putValue("SmallIcon", IncludeHierarchyPanel.this.getButtonIcon(4));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IncludeHierarchyPanel.this.setPlain(!IncludeHierarchyPanel.this.plain);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!IncludeHierarchyPanel.this.plain);
            return this.menuItem;
        }
    }

    private class DirectOnlyAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public DirectOnlyAction() {
            this.putValue("Name", IncludeHierarchyPanel.this.getButtonTooltip(3));
            this.putValue("SmallIcon", IncludeHierarchyPanel.this.getButtonIcon(3));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IncludeHierarchyPanel.this.setRecursive(!IncludeHierarchyPanel.this.recursive);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!IncludeHierarchyPanel.this.recursive);
            return this.menuItem;
        }
    }

    private class WhoIsIncludedAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public WhoIsIncludedAction() {
            this.putValue("Name", IncludeHierarchyPanel.this.getButtonTooltip(2));
            this.putValue("SmallIcon", IncludeHierarchyPanel.this.getButtonIcon(2));
            this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IncludeHierarchyPanel.this.setWhoIncludes(false);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!IncludeHierarchyPanel.this.whoIncludes);
            return this.menuItem;
        }
    }

    private class WhoIncludesAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public WhoIncludesAction() {
            this.putValue("Name", IncludeHierarchyPanel.this.getButtonTooltip(1));
            this.putValue("SmallIcon", IncludeHierarchyPanel.this.getButtonIcon(1));
            this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IncludeHierarchyPanel.this.setWhoIncludes(true);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(IncludeHierarchyPanel.this.whoIncludes);
            return this.menuItem;
        }
    }

    private class RefreshAction
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;

        public RefreshAction() {
            this.putValue("Name", NbBundle.getMessage(IncludeHierarchyPanel.class, (String)"IncludeHierarchyPanel.refreshButton.toolTipText"));
            this.putValue("SmallIcon", IncludeHierarchyPanel.this.refreshButton.getIcon());
            this.menuItem = new JMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IncludeHierarchyPanel.this.refreshButtonActionPerformed(actionEvent);
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }
}

