/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;

public class FieldBreakpoint
extends JPDABreakpoint {
    public static final String PROP_FIELD_NAME = "fieldName";
    public static final String PROP_CLASS_NAME = "className";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointType";
    public static final String PROP_INSTANCE_FILTERS = "instanceFilters";
    public static final String PROP_THREAD_FILTERS = "threadFilters";
    public static final int TYPE_ACCESS = 1;
    public static final int TYPE_MODIFICATION = 2;
    private String className = "";
    private String fieldName = "";
    private int type = 2;
    private String condition = "";
    private Map<JPDADebugger, ObjectVariable[]> instanceFilters;
    private Map<JPDADebugger, JPDAThread[]> threadFilters;

    private FieldBreakpoint() {
    }

    public static FieldBreakpoint create(String string, String string2, int n) {
        FieldBreakpointImpl fieldBreakpointImpl = new FieldBreakpointImpl();
        fieldBreakpointImpl.setClassName(string);
        fieldBreakpointImpl.setFieldName(string2);
        fieldBreakpointImpl.setBreakpointType(n);
        return fieldBreakpointImpl;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        if (string == this.className || string != null && this.className != null && this.className.equals(string)) {
            return;
        }
        String string2 = this.className;
        this.className = string;
        this.firePropertyChange(PROP_CLASS_NAME, string2, string);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string == this.fieldName || string != null && this.fieldName != null && this.fieldName.equals(string)) {
            return;
        }
        String string2 = this.fieldName;
        this.fieldName = string;
        this.firePropertyChange(PROP_FIELD_NAME, string2, this.fieldName);
    }

    public ObjectVariable[] getInstanceFilters(JPDADebugger jPDADebugger) {
        if (this.instanceFilters != null) {
            return this.instanceFilters.get(jPDADebugger);
        }
        return null;
    }

    public void setInstanceFilters(JPDADebugger jPDADebugger, ObjectVariable[] objectVariableArray) {
        Object[] objectArray;
        if (this.instanceFilters == null) {
            this.instanceFilters = new WeakHashMap<JPDADebugger, ObjectVariable[]>();
        }
        if (objectVariableArray != null) {
            this.instanceFilters.put(jPDADebugger, objectVariableArray);
        } else {
            this.instanceFilters.remove(jPDADebugger);
        }
        if (objectVariableArray != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = jPDADebugger;
            objectArray = objectArray2;
            objectArray2[1] = objectVariableArray;
        } else {
            objectArray = null;
        }
        this.firePropertyChange(PROP_INSTANCE_FILTERS, null, objectArray);
    }

    public JPDAThread[] getThreadFilters(JPDADebugger jPDADebugger) {
        if (this.threadFilters != null) {
            return this.threadFilters.get(jPDADebugger);
        }
        return null;
    }

    public void setThreadFilters(JPDADebugger jPDADebugger, JPDAThread[] jPDAThreadArray) {
        Object[] objectArray;
        if (this.threadFilters == null) {
            this.threadFilters = new WeakHashMap<JPDADebugger, JPDAThread[]>();
        }
        if (jPDAThreadArray != null) {
            this.threadFilters.put(jPDADebugger, jPDAThreadArray);
        } else {
            this.threadFilters.remove(jPDADebugger);
        }
        if (jPDAThreadArray != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = jPDADebugger;
            objectArray = objectArray2;
            objectArray2[1] = jPDAThreadArray;
        } else {
            objectArray = null;
        }
        this.firePropertyChange(PROP_THREAD_FILTERS, null, objectArray);
    }

    public int getBreakpointType() {
        return this.type;
    }

    public void setBreakpointType(int n) {
        if (this.type == n) {
            return;
        }
        if (n != 2 && n != 1 && n != 3) {
            throw new IllegalArgumentException();
        }
        int n2 = this.type;
        this.type = n;
        this.firePropertyChange(PROP_BREAKPOINT_TYPE, new Integer(n2), new Integer(n));
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        if (string != null) {
            string = string.trim();
        }
        String string2 = this.condition;
        this.condition = string;
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public String toString() {
        return "FieldBreakpoint " + this.className + "." + this.fieldName;
    }

    private static final class FieldBreakpointImpl
    extends FieldBreakpoint
    implements ChangeListener {
        private FieldBreakpointImpl() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (!(object instanceof Breakpoint.VALIDITY)) {
                throw new UnsupportedOperationException(changeEvent.toString());
            }
            this.setValidity((Breakpoint.VALIDITY)object, changeEvent.toString());
        }
    }
}

