/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import org.netbeans.modules.bpel.core.util.BPELValidationAnnotation;
import org.netbeans.modules.bpel.core.util.BPELValidationListener;
import org.netbeans.modules.bpel.core.util.ExternalModelsValidationTrigger;
import org.netbeans.modules.bpel.core.util.ValidationUtil;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListenerAdapter;
import org.netbeans.modules.soa.ui.util.UI;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.text.Annotatable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPELValidationController
extends ChangeEventListenerAdapter {
    private Timer myTimer = new Timer();
    private BpelModel myBpelModel;
    private List<Validator.ResultItem> myValidationResult;
    private ExternalModelsValidationTrigger myTrigger;
    private List<BPELValidationAnnotation> myAnnotations;
    private Map<BPELValidationListener, Object> myWeaklisteners;
    private static final int DELAY = 5432;

    public BPELValidationController(BpelModel bpelModel) {
        this.myBpelModel = bpelModel;
        this.myWeaklisteners = new WeakHashMap<BPELValidationListener, Object>();
        this.myTrigger = new ExternalModelsValidationTrigger(this);
        this.myAnnotations = new ArrayList<BPELValidationAnnotation>();
        this.myValidationResult = new ArrayList<Validator.ResultItem>();
    }

    public void attach() {
        if (this.myBpelModel != null) {
            this.myBpelModel.addEntityChangeListener((ChangeEventListener)this);
            this.myBpelModel.addEntityChangeListener((ChangeEventListener)this.getTrigger());
            this.getTrigger().loadImports();
        }
    }

    public void detach() {
        if (this.myBpelModel != null) {
            this.myBpelModel.removeEntityChangeListener((ChangeEventListener)this);
            this.myBpelModel.removeEntityChangeListener((ChangeEventListener)this.getTrigger());
            this.getTrigger().clearTrigger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValidationListener(BPELValidationListener bPELValidationListener) {
        Map<BPELValidationListener, Object> map = this.myWeaklisteners;
        synchronized (map) {
            this.myWeaklisteners.put(bPELValidationListener, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValidationListener(BPELValidationListener bPELValidationListener) {
        Map<BPELValidationListener, Object> map = this.myWeaklisteners;
        synchronized (map) {
            this.myWeaklisteners.remove(bPELValidationListener);
        }
    }

    BpelModel getModel() {
        return this.myBpelModel;
    }

    private void modelChanged(ChangeEvent changeEvent) {
        if (changeEvent.isLastInAtomic()) {
            this.startValidation();
        }
    }

    public void triggerValidation() {
        this.triggerValidation(false);
    }

    public void triggerValidation(boolean bl) {
        if (bl && this.getTrigger().isTriggerDirty()) {
            this.startValidation();
        } else if (!bl) {
            this.startValidation();
        }
    }

    public void notifyEvent(ChangeEvent changeEvent) {
        if (!Model.State.VALID.equals((Object)this.myBpelModel.getState())) {
            return;
        }
        this.modelChanged(changeEvent);
    }

    public void notifyCompleteValidationResults(List<Validator.ResultItem> list) {
        this.notifyListeners(list);
    }

    private synchronized void startValidation() {
        TimerTask timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread.currentThread().setPriority(1);
                Validation validation = new Validation();
                UI.log();
                UI.log((Object)"START VALIDATION");
                UI.startTimeln();
                validation.validate((Model)BPELValidationController.this.myBpelModel, Validation.ValidationType.PARTIAL);
                UI.endTime((Object)"FAST VALIDATION");
                UI.log((Object)"END VALIDATION");
                List list = validation.getValidationResult();
                BPELValidationController.this.myValidationResult = new ArrayList();
                List list2 = list;
                synchronized (list2) {
                    for (Validator.ResultItem resultItem : list) {
                        BPELValidationController.this.myValidationResult.add(resultItem);
                    }
                }
                BPELValidationController.this.notifyListeners(BPELValidationController.this.myValidationResult);
            }
        };
        UI.log();
        UI.log((Object)"TIMER");
        this.myTimer.cancel();
        this.myTimer = new Timer();
        this.myTimer.schedule(timerTask, 5432L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(List<Validator.ResultItem> list) {
        Map<BPELValidationListener, Object> map = this.myWeaklisteners;
        synchronized (map) {
            for (BPELValidationListener bPELValidationListener : this.myWeaklisteners.keySet()) {
                if (bPELValidationListener == null) continue;
                bPELValidationListener.validationUpdated(list);
            }
        }
        this.showAnnotationsInEditor(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAnnotationsInEditor(List<Validator.ResultItem> list) {
        List<BPELValidationAnnotation> list2 = this.myAnnotations;
        synchronized (list2) {
            LinkedList<Validator.ResultItem> linkedList;
            Object object;
            for (BPELValidationAnnotation iterator : this.myAnnotations) {
                iterator.detach();
            }
            this.myAnnotations.clear();
            HashMap hashMap = new HashMap();
            for (Validator.ResultItem resultItem : list) {
                if (resultItem.getType() != Validator.ResultType.ERROR || (object = ValidationUtil.getLinePart(resultItem)) == null) continue;
                linkedList = (LinkedList<Validator.ResultItem>)hashMap.get(object);
                if (linkedList == null) {
                    linkedList = new LinkedList<Validator.ResultItem>();
                    hashMap.put(object, linkedList);
                }
                linkedList.add(resultItem);
            }
            for (Validator.ResultItem resultItem : hashMap.keySet()) {
                object = new StringBuilder();
                linkedList = (List)hashMap.get(resultItem);
                for (int i = 0; i < linkedList.size(); ++i) {
                    ((StringBuilder)object).append(((Validator.ResultItem)linkedList.get(i)).getDescription());
                    if (i >= linkedList.size() - 1) continue;
                    ((StringBuilder)object).append("\n\n");
                }
                BPELValidationAnnotation bPELValidationAnnotation = new BPELValidationAnnotation();
                this.myAnnotations.add(bPELValidationAnnotation);
                bPELValidationAnnotation.show((Annotatable)resultItem, ((StringBuilder)object).toString());
            }
        }
    }

    private ExternalModelsValidationTrigger getTrigger() {
        return this.myTrigger;
    }

    public List<Validator.ResultItem> getValidationResult() {
        return this.myValidationResult;
    }
}

