/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.core.completion;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.core.completion.CompletionModelImpl;
import org.netbeans.modules.bpel.model.api.resources.ResourcePackageMarker;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelCompletionModelProvider
extends CompletionModelProvider {
    private static final String PROCESS = "process";

    public List<CompletionModelProvider.CompletionModel> getModels(CompletionContext completionContext) {
        if (!this.isBpelFile(completionContext)) {
            return null;
        }
        SchemaModel schemaModel = this.createMetaSchemaModel();
        if (schemaModel == null) {
            return null;
        }
        CompletionModelImpl completionModelImpl = new CompletionModelImpl(schemaModel);
        return Collections.singletonList(completionModelImpl);
    }

    private SchemaModel createMetaSchemaModel() {
        try {
            InputStream inputStream = ResourcePackageMarker.class.getResourceAsStream("wsbpel_2_0.xsd");
            Document document = AbstractDocumentModel.getAccessProvider().loadSwingDocument(inputStream);
            ModelSource modelSource = new ModelSource(Lookups.singleton((Object)document), false);
            SchemaModel schemaModel = (SchemaModel)SchemaModelFactory.getDefault().createFreshModel(modelSource);
            schemaModel.sync();
            return schemaModel;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isBpelFile(CompletionContext completionContext) {
        List list = completionContext.getPathFromRoot();
        if (list != null && list.size() > 0) {
            QName qName = (QName)list.get(0);
            String string = qName.getLocalPart();
            String string2 = qName.getNamespaceURI();
            if (PROCESS.equals(string) && "http://docs.oasis-open.org/wsbpel/2.0/process/executable".equals(string2)) {
                return true;
            }
        }
        return "bpel".equals(completionContext.getPrimaryFile().getExt());
    }
}

