/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.general;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;
import org.netbeans.modules.vmd.midp.general.FileAcceptPresenter;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGImageCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGMenuCD;
import org.netbeans.modules.vmd.midpnb.components.svg.util.SVGUtils;
import org.openide.filesystems.FileObject;

public class SVGFileAcceptPresenter
extends FileAcceptPresenter {
    public SVGFileAcceptPresenter() {
        super("svgImage", SVGImageCD.TYPEID, new String[]{"svg"});
    }

    public ComponentProducer.Result accept(Transferable transferable, AcceptSuggestion acceptSuggestion) {
        ComponentProducer.Result result = super.accept(transferable, acceptSuggestion);
        DesignComponent designComponent = (DesignComponent)result.getComponents().iterator().next();
        DesignComponent designComponent2 = this.getComponent();
        FileObject fileObject = this.getNodeFileObject(transferable);
        if (fileObject == null) {
            return result;
        }
        String string = this.getFileClasspath(fileObject);
        designComponent.writeProperty("resourcePath", MidpTypes.createStringValue((String)string));
        MidpDocumentSupport.getCategoryComponent((DesignDocument)designComponent2.getDocument(), (TypeID)ResourcesCategoryCD.TYPEID).addComponent(designComponent);
        if (designComponent2.getDocument().getDescriptorRegistry().isInHierarchy(SVGMenuCD.TYPEID, designComponent2.getType()) && designComponent2.readProperty("elements").getArray().size() == 0) {
            this.parseSVGMenuItems(transferable, designComponent2);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSVGMenuItems(Transferable transferable, DesignComponent designComponent) {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(transferable);
            if (inputStream != null) {
                SVGUtils.parseSVGMenu(inputStream, designComponent);
            }
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Debug.warning((Object[])new Object[]{iOException});
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            Debug.warning((Object[])new Object[]{iOException});
        }
    }
}

