/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.svg.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midpnb.components.sources.SVGMenuElementEventSourceCD;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class SVGUtils {
    private static final String MENU_ELEMENT_SEARCH_PATTERN = "menuItem_.*";

    private SVGUtils() {
    }

    public static void parseSVGMenu(InputStream inputStream, final DesignComponent designComponent) {
        final String[] stringArray = SVGUtils.getMenuItems(inputStream);
        if (stringArray != null) {
            designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(stringArray.length);
                    for (String string : stringArray) {
                        DesignComponent designComponent2 = designComponent.getDocument().createComponent(SVGMenuElementEventSourceCD.TYPEID);
                        designComponent2.writeProperty("string", MidpTypes.createStringValue((String)string));
                        arrayList.add(PropertyValue.createComponentReference((DesignComponent)designComponent2));
                        designComponent.addComponent(designComponent2);
                    }
                    designComponent.writeProperty("elements", PropertyValue.createArray((TypeID)SVGMenuElementEventSourceCD.TYPEID, arrayList));
                }
            });
        }
    }

    private static String[] getMenuItems(InputStream inputStream) {
        NamedElementsContentHandler namedElementsContentHandler = new NamedElementsContentHandler(MENU_ELEMENT_SEARCH_PATTERN);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(namedElementsContentHandler);
            xMLReader.setEntityResolver(namedElementsContentHandler);
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (IOException iOException) {
            Debug.warning((Object[])new Object[]{iOException});
        }
        catch (SAXException sAXException) {
            Debug.warning((Object[])new Object[]{sAXException});
        }
        namedElementsContentHandler.sortNamedElements();
        return namedElementsContentHandler.getFoundElements();
    }

    private static class NamedElementsContentHandler
    implements ContentHandler,
    EntityResolver {
        private ArrayList<String> foundElements = new ArrayList();
        private Pattern regex;

        public NamedElementsContentHandler(String string) {
            this.regex = Pattern.compile(string);
        }

        public void sortNamedElements() {
            Collections.sort(this.foundElements);
        }

        public String[] getFoundElements() {
            return this.foundElements.toArray(new String[this.foundElements.size()]);
        }

        public final void resetFoundElements() {
            this.foundElements.clear();
        }

        public final void endDocument() throws SAXException {
        }

        public final void startDocument() throws SAXException {
        }

        public final void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public final void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public final void endPrefixMapping(String string) throws SAXException {
        }

        public final void skippedEntity(String string) throws SAXException {
        }

        public final void setDocumentLocator(Locator locator) {
        }

        public final void processingInstruction(String string, String string2) throws SAXException {
        }

        public final void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public final void endElement(String string, String string2, String string3) throws SAXException {
        }

        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = attributes.getValue("id");
            if (string4 != null && this.regex.matcher(string4).matches()) {
                this.foundElements.add(string4);
            }
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

