/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class VerifyJNLP
extends Task {
    private List<FileSet> filesets = new ArrayList<FileSet>();

    public void addConfiguredFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void execute() throws BuildException {
        for (FileSet fs : this.filesets) {
            DirectoryScanner s = fs.getDirectoryScanner(this.getProject());
            File basedir = s.getBasedir();
            for (String incl : s.getIncludedFiles()) {
                this.validate(new File(basedir, incl));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(File jnlp) throws BuildException {
        URI base;
        Document doc;
        this.log("Validating: " + jnlp);
        try {
            doc = XMLUtil.parse(new InputSource(jnlp.toURI().toString()), true, false, new ErrorHandler(){

                public void warning(SAXParseException exception) throws SAXException {
                    this.fatalError(exception);
                }

                public void error(SAXParseException exception) throws SAXException {
                    this.fatalError(exception);
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    throw new SAXException("parse or validation error:\n" + exception.getSystemId() + ":" + exception.getLineNumber() + ": " + exception.getMessage());
                }
            }, new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if ("-//Sun Microsystems, Inc//DTD JNLP Discriptor 1.5//EN".equals(publicId)) {
                        return new InputSource(VerifyJNLP.class.getResource("JNLP-1.5.dtd").toString());
                    }
                    return null;
                }
            });
        }
        catch (Exception x) {
            throw new BuildException((Throwable)x);
        }
        String codebase = doc.getDocumentElement().getAttribute("codebase");
        if (codebase.equals("$$codebase")) {
            base = jnlp.getParentFile().toURI();
        } else {
            try {
                base = new URI(codebase);
                if (!base.isAbsolute()) {
                    throw new BuildException("JNLP validation error\n" + jnlp + ": non-absolute codebase " + base);
                }
                if (!"file".equals(base.getScheme())) {
                    base = jnlp.getParentFile().toURI();
                }
            }
            catch (URISyntaxException x) {
                throw new BuildException("JNLP validation error\n" + jnlp + ": invalid codebase '" + codebase + "': " + x, (Throwable)x);
            }
        }
        Object[] existingCertificates = null;
        File existingSignedJar = null;
        NodeList nl = doc.getElementsByTagName("*");
        block13: for (int i = 0; i < nl.getLength(); ++i) {
            URI u;
            Element el = (Element)nl.item(i);
            String href = el.getAttribute("href");
            if (href.length() <= 0) continue;
            try {
                u = base.resolve(new URI(href));
            }
            catch (URISyntaxException x) {
                throw new BuildException("JNLP validation error\n" + jnlp + ": invalid href '" + href + "': " + x, (Throwable)x);
            }
            assert (u.isAbsolute()) : u + " not absolute as " + href + " resolved against " + base;
            if ("file".equals(u.getScheme())) {
                File f = new File(u);
                if (!f.isFile()) {
                    if (el.getTagName().equals("icon")) {
                        this.log(jnlp + ": warning: no such file " + f, 1);
                    } else {
                        throw new BuildException("JNLP validation error\n" + jnlp + ": no such file " + f);
                    }
                }
                if (el.getTagName().equals("extension")) {
                    this.validate(f);
                    continue;
                }
                if (!el.getTagName().equals("jar")) continue;
                try {
                    JarFile jf = new JarFile(f, true);
                    try {
                        Enumeration<JarEntry> entries = jf.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (entry.getName().startsWith("META-INF/") || entry.getSize() < 1L) continue;
                            InputStream is = jf.getInputStream(entry);
                            int read = 0;
                            while (read != -1) {
                                read = is.read();
                            }
                            Object[] certs = entry.getCertificates();
                            if (existingSignedJar != null && !Arrays.equals(certs, existingCertificates)) {
                                throw new BuildException("JNLP validation error\n" + jnlp + ": different signatures (or signing status) between " + existingSignedJar + " and " + f);
                            }
                            existingCertificates = certs;
                            existingSignedJar = f;
                            continue block13;
                        }
                        continue;
                    }
                    finally {
                        jf.close();
                    }
                }
                catch (IOException x) {
                    throw new BuildException("JNLP validation error\n" + jnlp + ": error examining signatures in " + f + ": " + x, (Throwable)x);
                }
            }
            try {
                u.toURL().openStream().close();
                continue;
            }
            catch (IOException x) {
                this.log(jnlp + ": could not open network URL " + u, 1);
            }
        }
    }
}

