/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.nbbuild.ModuleListParser;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParseProjectXml
extends Task {
    static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    static final String NBM_NS2 = "http://www.netbeans.org/ns/nb-module-project/2";
    static final String NBM_NS3 = "http://www.netbeans.org/ns/nb-module-project/3";
    static final int TYPE_NB_ORG = 0;
    static final int TYPE_SUITE = 1;
    static final int TYPE_STANDALONE = 2;
    private File project;
    private File projectFile;
    private String publicPackagesProperty;
    private String friendsProperty;
    private String javadocPackagesProperty;
    private String moduleDependenciesProperty;
    private String codeNameBaseDashesProperty;
    private String codeNameBaseSlashesProperty;
    private String domainProperty;
    private String moduleClassPathProperty;
    private String moduleRunClassPathProperty;
    private File publicPackageJarDir;
    private String classPathExtensionsProperty;
    public static String testDistLocation;
    List<TestType> testTypes = new LinkedList<TestType>();
    private static String NBM_NS_CACHE;

    public void setProject(File f) {
        this.project = f;
    }

    public void setProjectFile(File f) {
        this.projectFile = f;
    }

    private File getProjectFile() {
        if (this.projectFile != null) {
            return this.projectFile;
        }
        return new File(new File(this.project, "nbproject"), "project.xml");
    }

    public void setPublicPackagesProperty(String s) {
        this.publicPackagesProperty = s;
    }

    public void setFriendsProperty(String s) {
        this.friendsProperty = s;
    }

    public void setJavadocPackagesProperty(String s) {
        this.javadocPackagesProperty = s;
    }

    public void setModuleDependenciesProperty(String s) {
        this.moduleDependenciesProperty = s;
    }

    public void setCodeNameBaseDashesProperty(String s) {
        this.codeNameBaseDashesProperty = s;
    }

    public void setCodeNameBaseSlashesProperty(String s) {
        this.codeNameBaseSlashesProperty = s;
    }

    public void setDomainProperty(String s) {
        this.domainProperty = s;
    }

    public void setModuleClassPathProperty(String s) {
        this.moduleClassPathProperty = s;
    }

    public void setModuleRunClassPathProperty(String s) {
        this.moduleRunClassPathProperty = s;
    }

    public void setPublicPackageJarDir(File d) {
        this.publicPackageJarDir = d;
    }

    public void setClassPathExtensionsProperty(String s) {
        this.classPathExtensionsProperty = s;
    }

    public void addTestType(TestType testType) {
        this.testTypes.add(testType);
    }

    public void add(TestType testType) {
        this.testTypes.add(testType);
    }

    private TestType getTestType(String name) {
        for (TestType testType : this.testTypes) {
            if (!testType.getName().equals(name)) continue;
            return testType;
        }
        return null;
    }

    private void define(String prop, String val) {
        this.log("Setting " + prop + "=" + val, 3);
        String old = this.getProject().getProperty(prop);
        if (old != null && !old.equals(val)) {
            this.getProject().log("Warning: " + prop + " was already set to " + old, 1);
        }
        this.getProject().setNewProperty(prop, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            String val;
            String cp;
            String cnb;
            String[] friends;
            int i$;
            StringBuffer b;
            Document pDoc;
            block44: {
                if (this.getProjectFile() == null) {
                    throw new BuildException("You must set 'project' or 'projectfile'", this.getLocation());
                }
                pDoc = XMLUtil.parse(new InputSource(this.getProjectFile().toURI().toString()), false, true, null, null);
                if (this.publicPackagesProperty != null || this.javadocPackagesProperty != null) {
                    PublicPackage[] pkgs = this.getPublicPackages(pDoc);
                    if (this.publicPackagesProperty != null) {
                        String val2;
                        if (pkgs.length > 0) {
                            String sep = "";
                            StringBuffer b2 = new StringBuffer();
                            for (PublicPackage p : pkgs) {
                                b2.append(sep);
                                String name = p.name;
                                if (name.indexOf(44) >= 0) {
                                    throw new BuildException("Package name cannot contain ',' as " + p, this.getLocation());
                                }
                                if (name.indexOf(42) >= 0) {
                                    throw new BuildException("Package name cannot contain '*' as " + p, this.getLocation());
                                }
                                b2.append(name);
                                if (p.subpackages) {
                                    b2.append(".**");
                                } else {
                                    b2.append(".*");
                                }
                                sep = ", ";
                            }
                            val2 = b2.toString();
                        } else {
                            val2 = "-";
                        }
                        this.define(this.publicPackagesProperty, val2);
                    }
                    if (this.javadocPackagesProperty != null && pkgs.length > 0) {
                        String sep = "";
                        b = new StringBuffer();
                        PublicPackage[] arr$ = pkgs;
                        int len$ = arr$.length;
                        for (i$ = 0; i$ < len$; ++i$) {
                            PublicPackage p = arr$[i$];
                            b.append(sep);
                            if (p.subpackages) {
                                if (this.getProject().getProperty(this.javadocPackagesProperty) == null) {
                                    String msg = this.javadocPackagesProperty + " cannot be set as <subpackages> does not work for Javadoc (see <subpackages>" + p.name + "</subpackages> tag in " + this.getProjectFile() + "). Set the property in project.properties if you want to build Javadoc.";
                                    this.getProject().log("Warning: " + msg, 1);
                                }
                                break block44;
                            }
                            b.append(p.name);
                            sep = ", ";
                        }
                        this.define(this.javadocPackagesProperty, b.toString());
                    }
                }
            }
            if (this.friendsProperty != null && (friends = this.getFriends(pDoc)) != null) {
                StringBuffer b3 = new StringBuffer();
                for (String f : friends) {
                    if (b3.length() > 0) {
                        b3.append(", ");
                    }
                    b3.append(f);
                }
                this.define(this.friendsProperty, b3.toString());
            }
            ModuleListParser modules = null;
            Dep[] deps = null;
            if (this.moduleDependenciesProperty != null || this.moduleClassPathProperty != null || this.moduleRunClassPathProperty != null || this.testTypes.size() > 0) {
                Hashtable properties = this.getProject().getProperties();
                properties.put("project", this.project.getAbsolutePath());
                modules = new ModuleListParser(properties, this.getModuleType(pDoc), this.getProject());
                ModuleListParser.Entry myself = modules.findByCodeNameBase(this.getCodeNameBase(pDoc));
                if (myself == null) {
                    ModuleListParser.resetCaches();
                    modules = new ModuleListParser(properties, this.getModuleType(pDoc), this.getProject());
                    String cnb2 = this.getCodeNameBase(pDoc);
                    myself = modules.findByCodeNameBase(cnb2);
                    assert (myself != null) : "Cannot find myself as " + cnb2;
                }
                deps = this.getDeps(pDoc, modules);
            }
            if (this.moduleDependenciesProperty != null && this.moduleDependenciesProperty != null) {
                b = new StringBuffer();
                Dep[] arr$ = deps;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    void d = arr$[i$];
                    if (!d.run) continue;
                    if (b.length() > 0) {
                        b.append(", ");
                    }
                    b.append(d);
                }
                if (b.length() > 0) {
                    this.define(this.moduleDependenciesProperty, b.toString());
                }
            }
            if (this.codeNameBaseDashesProperty != null) {
                cnb = this.getCodeNameBase(pDoc);
                this.define(this.codeNameBaseDashesProperty, cnb.replace('.', '-'));
            }
            if (this.codeNameBaseSlashesProperty != null) {
                cnb = this.getCodeNameBase(pDoc);
                this.define(this.codeNameBaseSlashesProperty, cnb.replace('.', '/'));
            }
            if (this.moduleClassPathProperty != null) {
                cp = this.computeClasspath(pDoc, modules, deps, false);
                this.define(this.moduleClassPathProperty, cp);
            }
            if (this.moduleRunClassPathProperty != null) {
                cp = this.computeClasspath(pDoc, modules, deps, true);
                this.define(this.moduleRunClassPathProperty, cp);
            }
            if (this.domainProperty != null) {
                if (this.getModuleType(pDoc) != 0) {
                    throw new BuildException("Cannot set " + this.domainProperty + " for a non-netbeans.org module", this.getLocation());
                }
                File nball = new File(this.getProject().getProperty("nb_all"));
                File basedir = this.getProject().getBaseDir();
                Pattern p = Pattern.compile("([^/]+)(/([^/]+))*//([^/]+)/" + Pattern.quote(basedir.getName()));
                FileReader r = new FileReader(new File(nball, "nbbuild/translations"));
                try {
                    String line;
                    BufferedReader br = new BufferedReader(r);
                    while ((line = br.readLine()) != null) {
                        Matcher m = p.matcher(line);
                        if (!m.matches()) continue;
                        this.define(this.domainProperty, m.group(1));
                        break;
                    }
                }
                finally {
                    ((Reader)r).close();
                }
            }
            if (this.classPathExtensionsProperty != null && (val = this.computeClassPathExtensions(pDoc)) != null) {
                this.define(this.classPathExtensionsProperty, val);
            }
            if (modules != null) {
                String testDistLocation = this.getProject().getProperty("test.dist.dir");
                if (testDistLocation == null) {
                    testDistLocation = "${test.dist.dir}";
                }
                ParseProjectXml.testDistLocation = testDistLocation;
                for (TestDeps td : this.getTestDeps(pDoc, modules, this.getCodeNameBase(pDoc))) {
                    TestType testType = this.getTestType(td.testtype);
                    if (testType == null) continue;
                    if (testType.getFolder() != null) {
                        this.define(testType.getFolder(), td.getTestFolder());
                    }
                    if (testType.getCompileCP() != null && td.getCompileClassPath() != null && td.getCompileClassPath().trim().length() > 0) {
                        this.define(testType.getCompileCP(), td.getCompileClassPath());
                    }
                    if (testType.getRuntimeCP() != null && td.getRuntimeClassPath() != null && td.getRuntimeClassPath().trim().length() > 0) {
                        this.define(testType.getRuntimeCP(), td.getRuntimeClassPath());
                    }
                    if (!"unit".equals(td.testtype)) continue;
                    String testCompileDep = td.getTestCompileDep();
                    if (testType.getCompileDep() == null || testCompileDep == null) continue;
                    this.define(testType.getCompileDep(), testCompileDep);
                }
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    private Element getConfig(Document pDoc) throws BuildException {
        Element e = pDoc.getDocumentElement();
        Element c = XMLUtil.findElement(e, "configuration", PROJECT_NS);
        if (c == null) {
            throw new BuildException("No <configuration>", this.getLocation());
        }
        Element d = ParseProjectXml.findNBMElement(c, "data");
        if (d == null) {
            throw new BuildException("No <data> in " + this.getProjectFile(), this.getLocation());
        }
        return d;
    }

    private PublicPackage[] getPublicPackages(Document d) throws BuildException {
        Element cfg = this.getConfig(d);
        Element pp = ParseProjectXml.findNBMElement(cfg, "public-packages");
        if (pp == null) {
            pp = ParseProjectXml.findNBMElement(cfg, "friend-packages");
        }
        if (pp == null) {
            throw new BuildException("No <public-packages>", this.getLocation());
        }
        ArrayList<PublicPackage> pkgs = new ArrayList<PublicPackage>();
        for (Element p : XMLUtil.findSubElements(pp)) {
            String t;
            boolean sub = false;
            if ("friend".equals(p.getNodeName())) continue;
            if (!"package".equals(p.getNodeName())) {
                if (!"subpackages".equals(p.getNodeName())) {
                    throw new BuildException("Strange element name, should be package or subpackages: " + p.getNodeName(), this.getLocation());
                }
                sub = true;
            }
            if ((t = XMLUtil.findText(p)) == null) {
                throw new BuildException("No text in <package>", this.getLocation());
            }
            pkgs.add(new PublicPackage(t, sub));
        }
        return pkgs.toArray(new PublicPackage[pkgs.size()]);
    }

    private String[] getFriends(Document d) throws BuildException {
        Element cfg = this.getConfig(d);
        Element pp = ParseProjectXml.findNBMElement(cfg, "friend-packages");
        if (pp == null) {
            return null;
        }
        ArrayList<String> friends = new ArrayList<String>();
        boolean other = false;
        for (Element p : XMLUtil.findSubElements(pp)) {
            if ("friend".equals(p.getNodeName())) {
                String t = XMLUtil.findText(p);
                if (t == null) {
                    throw new BuildException("No text in <friend>", this.getLocation());
                }
                friends.add(t);
                continue;
            }
            other = true;
        }
        if (friends.isEmpty()) {
            throw new BuildException("Must have at least one <friend> in <friend-packages>", this.getLocation());
        }
        if (!other) {
            throw new BuildException("Must have at least one <package> in <friend-packages>", this.getLocation());
        }
        return friends.toArray(new String[friends.size()]);
    }

    private Dep[] getDeps(Document pDoc, ModuleListParser modules) throws BuildException {
        Element cfg = this.getConfig(pDoc);
        Element md = ParseProjectXml.findNBMElement(cfg, "module-dependencies");
        if (md == null) {
            throw new BuildException("No <module-dependencies>", this.getLocation());
        }
        ArrayList<Dep> deps = new ArrayList<Dep>();
        for (Element dep : XMLUtil.findSubElements(md)) {
            Dep d = new Dep(modules);
            Element cnb = ParseProjectXml.findNBMElement(dep, "code-name-base");
            if (cnb == null) {
                throw new BuildException("No <code-name-base>", this.getLocation());
            }
            String t = XMLUtil.findText(cnb);
            if (t == null) {
                throw new BuildException("No text in <code-name-base>", this.getLocation());
            }
            d.codenamebase = t;
            Element rd = ParseProjectXml.findNBMElement(dep, "run-dependency");
            if (rd != null) {
                Element iv;
                Element sv;
                d.run = true;
                Element rv = ParseProjectXml.findNBMElement(rd, "release-version");
                if (rv != null) {
                    t = XMLUtil.findText(rv);
                    if (t == null) {
                        throw new BuildException("No text in <release-version>", this.getLocation());
                    }
                    d.release = t;
                }
                if ((sv = ParseProjectXml.findNBMElement(rd, "specification-version")) != null) {
                    t = XMLUtil.findText(sv);
                    if (t == null) {
                        throw new BuildException("No text in <specification-version>", this.getLocation());
                    }
                    d.spec = t;
                }
                if ((iv = ParseProjectXml.findNBMElement(rd, "implementation-version")) != null) {
                    d.impl = true;
                }
            }
            d.compile = ParseProjectXml.findNBMElement(dep, "compile-dependency") != null;
            deps.add(d);
        }
        return deps.toArray(new Dep[deps.size()]);
    }

    private String getCodeNameBase(Document d) throws BuildException {
        Element data = this.getConfig(d);
        Element name = ParseProjectXml.findNBMElement(data, "code-name-base");
        if (name == null) {
            throw new BuildException("No <code-name-base>", this.getLocation());
        }
        String t = XMLUtil.findText(name);
        if (t == null) {
            throw new BuildException("No text in <code-name-base>", this.getLocation());
        }
        return t;
    }

    private int getModuleType(Document d) throws BuildException {
        Element data = this.getConfig(d);
        if (ParseProjectXml.findNBMElement(data, "suite-component") != null) {
            return 1;
        }
        if (ParseProjectXml.findNBMElement(data, "standalone") != null) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeClasspath(Document pDoc, ModuleListParser modules, Dep[] deps, boolean runtime) throws BuildException, IOException, SAXException {
        String myCnb = this.getCodeNameBase(pDoc);
        StringBuffer cp = new StringBuffer();
        String includedClustersProp = this.getProject().getProperty("enabled.clusters");
        HashSet<String> includedClusters = includedClustersProp != null ? new HashSet<String>(Arrays.asList(includedClustersProp.split(" *, *"))) : null;
        String excludedClustersProp = this.getProject().getProperty("disabled.clusters");
        HashSet<String> excludedClusters = excludedClustersProp != null ? new HashSet<String>(Arrays.asList(excludedClustersProp.split(" *, *"))) : null;
        String excludedModulesProp = this.getProject().getProperty("disabled.modules");
        HashSet<String> excludedModules = excludedModulesProp != null ? new HashSet<String>(Arrays.asList(excludedModulesProp.split(" *, *"))) : null;
        for (Dep dep : deps) {
            ModuleListParser.Entry entry;
            Attributes attr;
            if (!dep.compile) continue;
            String cnb = dep.codenamebase;
            File depJar = this.computeClasspathModuleLocation(modules, cnb, includedClusters, excludedClusters, excludedModules);
            if (!depJar.isFile()) {
                throw new BuildException("No such classpath entry: " + depJar, this.getLocation());
            }
            JarFile jarFile = new JarFile(depJar, false);
            try {
                attr = jarFile.getManifest().getMainAttributes();
            }
            finally {
                jarFile.close();
            }
            if (!dep.matches(attr)) {
                throw new BuildException("Cannot compile against a module: " + depJar + " because of dependency: " + dep, this.getLocation());
            }
            if (!runtime && Boolean.parseBoolean(attr.getValue("OpenIDE-Module-Deprecated"))) {
                this.log("The module " + cnb + " has been deprecated", 1);
            }
            ArrayList<File> additions = new ArrayList<File>();
            additions.add(depJar);
            if (runtime) {
                HashSet<String> skipCnb = new HashSet<String>();
                this.addRecursiveDeps(additions, modules, cnb, includedClusters, excludedClusters, excludedModules, skipCnb);
            }
            if ((entry = modules.findByCodeNameBase(cnb)) != null) {
                additions.addAll(Arrays.asList(entry.getClassPathExtensions()));
            }
            if (!dep.impl && dep.run) {
                String friends = attr.getValue("OpenIDE-Module-Friends");
                if (friends != null && !Arrays.asList(friends.split(" *, *")).contains(myCnb)) {
                    throw new BuildException("The module " + myCnb + " is not a friend of " + depJar, this.getLocation());
                }
                String pubpkgs = attr.getValue("OpenIDE-Module-Public-Packages");
                if ("-".equals(pubpkgs)) {
                    throw new BuildException("The module " + depJar + " has no public packages and so cannot be compiled against", this.getLocation());
                }
                if (pubpkgs != null && !runtime && this.publicPackageJarDir != null) {
                    File splitJar = this.createPublicPackageJar(additions, pubpkgs, this.publicPackageJarDir, cnb);
                    additions.clear();
                    additions.add(splitJar);
                }
            }
            for (File f : additions) {
                if (cp.length() > 0) {
                    cp.append(':');
                }
                cp.append(f.getAbsolutePath());
            }
        }
        ModuleListParser.Entry entry = modules.findByCodeNameBase(myCnb);
        if (entry == null) {
            throw new IllegalStateException("Cannot find myself as " + myCnb);
        }
        for (File f : entry.getClassPathExtensions()) {
            cp.append(':');
            cp.append(f.getAbsolutePath());
        }
        return cp.toString();
    }

    private void addRecursiveDeps(List<File> additions, ModuleListParser modules, String cnb, Set<String> includedClusters, Set<String> excludedClusters, Set<String> excludedModules, Set<String> skipCnb) {
        if (!skipCnb.add(cnb)) {
            return;
        }
        this.log("Processing for recursive deps: " + cnb, 3);
        for (String nextModule : modules.findByCodeNameBase(cnb).getRuntimeDependencies()) {
            ModuleListParser.Entry entry;
            this.log("  Added dep: " + nextModule, 3);
            File depJar = this.computeClasspathModuleLocation(modules, nextModule, includedClusters, excludedClusters, excludedModules);
            if (!depJar.isFile()) {
                this.log("No such classpath entry: " + depJar, 1);
            }
            if (!additions.contains(depJar)) {
                additions.add(depJar);
            }
            if ((entry = modules.findByCodeNameBase(cnb)) != null) {
                for (File f : entry.getClassPathExtensions()) {
                    if (additions.contains(f)) continue;
                    additions.add(f);
                }
            }
            this.addRecursiveDeps(additions, modules, nextModule, includedClusters, excludedClusters, excludedModules, skipCnb);
        }
    }

    private File computeClasspathModuleLocation(ModuleListParser modules, String cnb, Set<String> includedClusters, Set<String> excludedClusters, Set<String> excludedModules) throws BuildException {
        ModuleListParser.Entry module = modules.findByCodeNameBase(cnb);
        if (module == null) {
            throw new BuildException("No dependent module " + cnb, this.getLocation());
        }
        String cluster = module.getClusterName();
        if (cluster != null) {
            if (includedClusters != null && !includedClusters.isEmpty() && !includedClusters.contains(cluster) || (includedClusters == null || includedClusters.isEmpty()) && excludedClusters != null && excludedClusters.contains(cluster)) {
                throw new BuildException("The module " + cnb + " cannot be compiled against because it is part of the cluster " + cluster + " which has been excluded from the target platform in your suite configuration", this.getLocation());
            }
            if (excludedModules != null && excludedModules.contains(cnb)) {
                throw new BuildException("Module " + cnb + " excluded from the target platform", this.getLocation());
            }
        }
        return module.getJar();
    }

    private String computeClassPathExtensions(Document pDoc) {
        Element data = this.getConfig(pDoc);
        StringBuffer list = null;
        for (Element ext : XMLUtil.findSubElements(data)) {
            if (!ext.getLocalName().equals("class-path-extension")) continue;
            Element runtimeRelativePath = ParseProjectXml.findNBMElement(ext, "runtime-relative-path");
            if (runtimeRelativePath == null) {
                throw new BuildException("Have malformed <class-path-extension> in " + this.getProjectFile(), this.getLocation());
            }
            String reltext = XMLUtil.findText(runtimeRelativePath);
            if (list == null) {
                list = new StringBuffer();
            } else {
                list.append(' ');
            }
            list.append(reltext);
        }
        return list != null ? list.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createPublicPackageJar(List<File> jars, String pubpkgs, File dir, String cnb) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException("No such directory " + dir);
        }
        File ppjar = new File(dir, cnb.replace('.', '-') + ".jar");
        if (ppjar.exists()) {
            boolean uptodate = true;
            long stamp = ppjar.lastModified();
            for (File jar : jars) {
                if (jar.lastModified() <= stamp) continue;
                uptodate = false;
                break;
            }
            if (uptodate) {
                this.log("Distilled " + ppjar + " was already up to date", 3);
                return ppjar;
            }
        }
        this.log("Distilling " + ppjar + " from " + jars);
        String corePattern = pubpkgs.replaceAll(" +", "").replaceAll("\\.", "/").replaceAll(",", "|").replaceAll("\\*\\*", "(.+/)?").replaceAll("\\*", "");
        Pattern p = Pattern.compile("(" + corePattern + ")[^/]+\\.class");
        FileOutputStream os = new FileOutputStream(ppjar);
        try {
            ZipOutputStream zos = new ZipOutputStream(os);
            HashSet<String> addedPaths = new HashSet<String>();
            for (File jar : jars) {
                if (!jar.isFile()) {
                    this.log("Classpath entry " + jar + " does not exist; skipping", 1);
                }
                FileInputStream is = new FileInputStream(jar);
                try {
                    ZipEntry inEntry;
                    ZipInputStream zis = new ZipInputStream(is);
                    while ((inEntry = zis.getNextEntry()) != null) {
                        int read;
                        String path = inEntry.getName();
                        if (!addedPaths.add(path) || !p.matcher(path).matches()) continue;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buf = new byte[4096];
                        while ((read = zis.read(buf)) != -1) {
                            baos.write(buf, 0, read);
                        }
                        byte[] data = baos.toByteArray();
                        ZipEntry outEntry = new ZipEntry(path);
                        outEntry.setSize(data.length);
                        CRC32 crc = new CRC32();
                        crc.update(data);
                        outEntry.setCrc(crc.getValue());
                        zos.putNextEntry(outEntry);
                        zos.write(data);
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            zos.close();
        }
        finally {
            ((OutputStream)os).close();
        }
        return ppjar;
    }

    private TestDeps[] getTestDeps(Document pDoc, ModuleListParser modules, String testCnb) {
        assert (modules != null);
        Element cfg = this.getConfig(pDoc);
        ArrayList<TestDeps> testDepsList = new ArrayList<TestDeps>();
        Element pp = ParseProjectXml.findNBMElement(cfg, "test-dependencies");
        boolean existsUnitTests = false;
        boolean existsQaFunctionalTests = false;
        if (pp != null) {
            for (Element depssEl : XMLUtil.findSubElements(pp)) {
                String testType = ParseProjectXml.findTextOrNull(depssEl, "name");
                if (testType == null) {
                    testType = "unit";
                    existsUnitTests = true;
                } else if (testType.equals("unit")) {
                    existsUnitTests = true;
                } else if (testType.equals("qa-functional")) {
                    existsQaFunctionalTests = true;
                }
                TestDeps testDeps = new TestDeps(testType, testCnb, modules);
                testDepsList.add(testDeps);
                for (Element el : XMLUtil.findSubElements(depssEl)) {
                    if (!el.getTagName().equals("test-dependency")) continue;
                    boolean test = ParseProjectXml.findNBMElement(el, "test") != null;
                    String cnb = ParseProjectXml.findTextOrNull(el, "code-name-base");
                    boolean recursive = ParseProjectXml.findNBMElement(el, "recursive") != null;
                    boolean compile = ParseProjectXml.findNBMElement(el, "compile-dependency") != null;
                    testDeps.addDepenency(new TestDep(cnb, modules, recursive, test, compile, testDeps));
                }
            }
        }
        if (!existsUnitTests) {
            this.log("Default TestDeps for unit", 3);
            testDepsList.add(new TestDeps("unit", testCnb, modules));
        }
        if (!existsQaFunctionalTests) {
            this.log("Default TestDeps for qa-functional", 3);
            testDepsList.add(new TestDeps("qa-functional", testCnb, modules));
        }
        return testDepsList.toArray(new TestDeps[testDepsList.size()]);
    }

    static String findTextOrNull(Element parentElement, String elementName) {
        Element el = ParseProjectXml.findNBMElement(parentElement, elementName);
        return el == null ? null : XMLUtil.findText(el);
    }

    static Element findNBMElement(Element el, String name) {
        Element retEl = XMLUtil.findElement(el, name, NBM_NS_CACHE);
        if (retEl == null) {
            NBM_NS_CACHE = NBM_NS_CACHE == NBM_NS3 ? NBM_NS2 : NBM_NS3;
            retEl = XMLUtil.findElement(el, name, NBM_NS_CACHE);
        }
        return retEl;
    }

    static {
        NBM_NS_CACHE = NBM_NS3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class TestDep {
        final ModuleListParser modulesParser;
        final String cnb;
        final boolean recursive;
        final boolean test;
        final boolean compile;
        TestDeps testDeps;

        TestDep(String cnb, ModuleListParser modules, boolean recursive, boolean test, boolean compile, TestDeps testDeps) {
            this.modulesParser = modules;
            this.cnb = cnb;
            this.recursive = recursive;
            this.test = test;
            this.testDeps = testDeps;
            this.compile = compile;
        }

        List<ModuleListParser.Entry> getModules() {
            ArrayList<ModuleListParser.Entry> entries = new ArrayList<ModuleListParser.Entry>();
            if (this.recursive) {
                HashMap<String, ModuleListParser.Entry> entriesMap = new HashMap<String, ModuleListParser.Entry>();
                this.addRecursiveModules(this.cnb, entriesMap);
                entries.addAll(entriesMap.values());
            } else {
                ModuleListParser.Entry entry = this.modulesParser.findByCodeNameBase(this.cnb);
                if (entry == null) {
                    this.testDeps.addMisingEntry(this.cnb);
                } else {
                    entries.add(this.modulesParser.findByCodeNameBase(this.cnb));
                }
            }
            return entries;
        }

        private void addRecursiveModules(String cnd, Map<String, ModuleListParser.Entry> entriesMap) {
            if (!entriesMap.containsKey(cnd)) {
                ModuleListParser.Entry entry = this.modulesParser.findByCodeNameBase(cnd);
                if (entry == null) {
                    this.testDeps.addMisingEntry(cnd);
                } else {
                    entriesMap.put(cnd, entry);
                    String[] cnds = entry.getRuntimeDependencies();
                    if (cnds != null) {
                        for (String c : cnds) {
                            this.addRecursiveModules(c, entriesMap);
                        }
                    }
                }
            }
        }

        List<String> getFiles(boolean compile) {
            ArrayList<String> files = new ArrayList<String>();
            if (!compile || compile && this.compile) {
                String jarPath;
                List<ModuleListParser.Entry> modules = this.getModules();
                for (ModuleListParser.Entry entry : this.getModules()) {
                    if (entry != null) {
                        files.add(entry.getJar().getAbsolutePath());
                        continue;
                    }
                    ParseProjectXml.this.log("Entry doesn't exist.");
                }
                if (this.test && (jarPath = this.getTestJarPath()) != null) {
                    files.add(jarPath);
                }
            }
            return files;
        }

        public String getTestJarPath() {
            String sep = File.separator;
            ModuleListParser.Entry entry = this.modulesParser.findByCodeNameBase(this.cnb);
            if (entry == null) {
                this.testDeps.addMisingEntry(this.cnb);
                return null;
            }
            String cluster = entry.getClusterName();
            if (cluster == null) {
                cluster = "cluster";
            }
            return testDistLocation + sep + this.testDeps.testtype + sep + cluster + sep + this.cnb.replace('.', '-') + sep + "tests.jar";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class TestDeps {
        public static final String UNIT = "unit";
        public static final String QA_FUNCTIONAL = "qa-functional";
        final String testtype;
        final List<TestDep> dependencies = new ArrayList<TestDep>();
        final String cnb;
        final ModuleListParser modulesParser;
        private Set<String> missingEntries;
        public static final String TEST_DIST_VAR = "test.dist.dir";

        public TestDeps(String testtype, String cnb, ModuleListParser modulesParser) {
            assert (modulesParser != null);
            this.testtype = testtype;
            this.cnb = cnb;
            this.modulesParser = modulesParser;
        }

        public List<String> getFiles(boolean compile) {
            ArrayList<String> files = new ArrayList<String>();
            for (TestDep d : this.dependencies) {
                files.addAll(d.getFiles(compile));
            }
            return files;
        }

        public void addDepenency(TestDep dep) {
            this.dependencies.add(dep);
        }

        private String getTestFolder() {
            ModuleListParser.Entry entry = this.modulesParser.findByCodeNameBase(this.cnb);
            String sep = "/";
            String cluster = entry.getClusterName();
            if (cluster == null) {
                cluster = "cluster";
            }
            return testDistLocation + sep + this.testtype + sep + cluster + sep + this.cnb.replace('.', '-');
        }

        String getCompileClassPath() {
            return this.getPath(this.getFiles(true)) + this.getMissingEntries();
        }

        private String getPath(List<String> files) {
            StringBuffer path = new StringBuffer();
            HashSet<String> filesSet = new HashSet<String>();
            for (String filePath : files) {
                if (filesSet.contains(filePath)) continue;
                if (path.length() > 0) {
                    path.append(File.pathSeparatorChar);
                }
                filesSet.add(filePath);
                path.append(filePath);
            }
            return path.toString().replace(File.separatorChar, '/');
        }

        String getRuntimeClassPath() {
            return this.getPath(this.getFiles(false)) + this.getMissingEntries();
        }

        public String getTestCompileDep() {
            HashSet<String> cnbs = new HashSet<String>();
            StringBuilder builder = new StringBuilder();
            this.computeCompileDep(this.cnb, cnbs, builder);
            return builder.length() > 0 ? builder.toString() : null;
        }

        private void computeCompileDep(String cnb, Set<String> cnbs, StringBuilder sb) {
            String[] testDeps;
            if (cnbs.contains(cnb)) {
                return;
            }
            ModuleListParser.Entry entry = this.modulesParser.findByCodeNameBase(cnb);
            if (!cnbs.isEmpty() && entry != null) {
                String nborgPath;
                for (TestDep td : this.dependencies) {
                    if (!cnb.equals(td.cnb) || !new File(td.getTestJarPath()).exists()) continue;
                    return;
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if ((nborgPath = entry.getNetbeansOrgPath()) != null) {
                    sb.append(nborgPath);
                }
            }
            cnbs.add(cnb);
            if (entry != null && (testDeps = entry.getTestDependencies()) != null) {
                for (String cnb2 : testDeps) {
                    this.computeCompileDep(cnb2, cnbs, sb);
                }
            }
        }

        public void addMisingEntry(String cnd) {
            if (this.missingEntries == null) {
                this.missingEntries = new HashSet<String>();
            }
            this.missingEntries.add(cnd);
        }

        public String getMissingEntries() {
            if (this.missingEntries != null) {
                StringBuilder builder = new StringBuilder();
                builder.append("\n-missing-Module-Entries-: ");
                for (String cnd : this.missingEntries) {
                    builder.append(cnd);
                    builder.append("\n");
                }
                return builder.toString();
            }
            return "";
        }
    }

    private final class Dep {
        private final ModuleListParser modules;
        public String codenamebase;
        public String release = null;
        public String spec = null;
        public boolean impl = false;
        public boolean compile = false;
        public boolean run = false;

        public Dep(ModuleListParser modules) {
            this.modules = modules;
        }

        public String toString() throws BuildException {
            StringBuffer b = new StringBuffer(this.codenamebase);
            if (this.release != null) {
                b.append('/');
                b.append(this.release);
            }
            if (this.spec != null) {
                b.append(" > ");
                b.append(this.spec);
                assert (!this.impl);
            }
            if (this.impl) {
                b.append(" = ");
                String implVers = this.implementationVersionOf(this.modules, this.codenamebase);
                if (implVers == null) {
                    throw new BuildException("No OpenIDE-Module-Implementation-Version found in " + this.codenamebase);
                }
                b.append(implVers);
            }
            return b.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String implementationVersionOf(ModuleListParser modules, String cnb) throws BuildException {
            String string;
            File jar = ParseProjectXml.this.computeClasspathModuleLocation(modules, cnb, null, null, null);
            if (!jar.isFile()) {
                throw new BuildException("No such classpath entry: " + jar, ParseProjectXml.this.getLocation());
            }
            JarFile jarFile = new JarFile(jar, false);
            try {
                string = jarFile.getManifest().getMainAttributes().getValue("OpenIDE-Module-Implementation-Version");
            }
            catch (Throwable throwable) {
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e, ParseProjectXml.this.getLocation());
                }
            }
            jarFile.close();
            return string;
        }

        private boolean matches(Attributes attr) {
            String givenCodeName = attr.getValue("OpenIDE-Module");
            int slash = givenCodeName.indexOf(47);
            int givenRelease = -1;
            if (slash != -1) {
                assert (this.codenamebase.equals(givenCodeName.substring(0, slash)));
                givenRelease = Integer.parseInt(givenCodeName.substring(slash + 1));
            }
            if (this.release != null) {
                int dash = this.release.indexOf(45);
                if (dash == -1) {
                    if (Integer.parseInt(this.release) != givenRelease) {
                        return false;
                    }
                } else {
                    int lower = Integer.parseInt(this.release.substring(0, dash));
                    int upper = Integer.parseInt(this.release.substring(dash + 1));
                    if (givenRelease < lower || givenRelease > upper) {
                        return false;
                    }
                }
            } else if (this.run && givenRelease != -1) {
                return false;
            }
            if (this.spec != null) {
                String givenSpec = attr.getValue("OpenIDE-Module-Specification-Version");
                if (givenSpec == null) {
                    return false;
                }
                int[] specVals = this.digitize(this.spec);
                int[] givenSpecVals = this.digitize(givenSpec);
                int len1 = specVals.length;
                int len2 = givenSpecVals.length;
                int max = Math.max(len1, len2);
                for (int i = 0; i < max; ++i) {
                    int d2;
                    int d1 = i < len1 ? specVals[i] : 0;
                    int n = d2 = i < len2 ? givenSpecVals[i] : 0;
                    if (d1 < d2) break;
                    if (d1 <= d2) continue;
                    return false;
                }
            }
            return !this.impl || attr.getValue("OpenIDE-Module-Implementation-Version") != null;
        }

        private int[] digitize(String spec) throws NumberFormatException {
            StringTokenizer tok = new StringTokenizer(spec, ".");
            int len = tok.countTokens();
            int[] digits = new int[len];
            for (int i = 0; i < len; ++i) {
                digits[i] = Integer.parseInt(tok.nextToken());
            }
            return digits;
        }
    }

    private static final class PublicPackage {
        public final String name;
        public boolean subpackages;

        public PublicPackage(String name, boolean subpackages) {
            this.name = name;
            this.subpackages = subpackages;
        }
    }

    public static class TestType {
        private String name;
        private String folder;
        private String runtimeCP;
        private String compileCP;
        private String compileDep;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFolder() {
            return this.folder;
        }

        public void setFolder(String folder) {
            this.folder = folder;
        }

        public String getRuntimeCP() {
            return this.runtimeCP;
        }

        public void setRuntimeCP(String runtimeCP) {
            this.runtimeCP = runtimeCP;
        }

        public String getCompileCP() {
            return this.compileCP;
        }

        public void setCompileCP(String compileCP) {
            this.compileCP = compileCP;
        }

        public String getCompileDep() {
            return this.compileDep;
        }

        public void setCompileDep(String compileDep) {
            this.compileDep = compileDep;
        }
    }
}

