/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.jlayout;

import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.service.layout.jlayout.AccessiblityUtils;
import com.tomsawyer.editor.service.layout.jlayout.TSERoutingTab;
import com.tomsawyer.service.TSServiceInputData;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class TSERoutingTabExt
extends TSERoutingTab {
    public static TSEResourceBundleWrapper tsBundle = TSEResourceBundleWrapper.getSystemLabelBundle();

    public TSERoutingTabExt(TSEGraph tSEGraph, TSServiceInputData tSServiceInputData, JDialog jDialog) {
        super(tSEGraph, tSServiceInputData, jDialog);
        this.setA11yFeatures();
    }

    protected JPanel makeHorizontalSpacingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(0);
        JPanel jPanel2 = this.createBoxLayoutPanel(1);
        JPanel jPanel3 = this.createBoxLayoutPanel(1);
        this.horizontalSpacingBetweenNodesField = this.createDoubleField(4, 0.0, 9999.0);
        this.horizontalSpacingBetweenEdgesField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel = this.createLabel("Spacing_Between_Nodes", "Horizontal_Spacing_Between_Nodes", (Component)this.horizontalSpacingBetweenNodesField);
        JLabel jLabel2 = this.createLabel("Spacing_Between_Edges", null, (Component)this.horizontalSpacingBetweenEdgesField);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.horizontalSpacingBetweenNodesField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.horizontalSpacingBetweenEdgesField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(20));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Horizontal_Spacing", 0, 6, 5, 6);
        return jPanel;
    }

    protected JPanel makeVerticalSpacingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(0);
        JPanel jPanel2 = this.createBoxLayoutPanel(1);
        JPanel jPanel3 = this.createBoxLayoutPanel(1);
        this.verticalSpacingBetweenNodesField = this.createDoubleField(4, 0.0, 9999.0);
        this.verticalSpacingBetweenEdgesField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel = this.createLabel("Spacing_Between_Nodes", "Vertical_Spacing_Between_Nodes", (Component)this.verticalSpacingBetweenNodesField);
        JLabel jLabel2 = this.createLabel("Spacing_Between_Edges", null, (Component)this.verticalSpacingBetweenEdgesField);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.verticalSpacingBetweenNodesField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.verticalSpacingBetweenEdgesField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(20));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Vertical_Spacing", 0, 6, 5, 6);
        return jPanel;
    }

    protected JPanel createBoxLayoutPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, n));
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(0.0f);
        return jPanel;
    }

    protected JLabel createLabel(String string, String string2, Component component) {
        JLabel jLabel = new JLabel(tsBundle.getStringSafely(string) + ":");
        jLabel.setForeground(this.labelColor);
        jLabel.setAlignmentX(0.0f);
        jLabel.setAlignmentY(0.0f);
        jLabel.setLabelFor(component);
        if (string2 != null) {
            jLabel.setDisplayedMnemonic(AccessiblityUtils.getMnemonic(string2));
        }
        return jLabel;
    }

    public void createCompoundBorder(JPanel jPanel, String string, int n, int n2, int n3, int n4) {
        String string2 = tsBundle.getStringSafely(string);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string2);
        titledBorder.setTitleColor(this.labelColor);
        jPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(n, n2, n3, n4)));
    }

    protected int normalizeComponentDimensions(List list, boolean bl, boolean bl2) {
        return 0;
    }

    public void setA11yFeatures() {
        Font font = this.getFont();
        this.fixNodeSizesCheckBox.setMnemonic(AccessiblityUtils.getMnemonic("Fix_Node_Sizes"));
        this.fixNodeSizesCheckBox.setFont(font);
        this.fixNodePositionsCheckBox.setFont(font);
        AccessiblityUtils.setAccessibleProperties((Component)this.horizontalSpacingBetweenNodesField, null, "Horizontal_Spacing_Between_Nodes");
        AccessiblityUtils.setAccessibleProperties((Component)this.verticalSpacingBetweenNodesField, null, "Vertical_Spacing_Between_Nodes");
        AccessiblityUtils.setAccessibleProperties((Component)this.horizontalSpacingBetweenEdgesField, null, "Horizontal_Spacing_Between_Edges");
        AccessiblityUtils.setAccessibleProperties((Component)this.verticalSpacingBetweenEdgesField, null, "Vertical_Spacing_Between_Edges");
        AccessiblityUtils.setAccessibleProperties(this.fixNodeSizesCheckBox, null, "Fix_Node_Sizes");
        AccessiblityUtils.setAccessibleProperties(this.fixNodePositionsCheckBox, null, "Fix_Node_Positions");
        this.getAccessibleContext().setAccessibleDescription(this.getAccessibleContext().getAccessibleName());
    }
}

