/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.jlayout;

import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.service.layout.jlayout.AccessiblityUtils;
import com.tomsawyer.editor.service.layout.jlayout.TSEOrthogonalTab;
import com.tomsawyer.service.TSServiceInputData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class TSEOrthogonalTabExt
extends TSEOrthogonalTab {
    public static TSEResourceBundleWrapper tsBundle = TSEResourceBundleWrapper.getSystemLabelBundle();

    public TSEOrthogonalTabExt(TSEGraph tSEGraph, TSServiceInputData tSServiceInputData, JDialog jDialog) {
        super(tSEGraph, tSServiceInputData, jDialog);
        this.setA11yFeatures();
    }

    protected JPanel makeHorizontalSpacingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(0);
        JPanel jPanel2 = this.createBoxLayoutPanel(1);
        JPanel jPanel3 = this.createBoxLayoutPanel(1);
        this.horizontalSpacingBetweenNodesField = this.createDoubleField(4, 0.0, 9999.0);
        this.horizontalSpacingBetweenEdgesField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel = this.createLabel("Spacing_Between_Nodes", "Horizontal_Spacing_Between_Nodes", (Component)this.horizontalSpacingBetweenNodesField);
        JLabel jLabel2 = this.createLabel("Spacing_Between_Edges", null, (Component)this.horizontalSpacingBetweenEdgesField);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.horizontalSpacingBetweenNodesField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.horizontalSpacingBetweenEdgesField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(20));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Horizontal_Spacing", 0, 6, 5, 6);
        return jPanel;
    }

    protected JPanel makeVerticalSpacingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(0);
        JPanel jPanel2 = this.createBoxLayoutPanel(1);
        JPanel jPanel3 = this.createBoxLayoutPanel(1);
        this.verticalSpacingBetweenNodesField = this.createDoubleField(4, 0.0, 9999.0);
        this.verticalSpacingBetweenEdgesField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel = this.createLabel("Spacing_Between_Nodes", "Vertical_Spacing_Between_Nodes", (Component)this.verticalSpacingBetweenNodesField);
        JLabel jLabel2 = this.createLabel("Spacing_Between_Edges", null, (Component)this.verticalSpacingBetweenEdgesField);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.verticalSpacingBetweenNodesField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.verticalSpacingBetweenEdgesField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(20));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Vertical_Spacing", 0, 6, 5, 6);
        return jPanel;
    }

    protected JPanel createBoxLayoutPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, n));
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(0.0f);
        return jPanel;
    }

    protected JLabel createLabel(String string, String string2, Component component) {
        JLabel jLabel = new JLabel(tsBundle.getStringSafely(string) + ":");
        jLabel.setForeground(this.labelColor);
        jLabel.setAlignmentX(0.0f);
        jLabel.setAlignmentY(0.0f);
        jLabel.setLabelFor(component);
        if (string2 != null) {
            jLabel.setDisplayedMnemonic(AccessiblityUtils.getMnemonic(string2));
        }
        return jLabel;
    }

    public void createCompoundBorder(JPanel jPanel, String string, int n, int n2, int n3, int n4) {
        String string2 = tsBundle.getStringSafely(string);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string2);
        titledBorder.setTitleColor(this.labelColor);
        jPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(n, n2, n3, n4)));
    }

    protected int normalizeComponentDimensions(List list, boolean bl, boolean bl2) {
        int n = -1;
        if (list != null && list.size() > 0) {
            JComponent jComponent;
            Serializable serializable;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                serializable = (JComponent)iterator.next();
                if (!(serializable instanceof JPanel)) continue;
                jComponent = (JPanel)serializable;
                n = (int)Math.max(jComponent.getPreferredSize().getWidth(), (double)n);
            }
            serializable = null;
            iterator = list.iterator();
            while (iterator.hasNext()) {
                jComponent = (JComponent)iterator.next();
                if (!(jComponent instanceof JPanel)) continue;
                JComponent jComponent2 = jComponent;
                if (jComponent2.getPreferredSize().width == n) continue;
                serializable = new Dimension(n, (int)jComponent2.getPreferredSize().getHeight());
                jComponent2.setMaximumSize((Dimension)serializable);
            }
        }
        return n;
    }

    public void setA11yFeatures() {
        Font font = this.getFont();
        this.qualityDraftRadioButton.setMnemonic(AccessiblityUtils.getMnemonic("Draft"));
        this.aspectRatioAutomaticRadioButton.setMnemonic(AccessiblityUtils.getMnemonic("Automatic"));
        this.fixNodeSizesCheckBox.setMnemonic(AccessiblityUtils.getMnemonic("Fix_Node_Sizes"));
        this.qualityDraftRadioButton.setFont(font);
        this.qualityDefaultRadioButton.setFont(font);
        this.qualityProofRadioButton.setFont(font);
        this.aspectRatioAutomaticRadioButton.setFont(font);
        this.aspectRatioCustomRadioButton.setFont(font);
        this.aspectRatioDisabledRadioButton.setFont(font);
        this.fixNodeSizesCheckBox.setFont(font);
        AccessiblityUtils.setAccessibleProperties((Component)this.horizontalSpacingBetweenNodesField, null, "Horizontal_Spacing_Between_Nodes");
        AccessiblityUtils.setAccessibleProperties((Component)this.verticalSpacingBetweenNodesField, null, "Vertical_Spacing_Between_Nodes");
        AccessiblityUtils.setAccessibleProperties((Component)this.horizontalSpacingBetweenEdgesField, null, "Horizontal_Spacing_Between_Edges");
        AccessiblityUtils.setAccessibleProperties((Component)this.verticalSpacingBetweenEdgesField, null, "Vertical_Spacing_Between_Edges");
        AccessiblityUtils.setAccessibleProperties(this.qualityDraftRadioButton, null, "Draft");
        AccessiblityUtils.setAccessibleProperties(this.qualityDefaultRadioButton, null, "Default");
        AccessiblityUtils.setAccessibleProperties(this.qualityProofRadioButton, null, "Proof");
        AccessiblityUtils.setAccessibleProperties(this.aspectRatioAutomaticRadioButton, null, "Automatic");
        AccessiblityUtils.setAccessibleProperties(this.aspectRatioCustomRadioButton, null, "Aspect_Ratio_Custom");
        AccessiblityUtils.setAccessibleProperties((Component)this.aspectRatioCustomField, "Aspect_Ratio_Custom", "Aspect_Ratio_Custom");
        AccessiblityUtils.setAccessibleProperties(this.aspectRatioDisabledRadioButton, null, "Disabled");
        AccessiblityUtils.setAccessibleProperties(this.fixNodeSizesCheckBox, null, "Fix_Node_Sizes");
        this.getAccessibleContext().setAccessibleDescription(this.getAccessibleContext().getAccessibleName());
    }
}

