/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.impl.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.netbeans.modules.print.impl.ui.Editor;
import org.netbeans.modules.print.impl.ui.Preview;
import org.netbeans.modules.print.impl.util.Macro;
import org.netbeans.modules.print.impl.util.Option;
import org.netbeans.modules.print.impl.util.Percent;
import org.netbeans.modules.print.impl.util.UI;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;

final class Attribute
extends UI.Dialog
implements FocusListener,
Macro.Listener,
Percent.Listener {
    private JCheckBox myHeader;
    private JTextField myHeaderLeft;
    private JTextField myHeaderCenter;
    private JTextField myHeaderRight;
    private JButton myHeaderFont;
    private JButton myHeaderColor;
    private Color myHeaderColorValue;
    private Font myHeaderFontValue;
    private JCheckBox myFooter;
    private JTextField myFooterLeft;
    private JTextField myFooterCenter;
    private JTextField myFooterRight;
    private JButton myFooterFont;
    private JButton myFooterColor;
    private Color myFooterColorValue;
    private Font myFooterFontValue;
    private JCheckBox myBorder;
    private JButton myBorderColor;
    private Color myBorderColorValue;
    private JCheckBox myLineNumbers;
    private JCheckBox myWrapLines;
    private JCheckBox myUseFont;
    private JCheckBox myUseColor;
    private JButton myTextFont;
    private JButton myTextColor;
    private JButton myBackgroundColor;
    private JSpinner myLineSpacing;
    private Font myTextFontValue;
    private Color myTextColorValue;
    private Color myBackgroundColorValue;
    private JCheckBox myAsEditor;
    private JLabel myTextFontColorLabel;
    private JLabel myBackgroundColorLabel;
    private JLabel myLineSpacingLabel;
    private Percent myZoomFactor;
    private JTextField myZoomWidth;
    private JTextField myZoomHeight;
    private JTextField mySelectedField;
    private JRadioButton myFitToPage;
    private Preview myPreview;
    private DialogDescriptor myDescriptor;
    private static final int TEXT_WIDTH = 30;
    private static final int FIELD_WIDTH = 90;
    private static final int MAX_PAGE_NUBER = 32;
    private static final int MAX_HEADER_SIZE = 100;
    private static final int MAX_FOOTER_SIZE = 100;
    private static final double SPACING_MIN = 0.1;
    private static final double SPACING_MAX = 10.0;
    private static final double SPACING_STP = 0.1;
    private static final double SPACING_FTR = 1.15;
    private static final int[] PERCENTS = new int[]{25, 50, 75, 100, 125, 150, 200, 300, 500};

    Attribute(Preview preview) {
        this.myPreview = preview;
        this.myBorderColorValue = Option.getDefault().getBorderColor();
        this.myTextColorValue = Option.getDefault().getTextColor();
        this.myTextFontValue = Option.getDefault().getTextFont();
        this.myBackgroundColorValue = Option.getDefault().getBackgroundColor();
        this.myHeaderColorValue = Option.getDefault().getHeaderColor();
        this.myHeaderFontValue = Option.getDefault().getHeaderFont();
        this.myFooterColorValue = Option.getDefault().getFooterColor();
        this.myFooterFontValue = Option.getDefault().getFooterFont();
    }

    protected DialogDescriptor createDescriptor() {
        this.myDescriptor = new DialogDescriptor((Object)UI.getResizable(this.createPanel()), this.i18n("LBL_Print_Options"), true, this.getButtons(), DialogDescriptor.OK_OPTION, 0, null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogDescriptor.OK_OPTION == actionEvent.getSource()) {
                    if (Attribute.this.updatePreview()) {
                        Attribute.this.myDescriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
                    } else {
                        Attribute.this.myDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
                    }
                }
            }
        });
        this.myDescriptor.setHelpCtx(new HelpCtx(Attribute.class));
        return this.myDescriptor;
    }

    public void invalidValue(String string) {
        UI.printError(this.i18n("ERR_Zoom_Value_Is_Invalid"));
    }

    private Object[] getButtons() {
        return new Object[]{DialogDescriptor.OK_OPTION, UI.createButton(new UI.ButtonAction(this.i18n("LBL_Apply"), this.i18n("TLT_Apply")){

            public void actionPerformed(ActionEvent actionEvent) {
                Attribute.this.updatePreview();
            }
        }), DialogDescriptor.CANCEL_OPTION};
    }

    private boolean updatePreview() {
        int n;
        int n2 = UI.getInt(this.myZoomWidth.getText());
        if (!this.checkValue(n2, n = UI.getInt(this.myZoomHeight.getText()))) {
            return false;
        }
        Option.getDefault().setBorder(this.myBorder.isSelected());
        Option.getDefault().setBorderColor(this.myBorderColorValue);
        Option.getDefault().setHeader(this.myHeader.isSelected());
        Option.getDefault().setHeaderLeft(this.myHeaderLeft.getText());
        Option.getDefault().setHeaderCenter(this.myHeaderCenter.getText());
        Option.getDefault().setHeaderRight(this.myHeaderRight.getText());
        Option.getDefault().setHeaderColor(this.myHeaderColorValue);
        Option.getDefault().setHeaderFont(this.myHeaderFontValue);
        Option.getDefault().setFooter(this.myFooter.isSelected());
        Option.getDefault().setFooterLeft(this.myFooterLeft.getText());
        Option.getDefault().setFooterCenter(this.myFooterCenter.getText());
        Option.getDefault().setFooterRight(this.myFooterRight.getText());
        Option.getDefault().setFooterColor(this.myFooterColorValue);
        Option.getDefault().setFooterFont(this.myFooterFontValue);
        Option.getDefault().setWrapLines(this.myWrapLines.isSelected());
        Option.getDefault().setLineNumbers(this.myLineNumbers.isSelected());
        Option.getDefault().setUseFont(this.myUseFont.isSelected());
        Option.getDefault().setUseColor(this.myUseColor.isSelected());
        Option.getDefault().setTextColor(this.myTextColorValue);
        Option.getDefault().setTextFont(this.myTextFontValue);
        Option.getDefault().setBackgroundColor(this.myBackgroundColorValue);
        Option.getDefault().setLineSpacing(this.getDouble(this.myLineSpacing.getValue()));
        Option.getDefault().setAsEditor(this.myAsEditor.isSelected());
        double d = 0.0;
        if (this.myZoomFactor.isEnabled()) {
            d = this.myZoomFactor.getValue();
        } else if (this.myZoomWidth.isEnabled()) {
            d = Percent.createZoomWidth(n2);
        } else if (this.myZoomHeight.isEnabled()) {
            d = Percent.createZoomHeight(n);
        } else if (this.myFitToPage.isSelected()) {
            d = 0.0;
        }
        Option.getDefault().setZoom(d);
        this.myPreview.updated();
        return true;
    }

    private boolean checkValue(int n, int n2) {
        if (this.myHeaderFontValue.getSize() > 100) {
            UI.printError(this.i18n("ERR_Header_Size_Is_Too_Big"));
            return false;
        }
        if (this.myFooterFontValue.getSize() > 100) {
            UI.printError(this.i18n("ERR_Footer_Size_Is_Too_Big"));
            return false;
        }
        if (n <= 0 || n2 <= 0) {
            UI.printError(this.i18n("ERR_Page_Number_Is_Invalid"));
            return false;
        }
        if (n > 32 || n2 > 32) {
            UI.printError(this.i18n("ERR_Page_Number_Is_Too_Big"));
            return false;
        }
        return true;
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)UI.createSeparator(this.i18n("LBL_Border")), gridBagConstraints);
        jPanel.add((Component)this.getBorderPanel(), gridBagConstraints);
        jPanel.add((Component)UI.createSeparator(this.i18n("LBL_Header_Footer")), gridBagConstraints);
        jPanel.add((Component)this.getTitlePanel(), gridBagConstraints);
        jPanel.add((Component)UI.createSeparator(this.i18n("LBL_Text")), gridBagConstraints);
        jPanel.add((Component)this.getTextPanel(), gridBagConstraints);
        jPanel.add((Component)UI.createSeparator(this.i18n("LBL_Zoom")), gridBagConstraints);
        jPanel.add((Component)this.getZoomPanel(), gridBagConstraints);
        this.updateControl();
        return jPanel;
    }

    private JPanel getBorderPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.myBorder = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Print_Border")){

            public void actionPerformed(ActionEvent actionEvent) {
                Attribute.this.myBorderColor.setEnabled(Attribute.this.myBorder.isSelected());
            }
        });
        jPanel.add((Component)this.myBorder, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 2, 0);
        this.myBorderColor = UI.createButton(new UI.ButtonAction(UI.icon(Option.class, "color"), this.i18n("TLT_Border_Color")){

            public void actionPerformed(ActionEvent actionEvent) {
                Attribute.this.borderColor();
            }
        });
        jPanel.add((Component)this.myBorderColor, gridBagConstraints);
        return jPanel;
    }

    private JPanel getTitlePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLabelPanel(jPanel, gridBagConstraints);
        this.setHeaderPanel(jPanel, gridBagConstraints);
        this.setFooterPanel(jPanel, gridBagConstraints);
        this.setMacroPanel(jPanel, gridBagConstraints);
        return jPanel;
    }

    private void setLabelPanel(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 8, 2, 0);
        jPanel.add((Component)new JLabel(), gridBagConstraints);
        jPanel.add((Component)UI.createLabel(this.i18n("LBL_Left")), gridBagConstraints);
        jPanel.add((Component)UI.createLabel(this.i18n("LBL_Center")), gridBagConstraints);
        jPanel.add((Component)UI.createLabel(this.i18n("LBL_Right")), gridBagConstraints);
    }

    private void setHeaderPanel(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.myHeader = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Print_Header")){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = Attribute.this.myHeader.isSelected();
                Attribute.this.myHeaderLeft.setEnabled(bl);
                Attribute.this.myHeaderCenter.setEnabled(bl);
                Attribute.this.myHeaderRight.setEnabled(bl);
                Attribute.this.myHeaderColor.setEnabled(bl);
                Attribute.this.myHeaderFont.setEnabled(bl);
            }
        });
        jPanel.add((Component)this.myHeader, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 8, 2, 0);
        this.myHeaderLeft = new JTextField();
        this.setWidthFocused(this.myHeaderLeft, 90);
        jPanel.add((Component)this.myHeaderLeft, gridBagConstraints);
        this.myHeaderCenter = new JTextField();
        this.setWidthFocused(this.myHeaderCenter, 90);
        jPanel.add((Component)this.myHeaderCenter, gridBagConstraints);
        this.myHeaderRight = new JTextField();
        this.setWidthFocused(this.myHeaderRight, 90);
        jPanel.add((Component)this.myHeaderRight, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.myHeaderColor = UI.createButton(new UI.ButtonAction(UI.icon(Option.class, "color"), this.i18n("TLT_Header_Color")){

            public void actionPerformed(ActionEvent actionEvent) {
                Attribute.this.headerColor();
            }
        });
        jPanel.add((Component)this.myHeaderColor, gridBagConstraints);
        this.myHeaderFont = UI.createButton(new UI.ButtonAction(UI.icon(Option.class, "font"), this.i18n("TLT_Header_Font")){

            public void actionPerformed(ActionEvent actionEvent) {
                Attribute.this.headerFont();
            }
        });
        jPanel.add((Component)this.myHeaderFont, gridBagConstraints);
    }

    private void setFooterPanel(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.myFooter = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Print_Footer")){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = Attribute.this.myFooter.isSelected();
                Attribute.this.myFooterLeft.setEnabled(bl);
                Attribute.this.myFooterCenter.setEnabled(bl);
                Attribute.this.myFooterRight.setEnabled(bl);
                Attribute.this.myFooterColor.setEnabled(bl);
                Attribute.this.myFooterFont.setEnabled(bl);
            }
        });
        jPanel.add((Component)this.myFooter, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 2, 0);
        gridBagConstraints.fill = 2;
        this.myFooterLeft = new JTextField();
        this.setWidthFocused(this.myFooterLeft, 90);
        jPanel.add((Component)this.myFooterLeft, gridBagConstraints);
        this.myFooterCenter = new JTextField();
        this.setWidthFocused(this.myFooterCenter, 90);
        jPanel.add((Component)this.myFooterCenter, gridBagConstraints);
        this.myFooterRight = new JTextField();
        this.setWidthFocused(this.myFooterRight, 90);
        jPanel.add((Component)this.myFooterRight, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.myFooterColor = UI.createButton(new UI.ButtonAction(UI.icon(Option.class, "color"), this.i18n("TLT_Footer_Color")){

            public void actionPerformed(ActionEvent actionEvent) {
                Attribute.this.footerColor();
            }
        });
        jPanel.add((Component)this.myFooterColor, gridBagConstraints);
        this.myFooterFont = UI.createButton(new UI.ButtonAction(UI.icon(Option.class, "font"), this.i18n("TLT_Footer_Font")){

            public void actionPerformed(ActionEvent actionEvent) {
                Attribute.this.footerFont();
            }
        });
        jPanel.add((Component)this.myFooterFont, gridBagConstraints);
    }

    private void setMacroPanel(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)UI.createLabel(this.i18n("LBL_Insert_Macros")), gridBagConstraints);
        for (Macro macro : Macro.values()) {
            JButton jButton = macro.getButton(this);
            jButton.setEnabled(false);
            jPanel2.add((Component)jButton, gridBagConstraints);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 2, 0);
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)jPanel2, gridBagConstraints);
    }

    public void pressed(Macro macro) {
        this.mySelectedField = this.getSelectedTextField();
        if (this.mySelectedField != null) {
            String string = this.mySelectedField.getText();
            String string2 = string.substring(0, this.mySelectedField.getSelectionStart());
            String string3 = string.substring(this.mySelectedField.getSelectionEnd(), string.length());
            this.mySelectedField.setText(string2 + macro.getName() + string3);
        }
    }

    private JTextField getSelectedTextField() {
        if (this.myHeaderLeft.hasFocus()) {
            return this.myHeaderLeft;
        }
        if (this.myHeaderCenter.hasFocus()) {
            return this.myHeaderCenter;
        }
        if (this.myHeaderRight.hasFocus()) {
            return this.myHeaderRight;
        }
        if (this.myFooterLeft.hasFocus()) {
            return this.myFooterLeft;
        }
        if (this.myFooterCenter.hasFocus()) {
            return this.myFooterCenter;
        }
        if (this.myFooterRight.hasFocus()) {
            return this.myFooterRight;
        }
        return null;
    }

    private JPanel getTextPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.createTopTextPanel(jPanel, gridBagConstraints);
        this.createBottomTextPanel(jPanel, gridBagConstraints);
        return jPanel;
    }

    private void createTopTextPanel(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        ++gridBagConstraints.gridy;
        this.myLineNumbers = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Line_Numbers")){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel.add((Component)this.myLineNumbers, gridBagConstraints);
        this.myUseColor = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Use_Color"), this.i18n("TLT_Use_Color")){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel.add((Component)this.myUseColor, gridBagConstraints);
        this.myTextFontColorLabel = UI.createLabel(this.i18n("LBL_Text_Font_and_Color"));
        jPanel.add((Component)this.myTextFontColorLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 8, 2, 0);
        this.myTextColor = UI.createButton(new UI.ButtonAction(UI.icon(Option.class, "color"), this.i18n("TLT_Text_Color")){

            public void actionPerformed(ActionEvent actionEvent) {
                Attribute.this.textColor();
            }
        });
        jPanel.add((Component)this.myTextColor, gridBagConstraints);
        this.myTextFont = UI.createButton(new UI.ButtonAction(UI.icon(Option.class, "font"), this.i18n("TLT_Text_Font")){

            public void actionPerformed(ActionEvent actionEvent) {
                Attribute.this.textFont();
            }
        });
        jPanel.add((Component)this.myTextFont, gridBagConstraints);
    }

    private void createBottomTextPanel(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.myWrapLines = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Wrap_Lines")){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel.add((Component)this.myWrapLines, gridBagConstraints);
        this.myUseFont = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_Use_Font"), this.i18n("TLT_Use_Font")){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel.add((Component)this.myUseFont, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 8, 2, 0);
        this.myBackgroundColorLabel = UI.createLabel(this.i18n("LBL_Background_Color"));
        jPanel.add((Component)this.myBackgroundColorLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 2, 0);
        this.myBackgroundColor = UI.createButton(new UI.ButtonAction(UI.icon(Option.class, "color"), this.i18n("TLT_Background_Color")){

            public void actionPerformed(ActionEvent actionEvent) {
                Attribute.this.backgroundColor();
            }
        });
        jPanel.add((Component)this.myBackgroundColor, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.myAsEditor = UI.createCheckBox(new UI.ButtonAction(this.i18n("LBL_As_Editor"), this.i18n("TLT_As_Editor")){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.myAsEditor.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Attribute.this.updateText();
            }
        });
        jPanel.add((Component)this.myAsEditor, gridBagConstraints);
        jPanel.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 8, 2, 0);
        this.myLineSpacingLabel = UI.createLabel(this.i18n("LBL_Line_Spacing"));
        jPanel.add((Component)this.myLineSpacingLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 2, 0);
        double d = Option.getDefault().getLineSpacing();
        if (d < 0.0) {
            d = 1.0;
        }
        this.myLineSpacing = new JSpinner(new SpinnerNumberModel(d, 0.1, 10.0, 0.1));
        int n = this.myLineSpacing.getPreferredSize().height;
        UI.setHeight(this.myLineSpacing, UI.round((double)n * 1.15));
        this.myLineSpacingLabel.setLabelFor(this.myLineSpacing);
        jPanel.add((Component)this.myLineSpacing, gridBagConstraints);
    }

    private JPanel getZoomPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        double d = Option.getDefault().getZoom();
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        JRadioButton jRadioButton = UI.createRadioButton(this.i18n("LBL_Fit_Width_to"), this.i18n("TLT_Fit_Width_to"));
        jRadioButton.addItemListener(this.createItemListener(true, false, false));
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        buttonGroup.add(jRadioButton);
        gridBagConstraints.insets = new Insets(8, 8, 2, 0);
        this.myZoomWidth = new JTextField(this.getString(Percent.getZoomWidth(d, 1)));
        UI.setWidth(this.myZoomWidth, 30);
        jPanel.add((Component)this.myZoomWidth, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)UI.createLabel(this.i18n("LBL_Pages")), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        JRadioButton jRadioButton2 = UI.createRadioButton(this.i18n("LBL_Zoom_to"), this.i18n("TLT_Zoom_to"));
        jRadioButton2.addItemListener(this.createItemListener(false, false, true));
        jPanel.add((Component)jRadioButton2, gridBagConstraints);
        buttonGroup.add(jRadioButton2);
        gridBagConstraints.insets = new Insets(8, 8, 2, 0);
        this.myZoomFactor = new Percent(this, Percent.getZoomFactor(d, 1.0), PERCENTS, 0, null, this.i18n("TLT_Print_Zoom"));
        jPanel.add((Component)this.myZoomFactor, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        JRadioButton jRadioButton3 = UI.createRadioButton(this.i18n("LBL_Fit_Height_to"), this.i18n("TLT_Fit_Height_to"));
        jRadioButton3.addItemListener(this.createItemListener(false, true, false));
        jPanel.add((Component)jRadioButton3, gridBagConstraints);
        buttonGroup.add(jRadioButton3);
        gridBagConstraints.insets = new Insets(8, 8, 2, 0);
        this.myZoomHeight = new JTextField(this.getString(Percent.getZoomHeight(d, 1)));
        UI.setWidth(this.myZoomHeight, 30);
        jPanel.add((Component)this.myZoomHeight, gridBagConstraints);
        jPanel.add((Component)UI.createLabel(this.i18n("LBL_Pages")), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.myFitToPage = UI.createRadioButton(this.i18n("LBL_Fit_to_Page"), this.i18n("TLT_Fit_to_Page"));
        this.myFitToPage.addItemListener(this.createItemListener(false, false, false));
        jPanel.add((Component)this.myFitToPage, gridBagConstraints);
        buttonGroup.add(this.myFitToPage);
        jRadioButton2.setSelected(Percent.isZoomFactor(d));
        jRadioButton.setSelected(Percent.isZoomWidth(d));
        jRadioButton3.setSelected(Percent.isZoomHeight(d));
        this.myFitToPage.setSelected(Percent.isZoomPage(d));
        return jPanel;
    }

    private ItemListener createItemListener(final boolean bl, final boolean bl2, final boolean bl3) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (Attribute.this.myZoomWidth != null) {
                    Attribute.this.myZoomWidth.setEnabled(bl);
                }
                if (Attribute.this.myZoomHeight != null) {
                    Attribute.this.myZoomHeight.setEnabled(bl2);
                }
                if (Attribute.this.myZoomFactor != null) {
                    Attribute.this.myZoomFactor.setEnabled(bl3);
                }
            }
        };
    }

    private void updateText() {
        boolean bl = !this.myAsEditor.isSelected();
        this.myLineNumbers.setEnabled(bl);
        this.myWrapLines.setEnabled(bl);
        this.myUseColor.setEnabled(bl);
        this.myUseFont.setEnabled(bl);
        this.myTextFont.setEnabled(bl);
        this.myTextColor.setEnabled(bl);
        this.myTextFontColorLabel.setEnabled(bl);
        this.myBackgroundColor.setEnabled(bl);
        this.myBackgroundColorLabel.setEnabled(bl);
        this.myLineSpacing.setEnabled(bl);
        this.myLineSpacingLabel.setEnabled(bl);
    }

    private String getString(int n) {
        if (n < 0) {
            return Integer.toString(-n);
        }
        return Integer.toString(n);
    }

    private void setWidthFocused(JComponent jComponent, int n) {
        UI.setWidth(jComponent, n);
        jComponent.addFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setMacroEnabled(true);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setMacroEnabled(false);
    }

    private void setMacroEnabled(boolean bl) {
        for (Macro macro : Macro.values()) {
            macro.getButton().setEnabled(bl);
        }
    }

    private void headerFont() {
        Font font = this.font(this.myHeaderFontValue);
        if (font != null) {
            this.myHeaderFontValue = font;
        }
    }

    private void footerFont() {
        Font font = this.font(this.myFooterFontValue);
        if (font != null) {
            this.myFooterFontValue = font;
        }
    }

    private void textFont() {
        Font font = this.font(this.myTextFontValue);
        if (font != null) {
            this.myTextFontValue = font;
        }
    }

    private Font font(Font font) {
        return (Font)new Editor(Font.class, this.i18n("LBL_Choose_Font"), font).getValue();
    }

    private void borderColor() {
        Color color = this.color(this.myBorderColorValue);
        if (color != null) {
            this.myBorderColorValue = color;
        }
    }

    private void headerColor() {
        Color color = this.color(this.myHeaderColorValue);
        if (color != null) {
            this.myHeaderColorValue = color;
        }
    }

    private void footerColor() {
        Color color = this.color(this.myFooterColorValue);
        if (color != null) {
            this.myFooterColorValue = color;
        }
    }

    private void textColor() {
        Color color = this.color(this.myTextColorValue);
        if (color != null) {
            this.myTextColorValue = color;
        }
    }

    private void backgroundColor() {
        Color color = this.color(this.myBackgroundColorValue);
        if (color != null) {
            this.myBackgroundColorValue = color;
        }
    }

    private Color color(Color color) {
        return (Color)new Editor(Color.class, this.i18n("LBL_Choose_Color"), color).getValue();
    }

    private void updateControl() {
        this.myBorder.setSelected(Option.getDefault().hasBorder());
        this.myBorderColor.setEnabled(Option.getDefault().hasBorder());
        this.myHeader.setSelected(Option.getDefault().hasHeader());
        this.myHeaderLeft.setText(Option.getDefault().getHeaderLeft());
        this.myHeaderLeft.setEnabled(Option.getDefault().hasHeader());
        this.myHeaderCenter.setText(Option.getDefault().getHeaderCenter());
        this.myHeaderCenter.setEnabled(Option.getDefault().hasHeader());
        this.myHeaderRight.setText(Option.getDefault().getHeaderRight());
        this.myHeaderRight.setEnabled(Option.getDefault().hasHeader());
        this.myHeaderColor.setEnabled(Option.getDefault().hasHeader());
        this.myHeaderFont.setEnabled(Option.getDefault().hasHeader());
        this.myFooter.setSelected(Option.getDefault().hasFooter());
        this.myFooterLeft.setText(Option.getDefault().getFooterLeft());
        this.myFooterLeft.setEnabled(Option.getDefault().hasFooter());
        this.myFooterCenter.setText(Option.getDefault().getFooterCenter());
        this.myFooterCenter.setEnabled(Option.getDefault().hasFooter());
        this.myFooterRight.setText(Option.getDefault().getFooterRight());
        this.myFooterRight.setEnabled(Option.getDefault().hasFooter());
        this.myFooterColor.setEnabled(Option.getDefault().hasFooter());
        this.myFooterFont.setEnabled(Option.getDefault().hasFooter());
        this.myLineNumbers.setSelected(Option.getDefault().isLineNumbers());
        this.myWrapLines.setSelected(Option.getDefault().isWrapLines());
        this.myUseFont.setSelected(Option.getDefault().isUseFont());
        this.myUseColor.setSelected(Option.getDefault().isUseColor());
        this.myAsEditor.setSelected(Option.getDefault().isAsEditor());
        this.updateText();
    }

    protected void opened() {
        this.myHeaderLeft.requestFocus();
    }

    public double getCustomValue(int n) {
        return 0.0;
    }

    public void valueChanged(double d, int n) {
    }

    private double getDouble(Object object) {
        if (!(object instanceof Double)) {
            return -1.0;
        }
        return (Double)object;
    }
}

