/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.impl.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.print.impl.action.PrintPreviewAction;
import org.netbeans.modules.print.impl.provider.ComponentProvider;
import org.netbeans.modules.print.impl.provider.TextProvider;
import org.netbeans.modules.print.impl.ui.Preview;
import org.netbeans.modules.print.impl.util.Option;
import org.netbeans.modules.print.impl.util.UI;
import org.netbeans.modules.print.spi.PrintProvider;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintPreviewMenu
extends UI.IconAction {
    public PrintPreviewMenu() {
        this("LBL_Print_Preview_Menu", "TLT_Print_Preview_Menu", "print");
    }

    protected PrintPreviewMenu(String string, String string2, String string3) {
        super(UI.i18n(PrintPreviewAction.class, string), UI.i18n(PrintPreviewAction.class, string2), UI.icon(Option.class, string3));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        List<PrintProvider> list = this.getPrintProviders();
        if (list != null) {
            Preview.getDefault().print(list, true);
        } else {
            PrintCookie printCookie = this.getPrintCookie();
            if (printCookie != null) {
                printCookie.print();
            }
        }
    }

    private List<PrintProvider> getPrintProviders() {
        List<PrintProvider> list = this.getComponentProviders();
        if (list != null) {
            return list;
        }
        list = this.getNodeProviders();
        if (list != null) {
            return list;
        }
        return null;
    }

    private List<PrintProvider> getComponentProviders() {
        PrintProvider printProvider = this.getComponentProvider();
        if (printProvider == null) {
            return null;
        }
        return Collections.singletonList(printProvider);
    }

    private PrintProvider getComponentProvider() {
        TopComponent topComponent = UI.getActivateTopComponent();
        if (topComponent == null) {
            return null;
        }
        PrintProvider printProvider = (PrintProvider)topComponent.getLookup().lookup(PrintProvider.class);
        if (printProvider != null) {
            return printProvider;
        }
        DataObject dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class);
        if (dataObject != null && (printProvider = (PrintProvider)dataObject.getLookup().lookup(PrintProvider.class)) != null) {
            return printProvider;
        }
        return this.getComponentProvider(topComponent, dataObject);
    }

    private PrintProvider getComponentProvider(TopComponent topComponent, DataObject dataObject) {
        List<JComponent> list = this.getComponents((Container)topComponent);
        if (list.size() == 0) {
            return null;
        }
        return new ComponentProvider(list, this.getName(list, topComponent, dataObject), this.getDate(list, dataObject));
    }

    private String getName(List<JComponent> list, TopComponent topComponent, DataObject dataObject) {
        for (JComponent jComponent : list) {
            Object object = jComponent.getClientProperty(Printable.class);
            if (!(object instanceof String) || object.equals("")) continue;
            return (String)object;
        }
        if (dataObject == null) {
            return topComponent.getDisplayName();
        }
        return dataObject.getName();
    }

    private Date getDate(List<JComponent> list, DataObject dataObject) {
        for (JComponent jComponent : list) {
            Object object = jComponent.getClientProperty(Date.class);
            if (!(object instanceof Date)) continue;
            return (Date)object;
        }
        if (dataObject != null) {
            return this.getDate(dataObject);
        }
        return new Date(System.currentTimeMillis());
    }

    private List<JComponent> getComponents(Container container) {
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        this.getPrintable(container, arrayList);
        return arrayList;
    }

    private void getPrintable(Container container, List<JComponent> list) {
        Component[] componentArray;
        if (container.isShowing() && container instanceof JComponent && ((JComponent)container).getClientProperty(Printable.class) != null) {
            list.add((JComponent)container);
        }
        for (Component component : componentArray = container.getComponents()) {
            if (!(component instanceof Container)) continue;
            this.getPrintable((Container)component, list);
        }
    }

    private List<PrintProvider> getNodeProviders() {
        Node[] nodeArray = UI.getSelectedNodes();
        if (nodeArray == null) {
            return null;
        }
        ArrayList<PrintProvider> arrayList = new ArrayList<PrintProvider>();
        for (Node node : nodeArray) {
            PrintProvider printProvider = (PrintProvider)node.getLookup().lookup(PrintProvider.class);
            if (printProvider != null) {
                arrayList.add(printProvider);
                continue;
            }
            printProvider = this.getEditorProvider(node);
            if (printProvider == null) continue;
            arrayList.add(printProvider);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    private PrintProvider getEditorProvider(Node node) {
        DataObject dataObject = UI.getDataObject(node);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        if (editorCookie.getDocument() == null) {
            return null;
        }
        return new TextProvider(editorCookie, this.getDate(dataObject));
    }

    private Date getDate(DataObject dataObject) {
        return dataObject.getPrimaryFile().lastModified();
    }

    private PrintCookie getPrintCookie() {
        Node node = UI.getSelectedNode();
        if (node == null) {
            return null;
        }
        return (PrintCookie)node.getCookie(PrintCookie.class);
    }

    @Override
    public boolean isEnabled() {
        if (super.isEnabled()) {
            return true;
        }
        return this.getPrintProviders() != null || this.getPrintCookie() != null;
    }
}

