/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.html;

public final class HtmlTag {
    public final String name;
    boolean block;
    boolean hidden;
    boolean replaced;
    public static final HtmlTag A = new HtmlTag("a", false, false, false);
    public static final HtmlTag ABBR = new HtmlTag("abbr", false, false, false);
    public static final HtmlTag ACRONYM = new HtmlTag("acronym", false, false, false);
    public static final HtmlTag ADDRESS = new HtmlTag("address", true, false, false);
    public static final HtmlTag APPLET = new HtmlTag("applet", false, false, true);
    public static final HtmlTag AREA = new HtmlTag("area", false, true, false);
    public static final HtmlTag B = new HtmlTag("b", false, false, false);
    public static final HtmlTag BASE = new HtmlTag("base", false, false, false);
    public static final HtmlTag BASEFONT = new HtmlTag("basefont", false, false, false);
    public static final HtmlTag BIG = new HtmlTag("big", false, false, false);
    public static final HtmlTag BLOCKQUOTE = new HtmlTag("blockquote", true, false, false);
    public static final HtmlTag BODY = new HtmlTag("body", true, false, false);
    public static final HtmlTag BR = new HtmlTag("br", false, false, false);
    public static final HtmlTag BUTTON = new HtmlTag("button", false, false, true);
    public static final HtmlTag CAPTION = new HtmlTag("caption", true, false, false);
    public static final HtmlTag CENTER = new HtmlTag("center", false, false, false);
    public static final HtmlTag CITE = new HtmlTag("cite", false, false, false);
    public static final HtmlTag CODE = new HtmlTag("code", false, false, false);
    public static final HtmlTag COL = new HtmlTag("col", false, false, false);
    public static final HtmlTag COLGROUP = new HtmlTag("colgroup", false, false, false);
    public static final HtmlTag DD = new HtmlTag("dd", true, false, false);
    public static final HtmlTag DEL = new HtmlTag("del", true, false, false);
    public static final HtmlTag DFN = new HtmlTag("dfn", false, false, false);
    public static final HtmlTag DIR = new HtmlTag("dir", true, false, false);
    public static final HtmlTag DIV = new HtmlTag("div", true, false, false);
    public static final HtmlTag DL = new HtmlTag("dl", true, false, false);
    public static final HtmlTag DT = new HtmlTag("dt", true, false, false);
    public static final HtmlTag EM = new HtmlTag("em", false, false, false);
    public static final HtmlTag FIELDSET = new HtmlTag("fieldset", true, false, false);
    public static final HtmlTag FONT = new HtmlTag("font", false, false, false);
    public static final HtmlTag FORM = new HtmlTag("form", true, false, false);
    public static final HtmlTag FRAME = new HtmlTag("frame", false, false, false);
    public static final HtmlTag FRAMESET = new HtmlTag("frameset", false, false, false);
    public static final HtmlTag H1 = new HtmlTag("h1", true, false, false);
    public static final HtmlTag H2 = new HtmlTag("h2", true, false, false);
    public static final HtmlTag H3 = new HtmlTag("h3", true, false, false);
    public static final HtmlTag H4 = new HtmlTag("h4", true, false, false);
    public static final HtmlTag H5 = new HtmlTag("h5", true, false, false);
    public static final HtmlTag H6 = new HtmlTag("h6", true, false, false);
    public static final HtmlTag HEAD = new HtmlTag("head", false, true, false);
    public static final HtmlTag HR = new HtmlTag("hr", true, false, false);
    public static final HtmlTag HTML = new HtmlTag("html", false, true, false);
    public static final HtmlTag I = new HtmlTag("i", false, false, false);
    public static final HtmlTag IFRAME = new HtmlTag("iframe", true, false, true);
    public static final HtmlTag IMG = new HtmlTag("img", false, false, true);
    public static final HtmlTag INPUT = new HtmlTag("input", false, false, true);
    public static final HtmlTag INS = new HtmlTag("ins", true, false, false);
    public static final HtmlTag ISINDEX = new HtmlTag("isindex", false, false, false);
    public static final HtmlTag JSPDECLARATION = new HtmlTag("jsp:declaration", false, true, false);
    public static final HtmlTag JSPEXPRESSION = new HtmlTag("jsp:expression", false, true, false);
    public static final HtmlTag JSPINCLUDE = new HtmlTag("jsp:directive.include", true, false, false);
    public static final HtmlTag JSPINCLUDEX = new HtmlTag("jsp:include", true, false, false);
    public static final HtmlTag JSPSCRIPTLET = new HtmlTag("jsp:scriptlet", false, true, false);
    public static final HtmlTag FSUBVIEW = new HtmlTag("f:subview", true, false, false);
    public static final HtmlTag KBD = new HtmlTag("kbd", false, false, false);
    public static final HtmlTag LABEL = new HtmlTag("label", false, false, false);
    public static final HtmlTag LI = new HtmlTag("li", true, false, false);
    public static final HtmlTag LINK = new HtmlTag("link", false, true, false);
    public static final HtmlTag MAP = new HtmlTag("map", false, true, false);
    public static final HtmlTag MENU = new HtmlTag("menu", true, false, false);
    public static final HtmlTag META = new HtmlTag("meta", false, true, false);
    public static final HtmlTag NOBR = new HtmlTag("nobr", false, false, false);
    public static final HtmlTag NOFRAMES = new HtmlTag("noframes", true, true, false);
    public static final HtmlTag NOSCRIPT = new HtmlTag("noscript", true, true, false);
    public static final HtmlTag OBJECT = new HtmlTag("object", false, false, true);
    public static final HtmlTag OL = new HtmlTag("ol", true, false, false);
    public static final HtmlTag OPTION = new HtmlTag("option", false, false, false);
    public static final HtmlTag P = new HtmlTag("p", true, false, false);
    public static final HtmlTag PARAM = new HtmlTag("param", false, true, false);
    public static final HtmlTag PRE = new HtmlTag("pre", true, false, false);
    public static final HtmlTag Q = new HtmlTag("q", false, false, false);
    public static final HtmlTag S = new HtmlTag("s", false, false, false);
    public static final HtmlTag SAMP = new HtmlTag("samp", false, false, false);
    public static final HtmlTag SCRIPT = new HtmlTag("script", true, true, false);
    public static final HtmlTag SELECT = new HtmlTag("select", false, false, true);
    public static final HtmlTag SMALL = new HtmlTag("small", false, false, false);
    public static final HtmlTag SPAN = new HtmlTag("span", false, false, false);
    public static final HtmlTag STRIKE = new HtmlTag("strike", false, false, false);
    public static final HtmlTag STRONG = new HtmlTag("strong", false, false, false);
    public static final HtmlTag STYLE = new HtmlTag("style", false, true, false);
    public static final HtmlTag SUB = new HtmlTag("sub", false, false, false);
    public static final HtmlTag SUP = new HtmlTag("sup", false, false, false);
    public static final HtmlTag TABLE = new HtmlTag("table", true, false, false);
    public static final HtmlTag TBODY = new HtmlTag("tbody", false, false, false);
    public static final HtmlTag TD = new HtmlTag("td", true, false, false);
    public static final HtmlTag TEXTAREA = new HtmlTag("textarea", false, false, true);
    public static final HtmlTag TFOOT = new HtmlTag("tfoot", false, false, false);
    public static final HtmlTag TH = new HtmlTag("th", true, false, false);
    public static final HtmlTag THEAD = new HtmlTag("thead", false, false, false);
    public static final HtmlTag TITLE = new HtmlTag("title", false, true, false);
    public static final HtmlTag TR = new HtmlTag("tr", true, false, false);
    public static final HtmlTag TT = new HtmlTag("tt", false, false, false);
    public static final HtmlTag U = new HtmlTag("u", false, false, false);
    public static final HtmlTag UL = new HtmlTag("ul", true, false, false);
    public static final HtmlTag VAR = new HtmlTag("var", false, false, false);
    private static HtmlTag[] tags = new HtmlTag[]{A, ABBR, ACRONYM, ADDRESS, APPLET, AREA, B, BASE, BASEFONT, BIG, BLOCKQUOTE, BODY, BR, BUTTON, CAPTION, CENTER, CITE, CODE, COL, COLGROUP, DD, DEL, DFN, DIR, DIV, DL, DT, EM, FSUBVIEW, FIELDSET, FONT, FORM, FRAME, FRAMESET, H1, H2, H3, H4, H5, H6, HEAD, HR, HTML, I, IFRAME, IMG, INPUT, INS, ISINDEX, JSPDECLARATION, JSPINCLUDE, JSPINCLUDEX, JSPEXPRESSION, JSPSCRIPTLET, KBD, LABEL, LI, LINK, MAP, MENU, META, NOBR, NOFRAMES, NOSCRIPT, OBJECT, OL, OPTION, P, PARAM, PRE, Q, S, SAMP, SCRIPT, SELECT, SMALL, SPAN, STRIKE, STRONG, STYLE, SUB, SUP, TABLE, TBODY, TD, TEXTAREA, TFOOT, TH, THEAD, TITLE, TR, TT, U, UL, VAR, null};

    protected HtmlTag(String name, boolean block, boolean hidden, boolean replaced) {
        this.name = name;
        this.block = block;
        this.hidden = hidden;
        this.replaced = replaced;
    }

    public String getTagName() {
        return this.name;
    }

    public boolean isBlockTag() {
        return this.block;
    }

    public boolean isInlineTag() {
        return !this.block;
    }

    public boolean isHiddenTag() {
        return this.hidden;
    }

    public boolean isReplacedTag() {
        return this.replaced;
    }

    public boolean isFormMemberTag() {
        return this == INPUT || this == SELECT || this == TEXTAREA;
    }

    public String toString() {
        return this.name;
    }

    public static HtmlTag[] getTags() {
        return tags;
    }

    public static HtmlTag getTag(String name) {
        int low = 0;
        int high = tags.length - 1;
        while (high > low) {
            int middle = (low + high) / 2;
            int result = name.compareTo(HtmlTag.tags[middle].name);
            if (result == 0) {
                return tags[middle];
            }
            if (result < 0) {
                high = middle;
                continue;
            }
            if (low == middle) break;
            low = middle;
        }
        return null;
    }

    public static boolean isTableChild(String tag) {
        char c = tag.charAt(0);
        if (c == 't' || c == 'c') {
            return tag.equals(HtmlTag.TD.name) || tag.equals(HtmlTag.TH.name) || tag.equals(HtmlTag.TBODY.name) || tag.equals(HtmlTag.THEAD.name) || tag.equals(HtmlTag.TFOOT.name) || tag.equals(HtmlTag.CAPTION.name) || tag.equals(HtmlTag.COLGROUP.name) || tag.equals(HtmlTag.COL.name);
        }
        return false;
    }
}

