/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.nodes.actions;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.XAMUtils;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponent;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.nodes.TMapComponentNode;
import org.netbeans.modules.xslt.tmap.nodes.actions.ActionType;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public abstract class TMapAbstractNodeAction
extends NodeAction {
    private String myName = this.getBundleName();

    protected abstract String getBundleName();

    public abstract ActionType getType();

    protected abstract void performAction(TMapComponent[] var1);

    protected boolean enable(TMapComponent[] tMapComponentArray) {
        boolean bl;
        if (tMapComponentArray == null) {
            return false;
        }
        if (tMapComponentArray.length != 1) {
            return false;
        }
        if (tMapComponentArray[0] == null) {
            return false;
        }
        TMapModel tMapModel = tMapComponentArray[0].getModel();
        if (tMapModel == null) {
            return false;
        }
        boolean bl2 = bl = !XAMUtils.isWritable((Model)tMapModel);
        return !bl || !this.isChangeAction();
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodeArray) {
        final TMapComponent[] tMapComponentArray = TMapAbstractNodeAction.getComponents(nodeArray);
        if (!this.enable(tMapComponentArray)) {
            return;
        }
        TMapModel tMapModel = this.getModel(nodeArray[0]);
        if (tMapModel == null) {
            return;
        }
        try {
            tMapModel.invoke(new Callable<Object>(){

                @Override
                public Object call() {
                    TMapAbstractNodeAction.this.performAction(tMapComponentArray);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    public boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length < 1) {
            return false;
        }
        for (Node node : nodeArray) {
            if (node instanceof TMapComponentNode) continue;
            return false;
        }
        TMapModel tMapModel = this.getModel(nodeArray[0]);
        if (tMapModel == null) {
            return false;
        }
        int n = 0;
        return this.enable(TMapAbstractNodeAction.getComponents(nodeArray));
    }

    public String getName() {
        return this.myName;
    }

    public boolean isChangeAction() {
        return true;
    }

    public TMapModel getModel(Node node) {
        Object var2_2 = null;
        TMapModel tMapModel = (TMapModel)node.getLookup().lookup(TMapModel.class);
        if (tMapModel == null && node instanceof TMapComponentNode) {
            Object object = ((TMapComponentNode)node).getReference();
            var2_2 = object == null ? null : object.getOriginal();
        }
        return this.getModel((TMapComponent)var2_2);
    }

    public TMapModel getModel(TMapComponent tMapComponent) {
        return tMapComponent == null ? null : tMapComponent.getModel();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected static final TMapComponent[] getComponents(Node[] nodeArray) {
        ArrayList arrayList = new ArrayList();
        for (Node node : nodeArray) {
            Object e;
            if (!(node instanceof TMapComponentNode)) continue;
            Object object = ((TMapComponentNode)node).getReference();
            Object e2 = e = object != null ? (Object)object.getOriginal() : null;
            if (e == null) continue;
            arrayList.add(e);
        }
        return arrayList != null && arrayList.size() > 0 ? arrayList.toArray(new TMapComponent[arrayList.size()]) : null;
    }
}

