/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.nodes;

import java.awt.Image;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.xslt.tmap.model.api.Invoke;
import org.netbeans.modules.xslt.tmap.model.api.Operation;
import org.netbeans.modules.xslt.tmap.model.api.Param;
import org.netbeans.modules.xslt.tmap.model.api.Service;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponent;
import org.netbeans.modules.xslt.tmap.model.api.Transform;
import org.netbeans.modules.xslt.tmap.model.api.TransformMap;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NodeType {
    UNKNOWN_TYPE,
    TRANSFORMMAP(TransformMap.class),
    SERVICE(Service.class),
    OPERATION(Operation.class),
    INVOKE(Invoke.class),
    TRANSFORM(Transform.class),
    PARAM(Param.class);

    private AtomicReference<String> myDisplayName = new AtomicReference();
    private AtomicReference<Image> myDefaultImage = new AtomicReference();
    private Class<? extends TMapComponent> myComponentType;
    private static final String IMAGE_FOLDER_PATH = "org/netbeans/modules/xslt/tmap/resources/images/";
    public static final Image UNKNOWN_IMAGE;

    private NodeType() {
    }

    private NodeType(Class<? extends TMapComponent> clazz) {
        this.myComponentType = clazz;
    }

    public static NodeType getNodeType(TMapComponent tMapComponent) {
        if (tMapComponent == null) {
            return null;
        }
        return NodeType.getNodeType(tMapComponent.getComponentType());
    }

    public static NodeType getNodeType(Class<? extends TMapComponent> clazz) {
        NodeType[] nodeTypeArray;
        NodeType nodeType = UNKNOWN_TYPE;
        for (NodeType nodeType2 : nodeTypeArray = NodeType.values()) {
            if (clazz != nodeType2.getComponentType()) continue;
            nodeType = nodeType2;
            break;
        }
        return nodeType;
    }

    public Class<? extends TMapComponent> getComponentType() {
        return this.myComponentType;
    }

    public String getDisplayName() {
        if (this.myDisplayName.get() == null) {
            try {
                this.myDisplayName.compareAndSet(null, NbBundle.getMessage(NodeType.class, (String)this.toString()));
            }
            catch (Exception exception) {
                this.myDisplayName.compareAndSet(null, this.name());
            }
        }
        return this.myDisplayName.get();
    }

    public String getDisplayName(Object object) {
        String string = null;
        try {
            String string2 = this.toString() + "_" + object.toString();
            string = NbBundle.getMessage(NodeType.class, (String)string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public Icon getIcon() {
        return new ImageIcon(this.getImage());
    }

    public Image getImage() {
        if (this.myDefaultImage.get() == null) {
            Image image = NodeType.getImageImpl((Object)this, null);
            if (image == null) {
                image = UNKNOWN_IMAGE;
            }
            this.myDefaultImage.compareAndSet(null, image);
        }
        return this.myDefaultImage.get();
    }

    private static Image getImageImpl(Object object, Object object2) {
        String string = null;
        string = object2 == null ? IMAGE_FOLDER_PATH + object + ".png" : IMAGE_FOLDER_PATH + object + "_" + object2 + ".png";
        return Utilities.loadImage((String)string);
    }

    static {
        UNKNOWN_IMAGE = NodeType.getImageImpl((Object)UNKNOWN_TYPE, null);
    }
}

