/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.nodes;

import org.netbeans.modules.soa.ui.nodes.ReflectionNodeFactory;
import org.netbeans.modules.xslt.tmap.model.api.Invoke;
import org.netbeans.modules.xslt.tmap.model.api.Param;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponent;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.nodes.InvokeNode;
import org.netbeans.modules.xslt.tmap.nodes.NodeType;
import org.netbeans.modules.xslt.tmap.nodes.OperationNode;
import org.netbeans.modules.xslt.tmap.nodes.ParamNode;
import org.netbeans.modules.xslt.tmap.nodes.ServiceNode;
import org.netbeans.modules.xslt.tmap.nodes.TMapComponentNodeChildrenImpl;
import org.netbeans.modules.xslt.tmap.nodes.TransformMapNode;
import org.netbeans.modules.xslt.tmap.nodes.TransformNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorNodeFactory
extends ReflectionNodeFactory<NodeType> {
    private static NavigatorNodeFactory INSTANCE = new NavigatorNodeFactory();

    public static NavigatorNodeFactory getInstance() {
        return INSTANCE;
    }

    private NavigatorNodeFactory() {
        super(6);
        this.key2Class.put(NodeType.TRANSFORMMAP, TransformMapNode.class);
        this.key2Class.put(NodeType.SERVICE, ServiceNode.class);
        this.key2Class.put(NodeType.OPERATION, OperationNode.class);
        this.key2Class.put(NodeType.INVOKE, InvokeNode.class);
        this.key2Class.put(NodeType.TRANSFORM, TransformNode.class);
        this.key2Class.put(NodeType.PARAM, ParamNode.class);
    }

    public Node createNode(TMapComponent tMapComponent, Lookup lookup) {
        Node node = null;
        NodeType nodeType = NodeType.getNodeType(tMapComponent);
        if (nodeType != null) {
            node = this.createNode(nodeType, (Object)tMapComponent, lookup);
        }
        return node;
    }

    public Node getTransformMapNode(TMapModel tMapModel, Lookup lookup) {
        assert (tMapModel != null && lookup != null);
        return this.createNode(NodeType.TRANSFORMMAP, (Object)tMapModel.getTransformMap(), lookup);
    }

    public Node createNode(NodeType nodeType, Object object, Lookup lookup) {
        if (nodeType == null || object == null || lookup == null) {
            return null;
        }
        if (NodeType.UNKNOWN_TYPE.equals((Object)nodeType)) {
            return this.createDefaultNode(object, lookup);
        }
        Node node = null;
        switch (nodeType) {
            case TRANSFORMMAP: 
            case SERVICE: 
            case OPERATION: 
            case TRANSFORM: {
                assert (object instanceof TMapComponent) : "reference should be TMapComponent type to create TMapComponent type Node";
                node = super.createNode((Object)nodeType, object, (Children)new TMapComponentNodeChildrenImpl((TMapComponent)object, lookup), lookup);
                break;
            }
            case PARAM: {
                assert (object instanceof Param) : "reference should be Param type to create Param type Node";
                node = super.createNode((Object)nodeType, object, Children.LEAF, lookup);
                break;
            }
            case INVOKE: {
                assert (object instanceof Invoke) : "reference should be Invoke type to create Invoke type Node";
                node = super.createNode((Object)nodeType, object, Children.LEAF, lookup);
            }
        }
        return node;
    }

    public Node createNode(NodeType nodeType, Object object, Children children, Lookup lookup) {
        return super.createNode((Object)nodeType, object, children, lookup);
    }

    private Node createDefaultNode(Object object, Lookup lookup) {
        return null;
    }
}

