/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.model.impl;

import org.netbeans.modules.xslt.tmap.model.api.Invoke;
import org.netbeans.modules.xslt.tmap.model.api.Operation;
import org.netbeans.modules.xslt.tmap.model.api.Param;
import org.netbeans.modules.xslt.tmap.model.api.Service;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponent;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponentFactory;
import org.netbeans.modules.xslt.tmap.model.api.Transform;
import org.netbeans.modules.xslt.tmap.model.api.TransformMap;
import org.netbeans.modules.xslt.tmap.model.impl.InvokeImpl;
import org.netbeans.modules.xslt.tmap.model.impl.OperationImpl;
import org.netbeans.modules.xslt.tmap.model.impl.ParamImpl;
import org.netbeans.modules.xslt.tmap.model.impl.ServiceImpl;
import org.netbeans.modules.xslt.tmap.model.impl.TMapComponentBuildVisitor;
import org.netbeans.modules.xslt.tmap.model.impl.TMapModelImpl;
import org.netbeans.modules.xslt.tmap.model.impl.TransformImpl;
import org.netbeans.modules.xslt.tmap.model.impl.TransformMapImpl;
import org.w3c.dom.Element;

public class TMapComponentFactoryImpl
implements TMapComponentFactory {
    private TMapModelImpl myModel;
    private ThreadLocal<TMapComponentBuildVisitor> myBuilder;

    public TMapComponentFactoryImpl(TMapModelImpl tMapModelImpl) {
        this.myModel = tMapModelImpl;
        this.myBuilder = new ThreadLocal();
    }

    public TransformMap createTransformMap() {
        return new TransformMapImpl(this.getModel());
    }

    public Service createService() {
        return new ServiceImpl(this.getModel());
    }

    public Operation createOperation() {
        return new OperationImpl(this.getModel());
    }

    public Invoke createInvoke() {
        return new InvokeImpl(this.getModel());
    }

    public Transform createTransform() {
        return new TransformImpl(this.getModel());
    }

    public Param createParam() {
        return new ParamImpl(this.getModel());
    }

    public TMapComponent create(Element element, TMapComponent tMapComponent) {
        TMapComponentBuildVisitor tMapComponentBuildVisitor = this.getBuilder();
        return tMapComponentBuildVisitor.createSubComponent(tMapComponent, element);
    }

    private TMapComponentBuildVisitor getBuilder() {
        TMapComponentBuildVisitor tMapComponentBuildVisitor = this.myBuilder.get();
        if (tMapComponentBuildVisitor == null) {
            tMapComponentBuildVisitor = new TMapComponentBuildVisitor(this.getModel());
            this.myBuilder.set(tMapComponentBuildVisitor);
        }
        tMapComponentBuildVisitor.init();
        return tMapComponentBuildVisitor;
    }

    private TMapModelImpl getModel() {
        return this.myModel;
    }
}

