/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.xml.transform.Source;
import org.netbeans.modules.xslt.tmap.TMapDataEditorSupport;
import org.netbeans.modules.xslt.tmap.TMapDataLoader;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.multiview.TMapMultiViewSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.TransformableSupport;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class TMapDataObject
extends MultiDataObject {
    private static final long serialVersionUID = 1L;
    private static final String IMAGE_ICON_BASE = "org/netbeans/modules/xslt/tmap/resources/tmap.png";
    private static final String FILE_DESC = "LBL_FileNode_desc";
    private transient TMapDataEditorSupport myDataEditorSupport;
    private transient AtomicReference<Lookup> myLookup = new AtomicReference();
    private transient AtomicBoolean isLookupInit = new AtomicBoolean(false);

    public TMapDataObject(FileObject fileObject, TMapDataLoader tMapDataLoader) throws DataObjectExistsException, IOException {
        super(fileObject, (MultiFileLoader)tMapDataLoader);
        this.myDataEditorSupport = new TMapDataEditorSupport(this);
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)this.getEditorSupport());
        Source source = DataObjectAdapters.source((DataObject)this);
        cookieSet.add((Node.Cookie)new TransformableSupport(source));
    }

    public boolean isRenameAllowed() {
        return false;
    }

    public boolean isDeleteAllowed() {
        return false;
    }

    public boolean isMoveAllowed() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TMapDataObject.class);
    }

    public void addSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().add((Node.Cookie)saveCookie);
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl) {
            this.getCookieSet().add((Node.Cookie)this.getSaveCookie());
        } else {
            this.getCookieSet().remove((Node.Cookie)this.getSaveCookie());
        }
    }

    private SaveCookie getSaveCookie() {
        return new SaveCookie(){

            public void save() throws IOException {
                TMapDataObject.this.getEditorSupport().saveDocument();
            }

            public int hashCode() {
                return this.getClass().hashCode();
            }

            public boolean equals(Object object) {
                return object != null && this.getClass().equals(object.getClass());
            }
        };
    }

    protected Node createNodeDelegate() {
        return new TMapDataNode(this, this.getEditorSupport());
    }

    public Lookup getLookup() {
        if (this.myLookup.get() == null) {
            LinkedList<Lookup> linkedList = new LinkedList<Lookup>();
            linkedList.add(Lookups.fixed((Object[])new Object[]{super.getLookup(), this}));
            linkedList.add(this.getCookieSet().getLookup());
            InstanceContent.Convertor<Class, Object> convertor = new InstanceContent.Convertor<Class, Object>(){

                public Object convert(Class clazz) {
                    if (clazz == TMapModel.class) {
                        return TMapDataObject.this.getEditorSupport().getTMapModel();
                    }
                    if (clazz == TMapDataEditorSupport.class) {
                        return TMapDataObject.this.getEditorSupport();
                    }
                    return null;
                }

                public Class type(Class clazz) {
                    return clazz;
                }

                public String id(Class clazz) {
                    return clazz.toString();
                }

                public String displayName(Class clazz) {
                    return clazz.getName();
                }
            };
            linkedList.add(Lookups.fixed((Object[])new Class[]{TMapModel.class, TMapDataEditorSupport.class}, (InstanceContent.Convertor)convertor));
            ProxyLookup proxyLookup = new ProxyLookup(linkedList.toArray(new Lookup[linkedList.size()]));
            this.myLookup.compareAndSet(null, (Lookup)proxyLookup);
            this.isLookupInit.compareAndSet(false, true);
        }
        return this.myLookup.get();
    }

    public TMapDataEditorSupport getEditorSupport() {
        return this.myDataEditorSupport;
    }

    private static class TMapDataNode
    extends DataNode {
        private TMapDataEditorSupport myEditorSupport;

        public TMapDataNode(TMapDataObject tMapDataObject, TMapDataEditorSupport tMapDataEditorSupport) {
            super((DataObject)tMapDataObject, Children.LEAF);
            this.myEditorSupport = tMapDataEditorSupport;
            this.getCookieSet().add((Node.Cookie)tMapDataObject);
            this.setIconBaseWithExtension(TMapDataObject.IMAGE_ICON_BASE);
            this.setShortDescription(NbBundle.getMessage(TMapDataNode.class, (String)TMapDataObject.FILE_DESC));
        }

        public Action getPreferredAction() {
            return new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (TMapDataNode.this.myEditorSupport.getOpenedPanes() == null || TMapDataNode.this.myEditorSupport.getOpenedPanes().length == 0) {
                        TMapDataNode.this.myEditorSupport.open();
                        TMapMultiViewSupport tMapMultiViewSupport = TMapMultiViewSupport.getInstance();
                        tMapMultiViewSupport.requestViewOpen(TMapDataNode.this.myEditorSupport);
                    } else {
                        TMapDataNode.this.myEditorSupport.open();
                    }
                }
            };
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return super.canDestroy();
        }

        public boolean canCut() {
            return super.canCut();
        }

        protected boolean isWarning() {
            return false;
        }

        protected boolean isError() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(TMapDataObject.class);
        }
    }
}

