/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io;

import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.CodeGenerator;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.providers.DocumentSerializer;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeResolver
implements DesignDocumentAwareness {
    private static final Lookup.Result<CodeGenerator> result = Lookup.getDefault().lookupResult(CodeGenerator.class);
    private DataObjectContext context;
    private DocumentSerializer serializer;
    private volatile DesignDocument document;
    private volatile long documentState = Long.MIN_VALUE;
    private volatile DataEditorView.Kind viewKind;

    public CodeResolver(DataObjectContext dataObjectContext, DocumentSerializer documentSerializer) {
        this.context = dataObjectContext;
        this.serializer = documentSerializer;
        this.serializer.addDesignDocumentAwareness(this);
    }

    public void resetModelModifiedStatus(DesignDocument designDocument) {
        if (this.document == null && designDocument != null) {
            this.document = designDocument;
            this.documentState = designDocument.getListenerManager().getDocumentState();
        }
    }

    @Override
    public void setDesignDocument(DesignDocument designDocument) {
        DataEditorView dataEditorView = ActiveViewSupport.getDefault().getActiveView();
        if (dataEditorView == null) {
            return;
        }
        if (dataEditorView.getContext() != this.context) {
            return;
        }
        this.update(designDocument, dataEditorView.getKind());
    }

    public void viewActivated(DataEditorView dataEditorView) {
        this.update(this.serializer.getDocument(), dataEditorView.getKind());
    }

    public void forceUpdateCode() {
        this.update(this.serializer.getDocument(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(final DesignDocument designDocument, DataEditorView.Kind kind) {
        if (designDocument == null) {
            return;
        }
        if (kind != null && kind.equals((Object)DataEditorView.Kind.NONE)) {
            return;
        }
        CodeResolver codeResolver = this;
        synchronized (codeResolver) {
            boolean bl;
            if (kind != null && kind.equals((Object)this.viewKind)) {
                return;
            }
            boolean bl2 = this.document != designDocument || this.documentState != designDocument.getListenerManager().getDocumentState();
            boolean bl3 = IOSupport.getCloneableEditorSupport(this.context.getDataObject()).isModified();
            boolean bl4 = kind != null && kind.equals((Object)DataEditorView.Kind.CODE) && this.viewKind != null && this.viewKind.equals((Object)DataEditorView.Kind.MODEL);
            final boolean bl5 = kind != null && kind.equals((Object)DataEditorView.Kind.MODEL) && this.viewKind != null && this.viewKind.equals((Object)DataEditorView.Kind.CODE);
            boolean bl6 = bl = bl3 && bl2 && (bl4 || kind == null);
            if (!IOSupport.isDocumentUpdatingEnabled(this.context.getDataObject())) {
                if (bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            String string = ".LCK" + CodeResolver.this.context.getDataObject().getPrimaryFile().getNameExt() + "~";
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CodeResolver.class, (String)"CodeResolver.locked", (Object)string)));
                        }
                    });
                }
                if (kind != null) {
                    this.viewKind = kind;
                }
                return;
            }
            JEditorPane jEditorPane = null;
            FoldHierarchy foldHierarchy = null;
            HashMap<String, Boolean> hashMap = null;
            if (bl && (jEditorPane = this.findEditorPane()) != null) {
                foldHierarchy = FoldHierarchy.get((JTextComponent)jEditorPane);
                hashMap = new HashMap<String, Boolean>();
            }
            if (jEditorPane != null) {
                this.storeFoldStates(foldHierarchy.getRootFold(), hashMap);
            }
            long l = designDocument.getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    if (bl) {
                        for (CodeGenerator codeGenerator : result.allInstances()) {
                            codeGenerator.validateModelForCodeGeneration(CodeResolver.this.context, designDocument);
                        }
                    }
                    if (bl5 || bl) {
                        for (CodeGenerator codeGenerator : result.allInstances()) {
                            codeGenerator.updateModelFromCode(CodeResolver.this.context, designDocument);
                        }
                    }
                }
            });
            this.document = designDocument;
            if (bl) {
                this.documentState = l;
            }
            if (kind != null) {
                this.viewKind = kind;
            }
            if (bl) {
                designDocument.getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        for (CodeGenerator codeGenerator : result.allInstances()) {
                            codeGenerator.updateCodeFromModel(CodeResolver.this.context, designDocument);
                        }
                    }
                });
            }
            if (jEditorPane != null) {
                this.loadFoldStates(foldHierarchy, foldHierarchy.getRootFold(), hashMap);
            }
        }
    }

    private void storeFoldStates(Fold fold, HashMap<String, Boolean> hashMap) {
        String string = fold.getDescription();
        if ("custom-fold".equals(fold.getType().toString()) && string != null) {
            hashMap.put(string, fold.isCollapsed());
        }
        for (int i = 0; i < fold.getFoldCount(); ++i) {
            this.storeFoldStates(fold.getFold(i), hashMap);
        }
    }

    private void loadFoldStates(FoldHierarchy foldHierarchy, Fold fold, HashMap<String, Boolean> hashMap) {
        Boolean bl;
        String string = fold.getDescription();
        if ("custom-fold".equals(fold.getType().toString()) && string != null && (bl = hashMap.get(string)) != null && bl.booleanValue() != fold.isCollapsed()) {
            if (bl.booleanValue()) {
                foldHierarchy.collapse(fold);
            } else {
                foldHierarchy.expand(fold);
            }
        }
        for (int i = 0; i < fold.getFoldCount(); ++i) {
            this.loadFoldStates(foldHierarchy, fold.getFold(i), hashMap);
        }
    }

    private JEditorPane findEditorPane() {
        if (!SwingUtilities.isEventDispatchThread()) {
            return null;
        }
        JEditorPane[] jEditorPaneArray = this.context.getCloneableEditorSupport().getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    public void notifyDataObjectClosed() {
        this.serializer.removeDesignDocumentAwareness(this);
        this.serializer = null;
        this.context = null;
    }
}

