/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.awt.Dialog;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.httpserver.GrantAccessEvent;
import org.netbeans.modules.httpserver.GrantAccessListener;
import org.netbeans.modules.httpserver.GrantAccessPanel;
import org.netbeans.modules.httpserver.HttpServerModule;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.BeanNode;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServerSettings {
    private static HttpServerSettings INSTANCE = new HttpServerSettings();
    private static BeanNode view = null;
    private static final int MAX_START_RETRIES = 20;
    private static int currentRetries = 0;
    protected static EventListenerList listenerList = new EventListenerList();
    static boolean inited = false;
    private static Hashtable<InetAddress, Thread> whoAsking = new Hashtable();
    public static final int SERVER_STARTUP_TIMEOUT = 3000;
    public static final String LOCALHOST = "local";
    public static final String ANYHOST = "any";
    public static HostProperty hostProperty = null;
    public static final String PROP_PORT = "port";
    public static final String PROP_HOST_PROPERTY = "hostProperty";
    static final String PROP_WRAPPER_BASEURL = "wrapperBaseURL";
    public static final String PROP_RUNNING = "running";
    private static final String PROP_SHOW_GRANT_ACCESS = "showGrantAccess";
    private static final int DEFAULT_PORT = 8082;
    private static String wrapperBaseURL = "/resource/";
    static boolean running = false;
    private static boolean startStopMessages = true;
    private static Properties mappedServlets = new Properties();
    public static HttpServerSettings OPTIONS = null;
    private static Object httpLock;

    private static Preferences getPreferences() {
        return NbPreferences.forModule(HttpServerSettings.class);
    }

    static final Object httpLock() {
        if (httpLock == null) {
            httpLock = new Object();
        }
        return httpLock;
    }

    private HttpServerSettings() {
    }

    public static HttpServerSettings getDefault() {
        return INSTANCE;
    }

    public boolean isRunning() {
        if (inited) {
            return running;
        }
        this.setRunning(false);
        return running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runSuccess() {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            currentRetries = 0;
            running = true;
            HttpServerSettings.httpLock().notifyAll();
        }
    }

    void runFailure(Throwable throwable) {
        running = false;
        if (throwable instanceof IncompatibleClassChangeError) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HttpServerSettings.class, (String)"MSG_HTTP_SERVER_incompatbleClasses"), 2));
        } else if (throwable instanceof BindException) {
            if (++currentRetries <= 20) {
                this.setPort(this.getPort() + 1);
                this.setRunning(true);
            } else {
                currentRetries = 0;
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HttpServerSettings.class, (String)"MSG_HTTP_SERVER_START_FAIL"), 2));
                int n = this.getPort();
                if (n < 1024 && inited && Utilities.isUnix()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HttpServerSettings.class, (String)"MSG_onlyRootOnUnix"), 2));
                }
            }
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HttpServerSettings.class, (String)"MSG_HTTP_SERVER_START_FAIL_unknown"), 2));
        }
    }

    private void restartIfNecessary(boolean bl) {
        if (running) {
            if (!bl) {
                this.setStartStopMessages(false);
            }
            HttpServerModule.stopHTTPServer();
            HttpServerModule.initHTTPServer();
        }
    }

    private String getCanonicalRelativeURL(String string) {
        String string2;
        if (string.length() == 0) {
            string2 = "/";
        } else {
            string2 = string.charAt(0) != '/' ? "/" + string : string;
            if (string2.charAt(string2.length() - 1) != '/') {
                string2 = string2 + "/";
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean bl) {
        inited = true;
        if (running == bl) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            if (bl) {
                HttpServerModule.initHTTPServer();
            } else {
                running = false;
                HttpServerModule.stopHTTPServer();
            }
        }
    }

    String getWrapperBaseURL() {
        return wrapperBaseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWrapperBaseURL(String string) {
        String string2 = this.getCanonicalRelativeURL(string);
        if (wrapperBaseURL.equals(string2)) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            String string3 = wrapperBaseURL;
            wrapperBaseURL = string2;
            this.restartIfNecessary(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int n) {
        if (n <= 0 || n > 65535) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(HttpServerSettings.class, (String)"ERR_PortNumberOutOfRange", (Object)new Integer(n)), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            HttpServerSettings.getPreferences().putInt(PROP_PORT, n);
            this.restartIfNecessary(true);
        }
    }

    public int getPort() {
        return HttpServerSettings.getPreferences().getInt(PROP_PORT, 8082);
    }

    public void setStartStopMessages(boolean bl) {
        startStopMessages = bl;
    }

    public boolean isStartStopMessages() {
        return startStopMessages;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HttpServerSettings.class);
    }

    private String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    public void addGrantAccessListener(GrantAccessListener grantAccessListener) {
        listenerList.add(GrantAccessListener.class, grantAccessListener);
    }

    public void removeGrantAccessListener(GrantAccessListener grantAccessListener) {
        listenerList.remove(GrantAccessListener.class, grantAccessListener);
    }

    protected boolean fireGrantAccessEvent(InetAddress inetAddress, String string) {
        Object[] objectArray = listenerList.getListenerList();
        GrantAccessEvent grantAccessEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != GrantAccessListener.class) continue;
            if (grantAccessEvent == null) {
                grantAccessEvent = new GrantAccessEvent(this, inetAddress, string);
            }
            ((GrantAccessListener)objectArray[i + 1]).grantAccess(grantAccessEvent);
        }
        return grantAccessEvent == null ? false : grantAccessEvent.isGranted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean allowAccess(InetAddress inetAddress, String string) {
        if (this.accessAllowedNow(inetAddress, string)) {
            return true;
        }
        Thread thread = null;
        Object object = whoAsking;
        synchronized (object) {
            if (this.accessAllowedNow(inetAddress, string)) {
                return true;
            }
            thread = whoAsking.get(inetAddress);
            if (thread == null) {
                thread = Thread.currentThread();
                whoAsking.put(inetAddress, thread);
            }
        }
        object = HttpServerSettings.class;
        synchronized (HttpServerSettings.class) {
            if (thread != Thread.currentThread()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return this.accessAllowedNow(inetAddress, string);
            }
            try {
                if (!this.isShowGrantAccessDialog()) {
                    boolean bl = false;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return bl;
                }
                String string2 = NbBundle.getMessage(HttpServerSettings.class, (String)"MSG_AddAddress", (Object)inetAddress.getHostAddress());
                GrantAccessPanel grantAccessPanel = new GrantAccessPanel(string2);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)grantAccessPanel, NbBundle.getMessage(HttpServerSettings.class, (String)"CTL_GrantAccessTitle"), true, 0, NotifyDescriptor.NO_OPTION, null);
                dialogDescriptor.setMessageType(3);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setSize(580, 180);
                dialog.setVisible(true);
                this.setShowGrantAccessDialog(grantAccessPanel.getShowDialog());
                if (NotifyDescriptor.YES_OPTION.equals(dialogDescriptor.getValue())) {
                    this.appendAddressToGranted(inetAddress.getHostAddress());
                    boolean bl = true;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return bl;
                }
                boolean bl = false;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return bl;
            }
            finally {
                whoAsking.remove(inetAddress);
            }
        }
    }

    private boolean accessAllowedNow(InetAddress inetAddress, String string) {
        if (hostProperty.getHost().equals(ANYHOST)) {
            return true;
        }
        Set<String> set = this.getGrantedAddressesSet();
        if (set.contains(inetAddress.getHostAddress())) {
            return true;
        }
        return this.fireGrantAccessEvent(inetAddress, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAddressToGranted(String string) {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            String string2 = hostProperty.getGrantedAddresses().trim();
            if (string2.length() > 0 && string2.charAt(string2.length() - 1) != ';' && string2.charAt(string2.length() - 1) != ',') {
                string2 = string2 + ',';
            }
            string2 = string2 + string;
            hostProperty.setGrantedAddresses(string2);
        }
    }

    Set<String> getGrantedAddressesSet() {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            hashSet.add(InetAddress.getByName("localhost").getHostAddress());
            hashSet.add(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        StringTokenizer stringTokenizer = new StringTokenizer(hostProperty.getGrantedAddresses(), ",;");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            string = string.trim();
            try {
                hashSet.add(InetAddress.getByName(string).getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {}
        }
        return hashSet;
    }

    Properties getMappedServlets() {
        return mappedServlets;
    }

    static String mangle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i)) || string.charAt(i) == '.') {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            String string2 = Integer.toHexString(string.charAt(i)).toUpperCase();
            if (string2.length() < 2) {
                string2 = string2.length() == 0 ? "00" : "0" + string2;
            }
            stringBuffer.append("%").append(string2.length() == 2 ? string2 : string2.substring(string2.length() - 2));
        }
        return stringBuffer.toString();
    }

    static String demangle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '%') {
                    stringBuffer.append(string.charAt(i));
                    continue;
                }
                stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                i += 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return "";
        }
        return stringBuffer.toString();
    }

    public HostProperty getHostProperty() {
        if (hostProperty == null) {
            hostProperty = new HostProperty(HttpServerSettings.getPreferences().get("grantedAddresses", ""), HttpServerSettings.getPreferences().get("host", LOCALHOST));
        }
        return hostProperty;
    }

    public void setHostProperty(HostProperty hostProperty) {
        if (ANYHOST.equals(hostProperty.getHost()) || LOCALHOST.equals(hostProperty.getHost())) {
            HttpServerSettings.hostProperty.setHost(hostProperty.getHost());
            HttpServerSettings.hostProperty.setGrantedAddresses(hostProperty.getGrantedAddresses());
            HttpServerSettings.getPreferences().put("host", hostProperty.getHost());
            HttpServerSettings.getPreferences().put("grantedAddresses", hostProperty.getGrantedAddresses());
        }
    }

    public boolean isShowGrantAccessDialog() {
        return HttpServerSettings.getPreferences().getBoolean(PROP_SHOW_GRANT_ACCESS, true);
    }

    public void setShowGrantAccessDialog(boolean bl) {
        HttpServerSettings.getPreferences().putBoolean(PROP_SHOW_GRANT_ACCESS, bl);
    }

    public static class HostProperty
    implements Serializable {
        private String grantedAddresses;
        private String host;
        private static final long serialVersionUID = 1927848926692414249L;

        HostProperty(String string, String string2) {
            this.grantedAddresses = string;
            this.host = string2;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String string) {
            this.host = string;
        }

        public String getGrantedAddresses() {
            return this.grantedAddresses;
        }

        public void setGrantedAddresses(String string) {
            this.grantedAddresses = string;
        }
    }
}

