/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic.options;

import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class SemanticHighlightingOptions {
    private static final Preferences preferences = NbPreferences.forModule(SemanticHighlightingOptions.class);
    private static final String ENABLE_MARK_OCCURENCES = "EnableMarkOccurrences";
    private static final String KEEP_MARKS = "KeepMarks";
    private static final String ENABLE_MACROS = "Macros";
    private static final String DIFFER_SYSTEM_MACROS = "SysMacros";
    private static final String ENABLE_CLASS_FIELDS = "ClassFields";
    private static final String ENABLE_FUNCTION_NAMES = "FunctionNames";
    public static final boolean SEMANTIC_ADVANCED = Boolean.getBoolean("cnd.semantic.advanced");

    private SemanticHighlightingOptions() {
    }

    private static boolean getOption(String string, boolean bl) {
        return preferences.getBoolean(string, bl);
    }

    private static void setOption(String string, boolean bl) {
        preferences.putBoolean(string, bl);
    }

    public static boolean getEnableMarkOccurences() {
        return SemanticHighlightingOptions.getOption(ENABLE_MARK_OCCURENCES, true);
    }

    public static void setEnableMarkOccurences(boolean bl) {
        SemanticHighlightingOptions.setOption(ENABLE_MARK_OCCURENCES, bl);
    }

    public static boolean getKeepMarks() {
        return SemanticHighlightingOptions.getOption(KEEP_MARKS, true);
    }

    public static void setKeepMarks(boolean bl) {
        SemanticHighlightingOptions.setOption(KEEP_MARKS, bl);
    }

    public static boolean getEnableMacros() {
        return SemanticHighlightingOptions.getOption(ENABLE_MACROS, true);
    }

    public static void setEnableMacros(boolean bl) {
        SemanticHighlightingOptions.setOption(ENABLE_MACROS, bl);
    }

    public static boolean getDifferSystemMacros() {
        return SemanticHighlightingOptions.getOption(DIFFER_SYSTEM_MACROS, true);
    }

    public static void setDifferSystemMacros(boolean bl) {
        SemanticHighlightingOptions.setOption(DIFFER_SYSTEM_MACROS, bl);
    }

    public static boolean getEnableClassFields() {
        return SEMANTIC_ADVANCED && SemanticHighlightingOptions.getOption(ENABLE_CLASS_FIELDS, true);
    }

    public static void setEnableClassFields(boolean bl) {
        SemanticHighlightingOptions.setOption(ENABLE_CLASS_FIELDS, bl);
    }

    public static boolean getEnableFunctionNames() {
        return SEMANTIC_ADVANCED && SemanticHighlightingOptions.getOption(ENABLE_FUNCTION_NAMES, true);
    }

    public static void setEnableFunctionNames(boolean bl) {
        SemanticHighlightingOptions.setOption(ENABLE_FUNCTION_NAMES, bl);
    }
}

