/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.awt.Color;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.editor.errorstripe.privatespi.Status;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OccurrencesMarkProvider
extends MarkProvider {
    private static Map<Document, Reference<OccurrencesMarkProvider>> providers = new WeakHashMap<Document, Reference<OccurrencesMarkProvider>>();
    private List<Mark> semantic = Collections.emptyList();
    private List<Mark> occurrences = Collections.emptyList();
    private List<Mark> joint = Collections.emptyList();

    public static synchronized OccurrencesMarkProvider get(Document document) {
        OccurrencesMarkProvider occurrencesMarkProvider;
        Reference<OccurrencesMarkProvider> reference = providers.get(document);
        OccurrencesMarkProvider occurrencesMarkProvider2 = occurrencesMarkProvider = reference != null ? reference.get() : null;
        if (occurrencesMarkProvider == null) {
            occurrencesMarkProvider = new OccurrencesMarkProvider();
            providers.put(document, new WeakReference<OccurrencesMarkProvider>(occurrencesMarkProvider));
        }
        return occurrencesMarkProvider;
    }

    private OccurrencesMarkProvider() {
    }

    public synchronized List<Mark> getMarks() {
        return this.joint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSematic(Collection<Mark> collection) {
        ArrayList<Mark> arrayList;
        List<Mark> list;
        OccurrencesMarkProvider occurrencesMarkProvider = this;
        synchronized (occurrencesMarkProvider) {
            this.semantic = new ArrayList<Mark>(collection);
            list = this.joint;
            this.joint = new ArrayList<Mark>();
            arrayList = this.joint;
            this.joint.addAll(this.semantic);
            this.joint.addAll(this.occurrences);
        }
        this.firePropertyChange("marks", list, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOccurrences(Collection<Mark> collection) {
        ArrayList<Mark> arrayList;
        List<Mark> list;
        OccurrencesMarkProvider occurrencesMarkProvider = this;
        synchronized (occurrencesMarkProvider) {
            this.occurrences = new ArrayList<Mark>(collection);
            list = this.joint;
            this.joint = new ArrayList<Mark>();
            arrayList = this.joint;
            this.joint.addAll(this.semantic);
            this.joint.addAll(this.occurrences);
        }
        this.firePropertyChange("marks", list, arrayList);
    }

    public static Collection<Mark> createMarks(final Document document, final Collection<CsmReference> collection, final Color color, final String string) {
        final LinkedList<Mark> linkedList = new LinkedList<Mark>();
        document.render(new Runnable(){

            public void run() {
                for (CsmReference csmReference : collection) {
                    try {
                        if (csmReference.getStartOffset() >= document.getLength()) continue;
                        linkedList.add(new MarkImpl(document, document.createPosition(csmReference.getStartOffset()), color, string));
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            }
        });
        return linkedList;
    }

    private static final class MarkImpl
    implements Mark {
        private Document doc;
        private Position startOffset;
        private Color color;
        private String tooltip;

        public MarkImpl(Document document, Position position, Color color, String string) {
            this.doc = document;
            this.startOffset = position;
            this.color = color;
            this.tooltip = string;
        }

        public int getType() {
            return 1;
        }

        public Status getStatus() {
            return Status.STATUS_OK;
        }

        public int getPriority() {
            return 1000;
        }

        public Color getEnhancedColor() {
            return this.color;
        }

        public int[] getAssignedLines() {
            int n = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.startOffset.getOffset());
            return new int[]{n, n};
        }

        public String getShortDescription() {
            return this.tooltip;
        }
    }
}

