/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class SourcePathProviderImpl
extends SourcePathProvider {
    private static boolean verbose = System.getProperty("netbeans.debugger.sourcepathproviderimpl") != null;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.projects");
    private static final Pattern thisDirectoryPattern = Pattern.compile("(/|\\A)\\./");
    private static final Pattern parentDirectoryPattern = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
    private ClassPath originalSourcePath;
    private Set<String> additionalSourceRoots;
    private ClassPath smartSteppingSourcePath;
    private String[] projectSourceRoots;
    private PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private PathRegistryListener pathRegistryListener;

    public SourcePathProviderImpl() {
    }

    public SourcePathProviderImpl(ContextProvider contextProvider) {
        Map map = (Map)contextProvider.lookupFirst(null, Map.class);
        if (map != null) {
            this.smartSteppingSourcePath = (ClassPath)map.get("sourcepath");
            ClassPath classPath = (ClassPath)map.get("jdksources");
            if (classPath == null && JavaPlatform.getDefault() != null) {
                classPath = JavaPlatform.getDefault().getSourceFolders();
            }
            this.originalSourcePath = classPath == null ? this.smartSteppingSourcePath : ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath, this.smartSteppingSourcePath});
            this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            hashSet.addAll(Arrays.asList(this.originalSourcePath.getRoots()));
            TreeSet<FileObject> treeSet = new TreeSet<FileObject>(new FileObjectComparator());
            treeSet.addAll(GlobalPathRegistry.getDefault().getSourceRoots());
            treeSet.removeAll(hashSet);
            ClassPath classPath2 = ClassPathSupport.createClassPath((FileObject[])treeSet.toArray(new FileObject[0]));
            this.originalSourcePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.originalSourcePath, classPath2});
        } else {
            Object object;
            this.pathRegistryListener = new PathRegistryListener();
            GlobalPathRegistry.getDefault().addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this.pathRegistryListener, (Object)GlobalPathRegistry.getDefault()));
            JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pathRegistryListener, (Object)JavaPlatformManager.getDefault()));
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
            Project project = OpenProjects.getDefault().getMainProject();
            if (project != null) {
                for (FileObject[] fileObjectArray : object = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
                    FileObject[] fileObjectArray2;
                    ClassPath classPath = ClassPath.getClassPath((FileObject)fileObjectArray.getRootFolder(), (String)"classpath/execute");
                    if (classPath == null) {
                        classPath = ClassPath.getClassPath((FileObject)fileObjectArray.getRootFolder(), (String)"classpath/source");
                    }
                    if (classPath == null) continue;
                    for (FileObject fileObject : fileObjectArray2 = classPath.getRoots()) {
                        if (hashSet2.contains(fileObject)) continue;
                        hashSet2.add(fileObject);
                        try {
                            FileObject[] fileObjectArray3;
                            for (FileObject fileObject2 : fileObjectArray3 = SourceForBinaryQuery.findSourceRoots((URL)fileObject.getURL()).getRoots()) {
                                if (hashSet.contains(fileObject2)) continue;
                                arrayList.add(fileObject2);
                                hashSet.add(fileObject2);
                            }
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                        }
                    }
                }
            }
            object = new TreeSet<FileObject>(new FileObjectComparator());
            object.addAll(GlobalPathRegistry.getDefault().getSourceRoots());
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                FileObject fileObject = (FileObject)object2.next();
                if (hashSet.contains(fileObject)) continue;
                arrayList.add(fileObject);
            }
            this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[arrayList.size()]));
            this.projectSourceRoots = this.getSourceRoots(this.originalSourcePath);
            object2 = JavaPlatformManager.getDefault().getInstalledPlatforms();
            int n = ((Object)object2).length;
            for (int i = 0; i < n; ++i) {
                FileObject[] fileObjectArray;
                fileObjectArray = object2[i].getSourceFolders().getRoots();
                int n2 = fileObjectArray.length;
                for (int j = 0; j < n2; ++j) {
                    arrayList.remove(fileObjectArray[j]);
                }
            }
            this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[arrayList.size()]));
        }
        if (verbose) {
            System.out.println("SPPI: init originalSourcePath " + this.originalSourcePath);
        }
        if (verbose) {
            System.out.println("SPPI: init smartSteppingSourcePath " + this.smartSteppingSourcePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURL(String string, boolean bl) {
        FileObject fileObject;
        if (verbose) {
            System.out.println("SPPI: getURL " + string + " global " + bl);
        }
        string = SourcePathProviderImpl.normalize(string);
        if (this.originalSourcePath == null) {
            fileObject = GlobalPathRegistry.getDefault().findResource(string);
        } else {
            SourcePathProviderImpl sourcePathProviderImpl = this;
            synchronized (sourcePathProviderImpl) {
                if (!bl) {
                    fileObject = this.smartSteppingSourcePath.findResource(string);
                    if (verbose) {
                        System.out.println("SPPI:   fo " + fileObject);
                    }
                } else {
                    fileObject = this.originalSourcePath.findResource(string);
                    if (verbose) {
                        System.out.println("SPPI:   fo " + fileObject);
                    }
                }
            }
        }
        if (fileObject == null) {
            return null;
        }
        try {
            return fileObject.getURL().toString();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            if (verbose) {
                System.out.println("SPPI:   FileStateInvalidException");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllURLs(String string, boolean bl) {
        Object object;
        List list;
        if (verbose) {
            System.out.println("SPPI: getURL " + string + " global " + bl);
        }
        string = SourcePathProviderImpl.normalize(string);
        if (this.originalSourcePath == null) {
            list = new ArrayList();
            for (Object object2 : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                list.addAll(object2.findAllResources(string));
            }
        } else {
            object = this;
            synchronized (object) {
                if (!bl) {
                    list = this.smartSteppingSourcePath.findAllResources(string);
                    if (verbose) {
                        System.out.println("SPPI:   fos " + list);
                    }
                } else {
                    list = this.originalSourcePath.findAllResources(string);
                    if (verbose) {
                        System.out.println("SPPI:   fos " + list);
                    }
                }
            }
        }
        object = new ArrayList(list.size());
        for (FileObject fileObject : list) {
            try {
                object.add(fileObject.getURL().toString());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                if (!verbose) continue;
                System.out.println("SPPI:   FileStateInvalidException for " + fileObject);
            }
        }
        return object.toArray(new String[0]);
    }

    public String getRelativePath(String string, char c, boolean bl) {
        FileObject fileObject = null;
        if (verbose) {
            System.out.println("SPPI: getRelativePath " + string);
        }
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
            if (verbose) {
                System.out.println("SPPI:   fo " + fileObject);
            }
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        String string2 = this.smartSteppingSourcePath.getResourceName(fileObject, c, bl);
        if (string2 == null) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (classPath == null) {
                classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
            }
            if (classPath == null) {
                return null;
            }
            string2 = classPath.getResourceName(fileObject, c, bl);
        }
        return string2;
    }

    public synchronized String getSourceRoot(String string) {
        for (FileObject fileObject : this.originalSourcePath.getRoots()) {
            try {
                String string2;
                String string3 = fileObject.getURL().toString();
                if (!string.startsWith(string3) || (string2 = SourcePathProviderImpl.getRoot(fileObject)) == null) continue;
                return string2;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return null;
    }

    private String[] getSourceRoots(ClassPath classPath) {
        FileObject[] fileObjectArray = classPath.getRoots();
        ArrayList<String> arrayList = new ArrayList<String>(fileObjectArray.length);
        for (FileObject fileObject : fileObjectArray) {
            String string = SourcePathProviderImpl.getRoot(fileObject);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public synchronized String[] getOriginalSourceRoots() {
        return this.getSourceRoots(this.originalSourcePath);
    }

    public synchronized String[] getSourceRoots() {
        return this.getSourceRoots(this.smartSteppingSourcePath);
    }

    public String[] getProjectSourceRoots() {
        return this.projectSourceRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRoots(String[] stringArray) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SourcePathProviderImpl.setSourceRoots(" + Arrays.asList(stringArray) + ")");
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        ClassPath classPath = null;
        ClassPath classPath2 = null;
        SourcePathProviderImpl sourcePathProviderImpl = this;
        synchronized (sourcePathProviderImpl) {
            String string;
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(Arrays.asList(this.smartSteppingSourcePath.getRoots()));
            ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>(Arrays.asList(this.originalSourcePath.getRoots()));
            HashSet<String> hashSet2 = new HashSet<String>(hashSet);
            for (FileObject object22 : arrayList2) {
                hashSet2.remove(SourcePathProviderImpl.getRoot(object22));
            }
            if (!hashSet2.isEmpty()) {
                for (String string2 : hashSet2) {
                    FileObject fileObject = this.getFileObject(string2);
                    if (fileObject == null) continue;
                    arrayList2.add(fileObject);
                }
                this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList2.toArray(new FileObject[0]));
                if (this.additionalSourceRoots == null) {
                    this.additionalSourceRoots = new HashSet<String>();
                }
                this.additionalSourceRoots.addAll(hashSet2);
            }
            HashSet<String> hashSet3 = new HashSet<String>(hashSet);
            for (FileObject fileObject : arrayList) {
                hashSet3.remove(SourcePathProviderImpl.getRoot(fileObject));
            }
            HashSet<FileObject> hashSet4 = new HashSet<FileObject>();
            HashSet<FileObject> hashSet5 = new HashSet<FileObject>();
            for (Object object : arrayList) {
                string = SourcePathProviderImpl.getRoot(object);
                if (hashSet.contains(string)) continue;
                hashSet4.add((FileObject)object);
                if (this.additionalSourceRoots == null || !this.additionalSourceRoots.contains(string)) continue;
                hashSet5.add((FileObject)object);
                this.additionalSourceRoots.remove(string);
                if (this.additionalSourceRoots.size() != 0) continue;
                this.additionalSourceRoots = null;
            }
            if (hashSet5.size() > 0) {
                arrayList2.removeAll(hashSet5);
                this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList2.toArray(new FileObject[0]));
            }
            if (hashSet3.size() > 0 || hashSet4.size() > 0) {
                Iterator iterator = hashSet3.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    object = (String)iterator.next();
                    string = this.getFileObject((String)object);
                    if (string == null) continue;
                    arrayList.add((FileObject)string);
                }
                arrayList.removeAll(hashSet4);
                classPath = this.smartSteppingSourcePath;
                classPath2 = this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
            }
        }
        if (classPath != null) {
            this.pcs.firePropertyChange("sourceRoots", classPath, classPath2);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public static String normalize(String string) {
        Matcher matcher = thisDirectoryPattern.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceAll("$1");
            matcher = thisDirectoryPattern.matcher(string);
        }
        matcher = parentDirectoryPattern.matcher(string);
        while (matcher.find()) {
            if (matcher.group(2).equals("..")) continue;
            string = string.substring(0, matcher.start()) + matcher.group(1) + string.substring(matcher.end());
            matcher = parentDirectoryPattern.matcher(string);
        }
        return string;
    }

    private static String getRoot(FileObject fileObject) {
        File file = null;
        String string = "";
        try {
            if (fileObject.getFileSystem() instanceof JarFileSystem) {
                file = ((JarFileSystem)fileObject.getFileSystem()).getJarFile();
                if (!fileObject.isRoot()) {
                    string = "!/" + fileObject.getPath();
                }
            } else {
                file = FileUtil.toFile((FileObject)fileObject);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        if (file != null) {
            return file.getAbsolutePath() + string;
        }
        return null;
    }

    private FileObject getFileObject(String string) {
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        String string2 = null;
        if (fileObject == null && string.contains("!/")) {
            int n = string.indexOf("!/");
            file = new File(string.substring(0, n));
            fileObject = FileUtil.toFileObject((File)file);
            string2 = string.substring(n + "!/".length());
        }
        if (fileObject != null && FileUtil.isArchiveFile((FileObject)fileObject)) {
            fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
            if (string2 != null) {
                fileObject = fileObject.getFileObject(string2);
            }
        }
        return fileObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FileObjectComparator
    implements Comparator<FileObject> {
        private FileObjectComparator() {
        }

        @Override
        public int compare(FileObject fileObject, FileObject fileObject2) {
            String string = SourcePathProviderImpl.getRoot(fileObject);
            String string2 = SourcePathProviderImpl.getRoot(fileObject2);
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareTo(string2);
        }
    }

    private class PathRegistryListener
    implements GlobalPathRegistryListener,
    PropertyChangeListener {
        private PathRegistryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pathsAdded(GlobalPathRegistryEvent globalPathRegistryEvent) {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (Object object2 : globalPathRegistryEvent.getChangedPaths()) {
                for (FileObject fileObject : object2.getRoots()) {
                    arrayList.add(fileObject);
                }
            }
            if (arrayList.size() > 0) {
                Object object = SourcePathProviderImpl.this;
                synchronized (object) {
                    Object object2;
                    object2 = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                    object2.addAll(arrayList);
                    SourcePathProviderImpl.this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])object2.toArray(new FileObject[0]));
                    object2 = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.smartSteppingSourcePath.getRoots()));
                    object2.addAll(arrayList);
                    SourcePathProviderImpl.this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])object2.toArray(new FileObject[0]));
                }
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pathsRemoved(GlobalPathRegistryEvent globalPathRegistryEvent) {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (Object object2 : globalPathRegistryEvent.getChangedPaths()) {
                for (FileObject fileObject : object2.getRoots()) {
                    arrayList.add(fileObject);
                }
            }
            if (arrayList.size() > 0) {
                Object object = SourcePathProviderImpl.this;
                synchronized (object) {
                    Object object2;
                    object2 = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                    object2.removeAll(arrayList);
                    SourcePathProviderImpl.this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])object2.toArray(new FileObject[0]));
                    object2 = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.smartSteppingSourcePath.getRoots()));
                    object2.removeAll(arrayList);
                    SourcePathProviderImpl.this.smartSteppingSourcePath = ClassPathSupport.createClassPath((FileObject[])object2.toArray(new FileObject[0]));
                }
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
            boolean bl = false;
            SourcePathProviderImpl sourcePathProviderImpl = SourcePathProviderImpl.this;
            synchronized (sourcePathProviderImpl) {
                ArrayList<FileObject> arrayList = new ArrayList<FileObject>(Arrays.asList(SourcePathProviderImpl.this.originalSourcePath.getRoots()));
                for (JavaPlatform javaPlatform : javaPlatformArray) {
                    FileObject[] fileObjectArray;
                    for (FileObject fileObject : fileObjectArray = javaPlatform.getSourceFolders().getRoots()) {
                        if (arrayList.contains(fileObject)) continue;
                        arrayList.add(fileObject);
                        bl = true;
                    }
                }
                if (bl) {
                    SourcePathProviderImpl.this.originalSourcePath = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
                }
            }
            if (bl) {
                SourcePathProviderImpl.this.pcs.firePropertyChange("sourceRoots", null, null);
            }
        }
    }
}

