/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.hints.infrastructure.HintAction;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class IntroduceAction
extends HintAction {
    private IntroduceKind type;

    private IntroduceAction(IntroduceKind introduceKind) {
        this.type = introduceKind;
        switch (introduceKind) {
            case CREATE_CONSTANT: {
                this.putValue("Name", NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceConstantAction"));
                break;
            }
            case CREATE_VARIABLE: {
                this.putValue("Name", NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction"));
                break;
            }
            case CREATE_FIELD: {
                this.putValue("Name", NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceFieldAction"));
                break;
            }
            case CREATE_METHOD: {
                this.putValue("Name", NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction"));
            }
        }
    }

    protected void perform(JavaSource javaSource, int[] nArray) {
        String string = this.doPerformAction(javaSource, nArray);
        if (string != null) {
            String string2 = NbBundle.getMessage(IntroduceAction.class, (String)string);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
        }
    }

    private String doPerformAction(JavaSource javaSource, final int[] nArray) {
        final EnumMap enumMap = new EnumMap(IntroduceKind.class);
        final EnumMap enumMap2 = new EnumMap(IntroduceKind.class);
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    IntroduceHint.computeError((CompilationInfo)compilationController, nArray[0], nArray[1], enumMap, enumMap2, new AtomicBoolean());
                }
            }, true);
            Fix fix = (Fix)enumMap.get((Object)this.type);
            if (fix != null) {
                fix.implement();
                return null;
            }
            String string = (String)enumMap2.get((Object)this.type);
            if (string != null) {
                return string;
            }
            return "ERR_Invalid_Selection";
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public static IntroduceAction createVariable() {
        return new IntroduceAction(IntroduceKind.CREATE_VARIABLE);
    }

    public static IntroduceAction createConstant() {
        return new IntroduceAction(IntroduceKind.CREATE_CONSTANT);
    }

    public static IntroduceAction createField() {
        return new IntroduceAction(IntroduceKind.CREATE_FIELD);
    }

    public static IntroduceAction createMethod() {
        return new IntroduceAction(IntroduceKind.CREATE_METHOD);
    }
}

