/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotInitializedVariable
implements ErrorRule<Void> {
    private static final String DIAGNOSTIC_KEY = "compiler.err.var.might.not.have.been.initialized";
    private volatile boolean canceled;

    @Override
    public Set<String> getCodes() {
        return Collections.singleton(DIAGNOSTIC_KEY);
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<Void> data) {
        assert (DIAGNOSTIC_KEY.equals(string));
        ArrayList<NIVFix> arrayList = new ArrayList<NIVFix>();
        if (!this.canceled) {
            Trees trees = compilationInfo.getTrees();
            Element element = trees.getElement(treePath);
            if (!this.canceled && element != null && element.getKind() == ElementKind.LOCAL_VARIABLE) {
                TreePath treePath2 = trees.getPath(element);
                if (!this.canceled && treePath2 != null) {
                    arrayList.add(new NIVFix(compilationInfo.getFileObject(), element.getSimpleName().toString(), TreePathHandle.create((TreePath)treePath2, (CompilationInfo)compilationInfo)));
                }
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public String getId() {
        return "NotInitializedVariable";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(NotInitializedVariable.class, (String)"LBL_NotInitializedVariable");
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    private static class NIVFix
    implements Fix {
        private final FileObject file;
        private final String variableName;
        private final TreePathHandle variable;

        public NIVFix(FileObject fileObject, String string, TreePathHandle treePathHandle) {
            assert (fileObject != null);
            assert (string != null);
            assert (treePathHandle != null);
            this.file = fileObject;
            this.variableName = string;
            this.variable = treePathHandle;
        }

        public String getText() {
            return NbBundle.getMessage(NotInitializedVariable.class, (String)"LBL_NotInitializedVariable_fix", (Object)this.variableName);
        }

        public ChangeInfo implement() throws Exception {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            if (javaSource != null) {
                javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy workingCopy) throws Exception {
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        TreePath treePath = NIVFix.this.variable.resolve((CompilationInfo)workingCopy);
                        if (treePath == null) {
                            return;
                        }
                        VariableTree variableTree = (VariableTree)treePath.getLeaf();
                        ExpressionTree expressionTree = variableTree.getInitializer();
                        if (expressionTree != null) {
                            return;
                        }
                        Element element = workingCopy.getTrees().getElement(treePath);
                        if (element == null) {
                            return;
                        }
                        TypeMirror typeMirror = element.asType();
                        TypeKind typeKind = typeMirror.getKind();
                        Comparable<Boolean> comparable = typeKind.isPrimitive() ? (typeKind == TypeKind.BOOLEAN ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0)) : null;
                        LiteralTree literalTree = workingCopy.getTreeMaker().Literal((Object)comparable);
                        VariableTree variableTree2 = workingCopy.getTreeMaker().Variable(variableTree.getModifiers(), (CharSequence)variableTree.getName(), variableTree.getType(), (ExpressionTree)literalTree);
                        workingCopy.rewrite((Tree)variableTree, (Tree)variableTree2);
                    }
                }).commit();
            }
            return null;
        }
    }
}

