/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrongPackageSuggestion
extends AbstractHint {
    public WrongPackageSuggestion() {
        super(true, true, AbstractHint.HintSeverity.ERROR, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return Collections.singleton(Tree.Kind.COMPILATION_UNIT);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        long l;
        long l2;
        boolean bl;
        Tree tree = treePath.getLeaf();
        assert (tree.getKind() == Tree.Kind.COMPILATION_UNIT);
        CompilationUnitTree compilationUnitTree = (CompilationUnitTree)tree;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = compilationUnitTree.getPackageName() != null;
        if (bl) {
            new TreeScanner<Void, StringBuffer>(){

                @Override
                public Void visitIdentifier(IdentifierTree identifierTree, StringBuffer stringBuffer) {
                    stringBuffer.append(identifierTree.getName().toString());
                    return null;
                }

                @Override
                public Void visitMemberSelect(MemberSelectTree memberSelectTree, StringBuffer stringBuffer) {
                    super.visitMemberSelect(memberSelectTree, stringBuffer);
                    stringBuffer.append('.');
                    stringBuffer.append(memberSelectTree.getIdentifier().toString());
                    return null;
                }
            }.scan(compilationUnitTree.getPackageName(), stringBuffer);
        } else if (compilationUnitTree.getTypeDecls().isEmpty()) {
            return null;
        }
        String string = stringBuffer.toString();
        ClassPath classPath = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
        if (classPath == null || !classPath.isResourceVisible(compilationInfo.getFileObject())) {
            Logger.getLogger(WrongPackageSuggestion.class.getName()).log(Level.INFO, "source cp is either null or does not contain the compiled source cp={0}", classPath);
            return null;
        }
        String string2 = classPath.getResourceName(compilationInfo.getFileObject().getParent(), '.', false);
        if (WrongPackageSuggestion.isCaseSensitive() && string.equals(string2) || !WrongPackageSuggestion.isCaseSensitive() && string.toLowerCase().equals(string2.toLowerCase())) {
            return null;
        }
        if (bl) {
            l2 = compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationUnitTree, compilationUnitTree.getPackageName());
            l = compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationUnitTree, compilationUnitTree.getPackageName());
        } else {
            l2 = 0L;
            l = 1L;
        }
        if (l2 == -1L || l == -1L) {
            return null;
        }
        List<Fix> list = Arrays.asList(new CorrectPackageDeclarationFix(compilationInfo.getFileObject(), string2));
        String string3 = NbBundle.getMessage(WrongPackageSuggestion.class, (String)"HINT_WrongPackage");
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)string3, list, (FileObject)compilationInfo.getFileObject(), (int)((int)l2), (int)((int)l)));
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return WrongPackageSuggestion.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(WrongPackageSuggestion.class, (String)"DN_WrongPackage");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(WrongPackageSuggestion.class, (String)"DESC_WrongPackage");
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private static boolean isCaseSensitive() {
        return !new File("a").equals(new File("A"));
    }

    static final class CorrectPackageDeclarationFix
    implements Fix {
        private FileObject file;
        private String packageName;

        public CorrectPackageDeclarationFix(FileObject fileObject, String string) {
            this.file = fileObject;
            this.packageName = string;
        }

        public String getText() {
            return NbBundle.getMessage(WrongPackageSuggestion.class, (String)"FIX_WrongPackageFix", (Object)(this.packageName.length() == 0 ? 0 : 1), (Object)this.packageName);
        }

        public ChangeInfo implement() throws IOException {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.PARSED);
                    CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                    if (CorrectPackageDeclarationFix.this.packageName.length() == 0) {
                        workingCopy.rewrite((Tree)compilationUnitTree, (Tree)workingCopy.getTreeMaker().CompilationUnit(null, compilationUnitTree.getImports(), compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile()));
                    } else if (compilationUnitTree.getPackageName() == null) {
                        workingCopy.rewrite((Tree)compilationUnitTree, (Tree)workingCopy.getTreeMaker().CompilationUnit(CorrectPackageDeclarationFix.this.createForFQN(workingCopy, CorrectPackageDeclarationFix.this.packageName), compilationUnitTree.getImports(), compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile()));
                    } else {
                        workingCopy.rewrite((Tree)compilationUnitTree.getPackageName(), (Tree)CorrectPackageDeclarationFix.this.createForFQN(workingCopy, CorrectPackageDeclarationFix.this.packageName));
                    }
                }
            }).commit();
            return null;
        }

        private ExpressionTree createForFQN(WorkingCopy workingCopy, String string) {
            int n = string.indexOf(46);
            if (n == -1) {
                return workingCopy.getTreeMaker().Identifier((CharSequence)string);
            }
            return workingCopy.getTreeMaker().MemberSelect(this.createForFQN(workingCopy, string.substring(0, n)), (CharSequence)string.substring(n + 1));
        }
    }

    static final class MoveToCorrectPlace
    implements Fix {
        private FileObject file;
        private ClassPath cp;
        private String packageName;

        public MoveToCorrectPlace(FileObject fileObject, ClassPath classPath, String string) {
            this.file = fileObject;
            this.cp = classPath;
            this.packageName = string;
        }

        public String getText() {
            return NbBundle.getMessage(WrongPackageSuggestion.class, (String)"FIX_WrongPackageMove");
        }

        public ChangeInfo implement() {
            try {
                String string = this.packageName.replace('.', '/');
                FileObject fileObject = this.cp.findOwnerRoot(this.file);
                FileObject fileObject2 = fileObject.getFileObject(string);
                if (fileObject2 != null && !fileObject2.isFolder()) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WrongPackageSuggestion.class, (String)"ERR_CannotMoveAlreadyExists"), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
                    return null;
                }
                fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)this.packageName.replace('.', '/'));
                DataObject dataObject = DataObject.find((FileObject)this.file);
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject2);
                dataObject.move(dataFolder);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)NbBundle.getMessage(WrongPackageSuggestion.class, (String)"ERR_CannotMove"));
                ErrorManager.getDefault().notify(256, (Throwable)illegalArgumentException);
                Logger.getLogger(WrongPackageSuggestion.class.getName()).log(Level.INFO, null, illegalArgumentException);
            }
            catch (IOException iOException) {
                Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(WrongPackageSuggestion.class, (String)"ERR_CannotMove"));
                ErrorManager.getDefault().notify(256, (Throwable)iOException);
                Logger.getLogger(WrongPackageSuggestion.class.getName()).log(Level.INFO, null, iOException);
            }
            return null;
        }
    }
}

