/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class ForbiddenImportsCustomizer
extends JPanel {
    private static String FORBIDDEN_IMPORTS_KEY = "ForbiddenImports";
    private static String FORBIDDEN_IMPORTS_DEFAULT = "sun.**";
    private static String IMPORTS_DELIMITER = ";";
    private Preferences prefs;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnRemove;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JList listItems;

    public ForbiddenImportsCustomizer(Preferences preferences) {
        this.prefs = preferences;
        this.initComponents();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : ForbiddenImportsCustomizer.getForbiddenImports(preferences)) {
            defaultListModel.addElement(string);
        }
        this.listItems.setModel(defaultListModel);
        this.listItems.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ForbiddenImportsCustomizer.this.enableButtons();
            }
        });
        this.enableButtons();
    }

    private void enableButtons() {
        int n = this.listItems.getSelectedIndex();
        this.btnEdit.setEnabled(n >= 0);
        this.btnRemove.setEnabled(n >= 0);
    }

    private void updatePreferences() {
        String[] stringArray = new String[this.listItems.getModel().getSize()];
        for (int i = 0; i < ((DefaultListModel)this.listItems.getModel()).size(); ++i) {
            stringArray[i] = (String)this.listItems.getModel().getElementAt(i);
        }
        this.prefs.put(FORBIDDEN_IMPORTS_KEY, ForbiddenImportsCustomizer.encodeForbiddenImports(stringArray));
    }

    private String showInputDialog(String string) {
        String string2 = null == string ? NbBundle.getMessage(ForbiddenImportsCustomizer.class, (String)"ForbiddenImportsCustomizer.titleAdd") : NbBundle.getMessage(ForbiddenImportsCustomizer.class, (String)"ForbiddenImportsCustomizer.titleEdit");
        final JButton jButton = new JButton(null == string ? NbBundle.getMessage(ForbiddenImportsCustomizer.class, (String)"ForbiddenImportsCustomizer.btnAdd") : NbBundle.getMessage(ForbiddenImportsCustomizer.class, (String)"ForbiddenImportsCustomizer.btnEdit"));
        jButton.setEnabled(null != string);
        JButton jButton2 = new JButton(NbBundle.getMessage(ForbiddenImportsCustomizer.class, (String)"ForbiddenImportsCustomizer.btnCancel"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        JTextField jTextField = new JTextField();
        jTextField.setText(null == string ? "" : string);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                jButton.setEnabled(documentEvent.getDocument().getLength() > 0);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                jButton.setEnabled(documentEvent.getDocument().getLength() > 0);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                jButton.setEnabled(documentEvent.getDocument().getLength() > 0);
            }
        });
        jPanel.add((Component)new JLabel(NbBundle.getMessage(ForbiddenImportsCustomizer.class, (String)"ForbiddenImportsCustomizer.label")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(NbBundle.getMessage(ForbiddenImportsCustomizer.class, (String)"ForbiddenImportsCustomizer.hint")), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, string2, true, new Object[]{jButton, jButton2}, (Object)jButton, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (jButton == dialogDescriptor.getValue()) {
            return jTextField.getText();
        }
        return null;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.listItems = new JList();
        this.jPanel1 = new JPanel();
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.listItems.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.jScrollPane1.setViewportView(this.listItems);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnAdd.setText(NbBundle.getMessage(ForbiddenImportsCustomizer.class, (String)"ForbiddenImportsCustomizer.btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ForbiddenImportsCustomizer.this.addItem(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.btnAdd, gridBagConstraints);
        this.btnEdit.setText(NbBundle.getMessage(ForbiddenImportsCustomizer.class, (String)"ForbiddenImportsCustomizer.btnEdit.text"));
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ForbiddenImportsCustomizer.this.editItem(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.btnEdit, gridBagConstraints);
        this.btnRemove.setText(NbBundle.getMessage(ForbiddenImportsCustomizer.class, (String)"ForbiddenImportsCustomizer.btnRemove.text"));
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ForbiddenImportsCustomizer.this.removeItem(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.btnRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void removeItem(ActionEvent actionEvent) {
        int n = this.listItems.getSelectedIndex();
        if (n < 0) {
            return;
        }
        ((DefaultListModel)this.listItems.getModel()).remove(n);
        if (++n > this.listItems.getModel().getSize() - 1) {
            n = this.listItems.getModel().getSize() - 1;
        }
        this.listItems.getSelectionModel().setSelectionInterval(n, n);
        this.updatePreferences();
    }

    private void editItem(ActionEvent actionEvent) {
        int n = this.listItems.getSelectedIndex();
        if (n < 0) {
            return;
        }
        String string = (String)((DefaultListModel)this.listItems.getModel()).get(n);
        String string2 = this.showInputDialog(string);
        if (null != string2) {
            ((DefaultListModel)this.listItems.getModel()).set(n, string2);
            this.listItems.getSelectionModel().setSelectionInterval(n, n);
            this.updatePreferences();
        }
    }

    private void addItem(ActionEvent actionEvent) {
        String string = this.showInputDialog(null);
        if (null != string) {
            ((DefaultListModel)this.listItems.getModel()).addElement(string);
            int n = this.listItems.getModel().getSize();
            if (n > 0) {
                this.listItems.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            }
            this.updatePreferences();
        }
    }

    public static String encodeForbiddenImports(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : stringArray) {
            stringBuffer.append(string);
            stringBuffer.append(IMPORTS_DELIMITER);
        }
        return stringBuffer.toString();
    }

    public static String[] decodeForbiddenImports(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, IMPORTS_DELIMITER, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getForbiddenImports(Preferences preferences) {
        String string = preferences.get(FORBIDDEN_IMPORTS_KEY, FORBIDDEN_IMPORTS_DEFAULT);
        return ForbiddenImportsCustomizer.decodeForbiddenImports(string);
    }
}

