/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.modules.xml.xpath.ext.metadata.AbstractArgument;
import org.netbeans.modules.xml.xpath.ext.metadata.ArgumentDescriptor;
import org.netbeans.modules.xml.xpath.ext.metadata.GeneralFunctionMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.OperationMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.ResultTypeCalculator;
import org.netbeans.modules.xml.xpath.ext.metadata.XPathType;
import org.netbeans.modules.xml.xpath.ext.metadata.impl.images.IconLoader;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationMetadataImpl
implements OperationMetadata {
    protected ArrayList<AbstractArgument> mArguments = new ArrayList();
    protected Icon mIcon;

    protected OperationMetadataImpl() {
        this.initArguments();
    }

    @Override
    public String getId() {
        return (String)this.getName();
    }

    @Override
    public Icon getIcon() {
        if (this.mIcon == null) {
            this.loadIcon();
        }
        return this.mIcon;
    }

    @Override
    public String getShortDescription() {
        return "";
    }

    @Override
    public String getLongDescription() {
        return "";
    }

    @Override
    public GeneralFunctionMetadata.FunctionType getFunctionType() {
        return GeneralFunctionMetadata.FunctionType.OPERATION;
    }

    @Override
    public ResultTypeCalculator getResultTypeCalculator() {
        return null;
    }

    @Override
    public List<AbstractArgument> getArguments() {
        return this.mArguments;
    }

    protected void loadIcon() {
        this.mIcon = IconLoader.getIcon(this.getId());
    }

    protected void initArguments() {
        this.mArguments.add(ArgumentDescriptor.Predefined.ANY_TYPE);
        this.mArguments.add(ArgumentDescriptor.Predefined.ANY_TYPE);
    }

    public static final class UnionOperationMetadata
    extends OperationMetadataImpl {
        public int getPrecedenceLevel() {
            return 90;
        }

        public String getName() {
            return "|";
        }

        public String getId() {
            return "union";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_Union");
        }

        public XPathType getResultType() {
            return XPathType.NODE_SET_TYPE;
        }

        protected void initArguments() {
            this.mArguments.add(ArgumentDescriptor.Predefined.REPEATED_NODE_SET_2MIN);
        }
    }

    public static final class NegativeOperationMetadata
    extends NumberOperMetadata {
        public int getPrecedenceLevel() {
            return 100;
        }

        public String getName() {
            return "-";
        }

        public String getId() {
            return "negative";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_Negative");
        }

        protected void initArguments() {
            this.mArguments.add(ArgumentDescriptor.Predefined.SIMPLE_NUMBER);
        }
    }

    public static final class ModOperationMetadata
    extends NumberOperMetadata {
        public int getPrecedenceLevel() {
            return 80;
        }

        public String getName() {
            return "mod";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_Remainder");
        }
    }

    public static final class DivOperationMetadata
    extends NumberOperMetadata {
        public int getPrecedenceLevel() {
            return 70;
        }

        public String getName() {
            return "div";
        }

        public String getId() {
            return "division";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_Division");
        }
    }

    public static final class MultOperationMetadata
    extends NumberOperMetadata {
        public int getPrecedenceLevel() {
            return 60;
        }

        public String getName() {
            return "*";
        }

        public String getId() {
            return "multiplication";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_Multiplication");
        }
    }

    public static final class SubtractionOperationMetadata
    extends NumberOperMetadata {
        public int getPrecedenceLevel() {
            return 50;
        }

        public String getName() {
            return "-";
        }

        public String getId() {
            return "subtraction";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_Subtraction");
        }
    }

    public static final class AdditionOperationMetadata
    extends NumberOperMetadata {
        public int getPrecedenceLevel() {
            return 50;
        }

        public String getName() {
            return "+";
        }

        public String getId() {
            return "addition";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_Addition");
        }

        protected void initArguments() {
            this.mArguments.add(ArgumentDescriptor.Predefined.REPEATED_NUMBER_2MIN);
        }
    }

    protected static abstract class NumberOperMetadata
    extends OperationMetadataImpl {
        protected NumberOperMetadata() {
        }

        public XPathType getResultType() {
            return XPathType.NUMBER_TYPE;
        }

        protected void initArguments() {
            this.mArguments.add(ArgumentDescriptor.Predefined.SIMPLE_NUMBER);
            this.mArguments.add(ArgumentDescriptor.Predefined.SIMPLE_NUMBER);
        }
    }

    public static final class GTOperationMetadata
    extends BooleanOperMetadata {
        public int getPrecedenceLevel() {
            return 40;
        }

        public String getName() {
            return ">";
        }

        public String getId() {
            return "greater_than";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_Greater");
        }
    }

    public static final class GEOperationMetadata
    extends BooleanOperMetadata {
        public int getPrecedenceLevel() {
            return 40;
        }

        public String getName() {
            return ">=";
        }

        public String getId() {
            return "greater_or_equal";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_GreaterOrEqual");
        }
    }

    public static final class LTOperationMetadata
    extends BooleanOperMetadata {
        public int getPrecedenceLevel() {
            return 40;
        }

        public String getName() {
            return "<";
        }

        public String getId() {
            return "lesser_than";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_Less");
        }
    }

    public static final class LEOperationMetadata
    extends BooleanOperMetadata {
        public int getPrecedenceLevel() {
            return 40;
        }

        public String getName() {
            return "<=";
        }

        public String getId() {
            return "lesser_or_equal";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_LessOrEqual");
        }
    }

    public static final class NotEqualOperationMetadata
    extends BooleanOperMetadata {
        public int getPrecedenceLevel() {
            return 30;
        }

        public String getName() {
            return "!=";
        }

        public String getId() {
            return "not_equal";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_NotEqual");
        }
    }

    public static final class EqualOperationMetadata
    extends BooleanOperMetadata {
        public int getPrecedenceLevel() {
            return 30;
        }

        public String getName() {
            return "=";
        }

        public String getId() {
            return "equal";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_Equal");
        }

        protected void initArguments() {
            this.mArguments.add(ArgumentDescriptor.Predefined.ANY_TYPE);
            this.mArguments.add(ArgumentDescriptor.Predefined.ANY_TYPE);
        }
    }

    public static final class AndOperationMetadata
    extends BooleanOperMetadata {
        public int getPrecedenceLevel() {
            return 20;
        }

        public String getName() {
            return "and";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_LogicalAnd");
        }

        protected void initArguments() {
            this.mArguments.add(ArgumentDescriptor.Predefined.SIMPLE_BOOLEAN);
            this.mArguments.add(ArgumentDescriptor.Predefined.SIMPLE_BOOLEAN);
        }
    }

    public static final class OrOperationMetadata
    extends BooleanOperMetadata {
        public int getPrecedenceLevel() {
            return 10;
        }

        public String getName() {
            return "or";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(OperationMetadataImpl.class, (String)"DN_LogicalOr");
        }

        protected void initArguments() {
            this.mArguments.add(ArgumentDescriptor.Predefined.SIMPLE_BOOLEAN);
            this.mArguments.add(ArgumentDescriptor.Predefined.SIMPLE_BOOLEAN);
        }
    }

    protected static abstract class BooleanOperMetadata
    extends OperationMetadataImpl {
        protected BooleanOperMetadata() {
        }

        public XPathType getResultType() {
            return XPathType.BOOLEAN_TYPE;
        }
    }
}

