/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.metadata;

import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xpath.ext.metadata.XPathMetadataUtils;
import org.netbeans.modules.xml.xpath.ext.metadata.impl.XPathTypes;

public interface XPathType {
    public static final XPathType STRING_TYPE = new XPathTypes.XPathStringType();
    public static final XPathType BOOLEAN_TYPE = new XPathTypes.XPathBooleanType();
    public static final XPathType NUMBER_TYPE = new XPathTypes.XPathNumberType();
    public static final XPathType NODE_SET_TYPE = new XPathTypes.XPathNodeSetType();
    public static final XPathType NODE_TYPE = new XPathTypes.XPathNodeType();
    public static final XPathType ANY_TYPE = new XPathTypes.XPathAnyType();

    public String getName();

    public MetaType getMetaType();

    public boolean isAssignableFrom(XPathType var1);

    public static class XPathSchemaType
    implements XPathType {
        protected SchemaComponent mSchemaType;

        public XPathSchemaType(SchemaComponent schemaComponent) {
            assert (schemaComponent instanceof GlobalType || schemaComponent instanceof LocalType) : "sType parameter can be either local or global type";
            this.mSchemaType = schemaComponent;
        }

        public String getName() {
            return ((Named)this.mSchemaType).getName();
        }

        public MetaType getMetaType() {
            return MetaType.ANY_SCHEMA_TYPE;
        }

        public SchemaComponent getSchemaType() {
            return this.mSchemaType;
        }

        public boolean isAssignableFrom(XPathType xPathType) {
            if (xPathType instanceof XPathSchemaType) {
                SchemaComponent schemaComponent = ((XPathSchemaType)xPathType).getSchemaType();
                if (schemaComponent == this.mSchemaType) {
                    return true;
                }
                return XPathMetadataUtils.isTypeDerived(this.mSchemaType, schemaComponent) || XPathMetadataUtils.isTypeDerived(schemaComponent, this.mSchemaType);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetaType {
        NODE_SET,
        NODE,
        STRING,
        NUMBER,
        BOOLEAN,
        ANY_SCHEMA_TYPE,
        ANY_TYPE;

    }
}

