/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.LocalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xpath.ext.metadata.AbstractArgument;
import org.netbeans.modules.xml.xpath.ext.metadata.ArgumentDescriptor;
import org.netbeans.modules.xml.xpath.ext.metadata.ArgumentGroup;
import org.netbeans.modules.xml.xpath.ext.metadata.XPathType;
import org.netbeans.modules.xml.xpath.ext.schema.CheckTypeDerivationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XPathMetadataUtils {
    public static List<ArgumentDescriptor> getArgDescriptorsList(List<AbstractArgument> list, boolean bl) {
        return XPathMetadataUtils.populateArgList(list, null, bl);
    }

    private static List<ArgumentDescriptor> populateArgList(List<AbstractArgument> list, List<ArgumentDescriptor> list2, boolean bl) {
        for (AbstractArgument abstractArgument : list) {
            if (bl && !abstractArgument.isMandatory()) continue;
            if (abstractArgument instanceof ArgumentDescriptor) {
                if (list2 == null) {
                    list2 = new ArrayList<ArgumentDescriptor>();
                }
                list2.add((ArgumentDescriptor)abstractArgument);
                continue;
            }
            if (!(abstractArgument instanceof ArgumentGroup)) continue;
            List<AbstractArgument> list3 = ((ArgumentGroup)abstractArgument).getArgumentList();
            list2 = XPathMetadataUtils.populateArgList(list3, list2, bl);
        }
        return list2;
    }

    public static GlobalType findPrimitiveType(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Collection collection = SchemaModelFactory.getDefault().getPrimitiveTypesModel().getSchema().getSimpleTypes();
        for (GlobalSimpleType globalSimpleType : collection) {
            if (!string.equals(globalSimpleType.getName())) continue;
            return globalSimpleType;
        }
        return null;
    }

    public static boolean isTypeDerived(SchemaComponent schemaComponent, SchemaComponent schemaComponent2) {
        if (schemaComponent instanceof GlobalType) {
            CheckTypeDerivationVisitor checkTypeDerivationVisitor = new CheckTypeDerivationVisitor((GlobalType)schemaComponent, schemaComponent2);
            return checkTypeDerivationVisitor.isDerived();
        }
        return false;
    }

    public static XPathType calculateXPathType(SchemaComponent schemaComponent) {
        SchemaComponent schemaComponent2 = XPathMetadataUtils.getSchemaType(schemaComponent);
        if (schemaComponent2 == null) {
            return null;
        }
        if (schemaComponent2 instanceof SimpleType) {
            SchemaModel schemaModel = SchemaModelFactory.getDefault().getPrimitiveTypesModel();
            GlobalSimpleType globalSimpleType = (GlobalSimpleType)schemaModel.findByNameAndType("string", GlobalSimpleType.class);
            if (schemaComponent2.equals(globalSimpleType) || XPathMetadataUtils.isTypeDerived(schemaComponent2, (SchemaComponent)globalSimpleType)) {
                return XPathType.STRING_TYPE;
            }
            GlobalSimpleType globalSimpleType2 = (GlobalSimpleType)schemaModel.findByNameAndType("boolean", GlobalSimpleType.class);
            if (schemaComponent2.equals(globalSimpleType2) || XPathMetadataUtils.isTypeDerived(schemaComponent2, (SchemaComponent)globalSimpleType2)) {
                return XPathType.BOOLEAN_TYPE;
            }
            GlobalSimpleType globalSimpleType3 = (GlobalSimpleType)schemaModel.findByNameAndType("decimal", GlobalSimpleType.class);
            if (schemaComponent2.equals(globalSimpleType2) || XPathMetadataUtils.isTypeDerived(schemaComponent2, (SchemaComponent)globalSimpleType3)) {
                return XPathType.NUMBER_TYPE;
            }
            GlobalSimpleType globalSimpleType4 = (GlobalSimpleType)schemaModel.findByNameAndType("double", GlobalSimpleType.class);
            if (schemaComponent2.equals(globalSimpleType2) || XPathMetadataUtils.isTypeDerived(schemaComponent2, (SchemaComponent)globalSimpleType4)) {
                return XPathType.NUMBER_TYPE;
            }
            GlobalSimpleType globalSimpleType5 = (GlobalSimpleType)schemaModel.findByNameAndType("float", GlobalSimpleType.class);
            if (schemaComponent2.equals(globalSimpleType2) || XPathMetadataUtils.isTypeDerived(schemaComponent2, (SchemaComponent)globalSimpleType5)) {
                return XPathType.NUMBER_TYPE;
            }
            GlobalSimpleType globalSimpleType6 = (GlobalSimpleType)schemaModel.findByNameAndType("hexBinary", GlobalSimpleType.class);
            if (schemaComponent2.equals(globalSimpleType2) || XPathMetadataUtils.isTypeDerived(schemaComponent2, (SchemaComponent)globalSimpleType6)) {
                return XPathType.NUMBER_TYPE;
            }
            return XPathType.ANY_TYPE;
        }
        if (schemaComponent2 instanceof ComplexType && schemaComponent instanceof Element) {
            if (XPathMetadataUtils.isElementRepeating((Element)schemaComponent)) {
                return XPathType.NODE_SET_TYPE;
            }
            return XPathType.NODE_TYPE;
        }
        return null;
    }

    public static boolean isElementRepeating(Element element) {
        LocalElement localElement;
        boolean bl = false;
        String string = null;
        if (element instanceof GlobalElement) {
            return false;
        }
        if (element instanceof LocalElement) {
            localElement = (LocalElement)element;
            string = localElement.getMaxOccursEffective();
        } else if (element instanceof ElementReference) {
            localElement = (ElementReference)element;
            string = localElement.getMaxOccursEffective();
        }
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                bl = n > 1;
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        return bl;
    }

    public static SchemaComponent getSchemaType(SchemaComponent schemaComponent) {
        if (schemaComponent instanceof GlobalType || schemaComponent instanceof LocalType) {
            return schemaComponent;
        }
        if (schemaComponent instanceof TypeContainer) {
            NamedComponentReference namedComponentReference = ((TypeContainer)schemaComponent).getType();
            if (namedComponentReference != null) {
                return (SchemaComponent)namedComponentReference.get();
            }
            return ((TypeContainer)schemaComponent).getInlineType();
        }
        if (schemaComponent instanceof ElementReference) {
            GlobalElement globalElement;
            NamedComponentReference namedComponentReference = ((ElementReference)schemaComponent).getRef();
            if (namedComponentReference != null && (globalElement = (GlobalElement)namedComponentReference.get()) != null) {
                return XPathMetadataUtils.getSchemaType((SchemaComponent)globalElement);
            }
        } else {
            if (schemaComponent instanceof LocalAttribute) {
                NamedComponentReference namedComponentReference = ((LocalAttribute)schemaComponent).getType();
                if (namedComponentReference != null) {
                    return (SchemaComponent)namedComponentReference.get();
                }
                return ((LocalAttribute)schemaComponent).getInlineType();
            }
            if (schemaComponent instanceof GlobalAttribute) {
                NamedComponentReference namedComponentReference = ((GlobalAttribute)schemaComponent).getType();
                if (namedComponentReference != null) {
                    return (SchemaComponent)namedComponentReference.get();
                }
                return ((GlobalAttribute)schemaComponent).getInlineType();
            }
        }
        return null;
    }
}

