/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xpath.ext.StepNodeTest;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathUtils;
import org.netbeans.modules.xml.xpath.ext.schema.ExNamespaceContext;
import org.netbeans.modules.xml.xpath.ext.schema.InvalidNamespaceException;
import org.openide.ErrorManager;

public class StepNodeNameTest
extends StepNodeTest {
    private QName mNodeName;

    public StepNodeNameTest(QName qName) {
        this.mNodeName = qName;
    }

    public StepNodeNameTest(XPathModel xPathModel, SchemaComponent schemaComponent) {
        assert (schemaComponent instanceof Named);
        String string = ((Named)schemaComponent).getName();
        QName qName = null;
        if (XPathUtils.isPrefixRequired(schemaComponent)) {
            String string2 = null;
            String string3 = schemaComponent.getModel().getEffectiveNamespace(schemaComponent);
            NamespaceContext namespaceContext = xPathModel.getNamespaceContext();
            if (namespaceContext != null) {
                string2 = namespaceContext.getPrefix(string3);
                if (string2 == null && namespaceContext instanceof ExNamespaceContext) {
                    try {
                        string2 = ((ExNamespaceContext)namespaceContext).addNamespace(string3);
                    }
                    catch (InvalidNamespaceException invalidNamespaceException) {
                        ErrorManager.getDefault().notify((Throwable)invalidNamespaceException);
                    }
                }
                if (string2 == null) {
                    ErrorManager.getDefault().log(16, "A prefix has to be declared for the namespace \"" + string3 + "\"");
                }
            }
            qName = string2 == null || string2.length() == 0 ? new QName(string) : new QName(string3, string, string2);
        } else {
            qName = new QName(string);
        }
        this.mNodeName = qName;
    }

    public QName getNodeName() {
        return this.mNodeName;
    }

    public boolean isWildcard() {
        return this.mNodeName.getLocalPart().equals("*");
    }

    public boolean equals(Object object) {
        if (object instanceof StepNodeNameTest) {
            QName qName = ((StepNodeNameTest)object).getNodeName();
            return XPathUtils.equalsIgnorNsUri(qName, this.mNodeName);
        }
        return false;
    }

    public String toString() {
        return XPathUtils.qNameObjectToString(this.mNodeName);
    }
}

