/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.util;

import java.io.IOException;
import java.net.URL;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlDataManager;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class WsdlUtil {
    private static final String IMPORTED_MARK = ".imported";

    public static WsdlData findWsdlData(String string, String string2) {
        WsdlDataManager wsdlDataManager = (WsdlDataManager)Lookup.getDefault().lookup(WsdlDataManager.class);
        if (wsdlDataManager != null) {
            return wsdlDataManager.findWsdlData(string, string2);
        }
        return null;
    }

    public static WsdlData addWsdlData(String string, String string2) {
        WsdlDataManager wsdlDataManager = (WsdlDataManager)Lookup.getDefault().lookup(WsdlDataManager.class);
        if (wsdlDataManager != null) {
            return wsdlDataManager.addWsdlData(string, string2);
        }
        return null;
    }

    public static WsdlData getWsdlData(String string, String string2, boolean bl) {
        WsdlDataManager wsdlDataManager = (WsdlDataManager)Lookup.getDefault().lookup(WsdlDataManager.class);
        if (wsdlDataManager != null) {
            return wsdlDataManager.getWsdlData(string, string2, bl);
        }
        return null;
    }

    public static void removeWsdlData(WsdlData wsdlData) {
        WsdlDataManager wsdlDataManager = (WsdlDataManager)Lookup.getDefault().lookup(WsdlDataManager.class);
        if (wsdlDataManager != null) {
            wsdlDataManager.removeWsdlData(wsdlData.getOriginalWsdlUrl(), wsdlData.getName());
        }
    }

    public static void saveWsdlData(WsdlData wsdlData) {
        WsdlDataManager wsdlDataManager = (WsdlDataManager)Lookup.getDefault().lookup(WsdlDataManager.class);
        if (wsdlDataManager != null) {
            wsdlDataManager.save(wsdlData);
        }
    }

    public static void refreshWsdlData(WsdlData wsdlData) {
        WsdlDataManager wsdlDataManager = (WsdlDataManager)Lookup.getDefault().lookup(WsdlDataManager.class);
        if (wsdlDataManager != null) {
            wsdlDataManager.refresh(wsdlData);
        }
    }

    public static boolean isJAXRPCAvailable() {
        return WsdlUtil.getWebServiceSupportLibDef(false) != null;
    }

    public static Library getWebServiceSupportLibDef(boolean bl) {
        String string = bl ? "jaxws21" : "jaxrpc16";
        Library library = LibraryManager.getDefault().getLibrary(string);
        return library;
    }

    public static String getCatalogForWsdl(String string) {
        String string2 = WsdlUtil.getServiceDirName(string);
        return "/" + string2 + "/catalog/catalog.xml";
    }

    public static String getServiceDirName(String string) {
        try {
            int n;
            URL uRL = new URL(string);
            String string2 = uRL.getPath();
            n = uRL.getProtocol().toLowerCase().startsWith("file") ? ((n = string2.lastIndexOf(System.getProperty("path.separator"))) < 0 ? string2.lastIndexOf("/") : n) : string2.lastIndexOf("/");
            return string2.substring(++n).replace('.', '-');
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return SaasUtil.ensureUniqueServiceDirName("Service");
        }
    }

    public static boolean hasProcessedImport() {
        return SaasServicesModel.getWebServiceHome().getFileObject(IMPORTED_MARK) != null;
    }

    public static void markImportProcessed() {
        if (!WsdlUtil.hasProcessedImport()) {
            try {
                SaasServicesModel.getWebServiceHome().createData(IMPORTED_MARK);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public static void ensureImportExisting60Services() {
        if (!WsdlUtil.hasProcessedImport()) {
            WsdlUtil.findWsdlData("/foo", "bar");
        }
    }
}

