/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.refactoring.xsd;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.refactoring.WSDLRefactoringElement;
import org.netbeans.modules.xml.wsdl.refactoring.WSDLRefactoringEngine;
import org.netbeans.modules.xml.wsdl.refactoring.xsd.FindSchemaUsageVisitor;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaUsageRefactoringEngine {
    public Component getSearchRoot(FileObject fileObject) throws IOException {
        return WSDLRefactoringEngine.getWSDLDefinitions(fileObject);
    }

    public List<WSDLRefactoringElement> findUsages(Component component, Component component2, RefactoringSession refactoringSession, XMLRefactoringTransaction xMLRefactoringTransaction) {
        if (component instanceof ReferenceableSchemaComponent && component2 instanceof Definitions) {
            return new FindSchemaUsageVisitor().findUsages((ReferenceableSchemaComponent)component, (Definitions)component2, refactoringSession, xMLRefactoringTransaction);
        }
        return null;
    }

    public List<WSDLRefactoringElement> findUsages(Model model, Component component) {
        ArrayList<WSDLRefactoringElement> arrayList = new ArrayList<WSDLRefactoringElement>();
        if (model instanceof SchemaModel && component instanceof Definitions) {
            ModelSource modelSource;
            Object object2;
            Definitions definitions = (Definitions)component;
            String string = ((SchemaModel)model).getSchema().getTargetNamespace();
            FileObject fileObject = (FileObject)component.getModel().getModelSource().getLookup().lookup(FileObject.class);
            if (string == null) {
                return null;
            }
            for (Object object2 : definitions.getImports()) {
                if (!string.equals(object2.getNamespace()) || !SchemaUsageRefactoringEngine.areSameSource(modelSource = SchemaUsageRefactoringEngine.resolve((Model)definitions.getModel(), object2.getLocation(), string), model.getModelSource())) continue;
                arrayList.add(new WSDLRefactoringElement(component.getModel(), (Referenceable)model, (Component)object2));
                return arrayList;
            }
            Types types = definitions.getTypes();
            object2 = Collections.emptyList();
            if (types != null && types.getSchemas() != null) {
                object2 = types.getSchemas();
            }
            modelSource = object2.iterator();
            while (modelSource.hasNext()) {
                Schema schema = (Schema)modelSource.next();
                for (SchemaModelReference schemaModelReference : schema.getSchemaReferences()) {
                    if (!SchemaUsageRefactoringEngine.isReferenceTo(schemaModelReference, (SchemaModel)model)) continue;
                    FileObject fileObject2 = (FileObject)schemaModelReference.getModel().getModelSource().getLookup().lookup(FileObject.class);
                    arrayList.add(new WSDLRefactoringElement(component.getModel(), (Referenceable)model, (Component)schemaModelReference));
                    return arrayList;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _refactorUsages(Model model, Set<RefactoringElementImplementation> set, AbstractRefactoring abstractRefactoring) throws IOException {
        if (abstractRefactoring == null || set == null || model == null) {
            return;
        }
        if (!(model instanceof WSDLModel)) {
            return;
        }
        WSDLModel wSDLModel = (WSDLModel)model;
        boolean bl = !wSDLModel.isIntransaction();
        try {
            if (bl) {
                wSDLModel.startTransaction();
            }
            for (RefactoringElementImplementation refactoringElementImplementation : set) {
                String string;
                Import import_;
                if (refactoringElementImplementation.getLookup().lookup(Import.class) != null) {
                    import_ = (Import)refactoringElementImplementation.getLookup().lookup(Import.class);
                    string = import_.getLocation();
                    if (abstractRefactoring instanceof RenameRefactoring) {
                        string = SharedUtils.calculateNewLocationString((String)import_.getLocation(), (RenameRefactoring)((RenameRefactoring)abstractRefactoring));
                    } else if (abstractRefactoring instanceof MoveRefactoring) {
                        try {
                            string = SharedUtils.calculateNewLocationString((Model)model, (MoveRefactoring)((MoveRefactoring)abstractRefactoring));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    import_.setLocation(string);
                    continue;
                }
                if (refactoringElementImplementation.getLookup().lookup(SchemaModelReference.class) == null) continue;
                import_ = (SchemaModelReference)refactoringElementImplementation.getLookup().lookup(SchemaModelReference.class);
                string = import_.getSchemaLocation();
                if (abstractRefactoring instanceof RenameRefactoring) {
                    string = this.calculateNewLocationString(import_.getSchemaLocation(), (RenameRefactoring)abstractRefactoring);
                } else if (abstractRefactoring instanceof MoveRefactoring) {
                    try {
                        string = SharedUtils.calculateNewLocationString((Model)model, (MoveRefactoring)((MoveRefactoring)abstractRefactoring));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                import_.setSchemaLocation(string);
            }
        }
        finally {
            if (bl && wSDLModel.isIntransaction()) {
                wSDLModel.endTransaction();
            }
        }
    }

    public String calculateNewLocationString(String string, RenameRefactoring renameRefactoring) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.lastIndexOf(47);
        if (n > -1) {
            stringBuilder.append(string.substring(0, n + 1));
        }
        stringBuilder.append(renameRefactoring.getNewName());
        stringBuilder.append(".");
        Referenceable referenceable = (Referenceable)renameRefactoring.getRefactoringSource().lookup(Referenceable.class);
        Model model = SharedUtils.getModel((Referenceable)referenceable);
        FileObject fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        stringBuilder.append(fileObject.getExt());
        return stringBuilder.toString();
    }

    public static String getLocationReferenceAttributeName(Component component) {
        if (component instanceof Import) {
            return "location";
        }
        if (component instanceof SchemaModelReference) {
            return "schemaLocation";
        }
        return "ref";
    }

    public static ModelSource resolveModelSource(String string, Model model, CatalogModel catalogModel) {
        ModelSource modelSource = null;
        try {
            if (string != null) {
                URI uRI = new URI(string);
                modelSource = catalogModel.getModelSource(uRI, model.getModelSource());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            SchemaUsageRefactoringEngine.log(uRISyntaxException.getMessage());
        }
        catch (CatalogModelException catalogModelException) {
            SchemaUsageRefactoringEngine.log(catalogModelException.getMessage());
        }
        return modelSource;
    }

    private static void log(String string) {
        Logger.getLogger(SchemaUsageRefactoringEngine.class.getName()).log(Level.FINE, string);
    }

    public static ModelSource resolve(Model model, String string, String string2) {
        CatalogModel catalogModel = (CatalogModel)model.getModelSource().getLookup().lookup(CatalogModel.class);
        ModelSource modelSource = SchemaUsageRefactoringEngine.resolveModelSource(string, model, catalogModel);
        if (modelSource == null) {
            modelSource = SchemaUsageRefactoringEngine.resolveModelSource(string2, model, catalogModel);
        }
        return modelSource;
    }

    public static boolean areSameSource(ModelSource modelSource, ModelSource modelSource2) {
        if (modelSource == null || modelSource2 == null) {
            return false;
        }
        DataObject dataObject = (DataObject)modelSource.getLookup().lookup(DataObject.class);
        DataObject dataObject2 = (DataObject)modelSource2.getLookup().lookup(DataObject.class);
        return dataObject != null && dataObject.equals(dataObject2);
    }

    public static boolean isReferenceTo(SchemaModelReference schemaModelReference, SchemaModel schemaModel) {
        try {
            return schemaModel == schemaModelReference.resolveReferencedModel();
        }
        catch (CatalogModelException catalogModelException) {
            SchemaUsageRefactoringEngine.log(catalogModelException.getMessage());
            return false;
        }
    }

    public String getModelReference(Component component) {
        if (component instanceof SchemaModelReference) {
            return ((SchemaModelReference)component).getSchemaLocation();
        }
        return null;
    }
}

