/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.refactoring;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.refactoring.FindWSDLUsageVisitor;
import org.netbeans.modules.xml.wsdl.refactoring.WSDLRefactoringElement;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLRefactoringEngine {
    public static final String WSDL_MIME_TYPE = "text/x-wsdl+xml";

    public Component getSearchRoot(FileObject fileObject) throws IOException {
        return WSDLRefactoringEngine.getWSDLDefinitions(fileObject);
    }

    public static Definitions getWSDLDefinitions(FileObject fileObject) throws IOException {
        if (!WSDL_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)fileObject))) {
            return null;
        }
        ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
        WSDLModel wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
        if (wSDLModel != null) {
            if (wSDLModel.getState().equals((Object)Model.State.VALID)) {
                return wSDLModel.getDefinitions();
            }
            String string = NbBundle.getMessage(WSDLRefactoringEngine.class, (String)"MSG_ModelSourceMalformed", (Object)fileObject.getPath());
            throw new IOException(string);
        }
        return null;
    }

    public List<WSDLRefactoringElement> findUsages(Component component, Component component2) {
        if (component instanceof ReferenceableWSDLComponent && component2 instanceof Definitions) {
            return new FindWSDLUsageVisitor().findUsages((ReferenceableWSDLComponent)component, (Definitions)component2);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _refactorUsages(Model model, Set<RefactoringElementImplementation> set, AbstractRefactoring abstractRefactoring) {
        if (abstractRefactoring == null || set == null || model == null) {
            return;
        }
        if (!(model instanceof WSDLModel)) {
            return;
        }
        boolean bl = !model.isIntransaction();
        try {
            if (bl) {
                model.startTransaction();
            }
            for (RefactoringElementImplementation refactoringElementImplementation : set) {
                Import import_ = (Import)refactoringElementImplementation.getLookup().lookup(Import.class);
                if (import_ == null) continue;
                String string = import_.getLocation();
                if (abstractRefactoring instanceof RenameRefactoring) {
                    string = SharedUtils.calculateNewLocationString((String)import_.getLocation(), (RenameRefactoring)((RenameRefactoring)abstractRefactoring));
                } else if (abstractRefactoring instanceof MoveRefactoring) {
                    try {
                        string = SharedUtils.calculateNewLocationString((Model)model, (MoveRefactoring)((MoveRefactoring)abstractRefactoring));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                import_.setLocation(string);
            }
        }
        finally {
            if (bl && model.isIntransaction()) {
                model.endTransaction();
            }
        }
    }

    public String calculateNewLocationString(String string, RenameRefactoring renameRefactoring) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.lastIndexOf(47);
        if (n > -1) {
            stringBuilder.append(string.substring(0, n + 1));
        }
        stringBuilder.append(renameRefactoring.getNewName());
        stringBuilder.append(".");
        Referenceable referenceable = (Referenceable)renameRefactoring.getRefactoringSource().lookup(Referenceable.class);
        Model model = SharedUtils.getModel((Referenceable)referenceable);
        FileObject fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        stringBuilder.append(fileObject.getExt());
        return stringBuilder.toString();
    }

    public String getModelReference(Component component) {
        if (component instanceof Import) {
            return ((Import)component).getLocation();
        }
        return null;
    }
}

