/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.util;

import java.text.DecimalFormat;
import org.openide.util.NbBundle;

public class Duration {
    static final DecimalFormat FMT = new DecimalFormat(".###");
    boolean negative;
    int years;
    int months;
    int days;
    int hours;
    int minutes;
    int seconds;
    int milliseconds;

    public Duration() {
    }

    public Duration(Duration duration) {
        this.negative = duration.negative;
        this.years = duration.years;
        this.months = duration.months;
        this.days = duration.days;
        this.hours = duration.hours;
        this.minutes = duration.minutes;
        this.seconds = duration.seconds;
        this.milliseconds = duration.milliseconds;
    }

    private void check(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(NbBundle.getMessage(Duration.class, (String)"STR_VALUE_CANNOT_BE_NEGATIVE"));
        }
    }

    public void setYears(int n) {
        this.check(n);
        this.years = n;
    }

    public void setMonths(int n) {
        this.check(n);
        this.months = n;
    }

    public void setDays(int n) {
        this.check(n);
        this.days = n;
    }

    public void setHours(int n) {
        this.check(n);
        this.hours = n;
    }

    public void setMinutes(int n) {
        this.check(n);
        this.minutes = n;
    }

    public void setSeconds(int n) {
        this.check(n);
        this.seconds = n;
    }

    public void setMilliseconds(int n) {
        this.check(n);
        this.milliseconds = n;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setNegative(boolean bl) {
        this.negative = bl;
    }

    public String toString() {
        String string = "";
        if (this.negative) {
            string = string + "-";
        }
        string = string + "P";
        if (this.years > 0) {
            string = string + this.years;
            string = string + "Y";
        }
        string = string + this.months;
        string = string + "M";
        if (this.days > 0) {
            string = string + this.days;
            string = string + "D";
        }
        if (this.hours > 0 || this.minutes > 0 || this.seconds > 0 || this.milliseconds > 0) {
            string = string + "T";
            if (this.hours > 0) {
                string = string + this.hours;
                string = string + "H";
            }
            if (this.minutes > 0) {
                string = string + this.minutes;
                string = string + "M";
            }
            if (this.seconds > 0 || this.milliseconds > 0) {
                string = string + this.seconds;
                if (this.milliseconds > 0) {
                    string = string + FMT.format((double)this.milliseconds / 1000.0);
                }
                string = string + "S";
            }
        }
        return string;
    }

    public static Duration parse(String string) {
        if (string.startsWith("'")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        DurationParser durationParser = new DurationParser(string);
        return durationParser.parseDuration();
    }

    static class DurationParser {
        Duration result;
        char[] buf;
        int mark;
        int pos;
        String val = null;

        DurationParser(String string) {
            this.buf = string.toCharArray();
            this.pos = this.buf.length - 1;
            this.val = string;
            this.result = new Duration();
        }

        int peek() {
            if (this.pos < 0) {
                throw new RuntimeException(NbBundle.getMessage(Duration.class, (String)"STR_MALFORMED_DURATION"));
            }
            return this.buf[this.pos];
        }

        void lex() {
            --this.pos;
        }

        int parseInt() {
            int n = this.pos;
            while (this.pos > 0 && Character.isDigit(this.buf[this.pos - 1])) {
                --this.pos;
            }
            int n2 = Integer.parseInt(new String(this.buf, this.pos, n + 1 - this.pos));
            --this.pos;
            return n2;
        }

        boolean parseSeconds() {
            if (this.peek() == 83) {
                this.lex();
                int n = this.parseInt();
                if (this.peek() == 46) {
                    this.result.setMilliseconds((int)(Double.parseDouble("0." + n) * 1000.0));
                    this.lex();
                    n = this.parseInt();
                }
                this.result.setSeconds(n);
                return true;
            }
            return false;
        }

        boolean parseMinutes() {
            if (this.peek() == 77 && this.val.indexOf("T") != -1) {
                this.lex();
                this.result.setMinutes(this.parseInt());
                return true;
            }
            return false;
        }

        boolean parseHours() {
            if (this.peek() == 72) {
                this.lex();
                this.result.setHours(this.parseInt());
                return true;
            }
            return false;
        }

        void parseT() {
            if (this.peek() != 84) {
                throw new RuntimeException(NbBundle.getMessage(Duration.class, (String)"STR_EXPECTED_T_INSTEAD_OF_X", (Object)new Character((char)this.peek())));
            }
            this.lex();
        }

        void parseP() {
            if (this.peek() != 80) {
                throw new RuntimeException(NbBundle.getMessage(Duration.class, (String)"STR_EXPECTED_P_INSTEAD_OF_X", (Object)new Character((char)this.peek())));
            }
            this.lex();
        }

        boolean parseDay() {
            if (this.peek() == 68) {
                this.lex();
                this.result.setDays(this.parseInt());
                return true;
            }
            return false;
        }

        boolean parseMonth() {
            if (this.peek() == 77) {
                this.lex();
                this.result.setMonths(this.parseInt());
                return true;
            }
            return false;
        }

        boolean parseYear() {
            if (this.peek() == 89) {
                this.lex();
                this.result.setYears(this.parseInt());
                return true;
            }
            return false;
        }

        Duration parseDuration() {
            boolean bl = false;
            if (this.parseSeconds()) {
                bl = true;
            }
            if (this.parseMinutes()) {
                bl = true;
            }
            if (this.parseHours()) {
                bl = true;
            }
            if (bl) {
                this.parseT();
            }
            if (this.parseDay()) {
                bl = true;
            }
            if (this.parseMonth()) {
                bl = true;
            }
            if (this.parseYear()) {
                bl = true;
            }
            this.parseP();
            this.parseEnd(bl);
            return this.result;
        }

        void parseEnd(boolean bl) {
            if (!bl) {
                throw new RuntimeException(NbBundle.getMessage(Duration.class, (String)"STR_NO_FIELDS_SPECIFIED"));
            }
            if (this.pos > 0) {
                throw new RuntimeException(NbBundle.getMessage(Duration.class, (String)"STR_UNEXPECTED_TEXT") + new String(this.buf, 0, this.pos));
            }
        }
    }
}

