/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.common.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import org.netbeans.modules.soa.mapper.common.util.DNDComponentInterface;

public class DNDList
extends JList
implements DNDComponentInterface,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    private DropTarget mDropTarget = null;
    private DragSource mDragSource = null;
    protected DataFlavor[] mDataFlavorArray = new DataFlavor[1];

    public DNDList() {
        this.init();
    }

    public DNDList(ListModel listModel) {
        super(listModel);
        this.init();
    }

    public DNDList(Vector vector) {
        super(vector);
        this.init();
    }

    public DNDList(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    protected void init() {
        this.mDropTarget = new DropTarget(this, this);
        this.mDragSource = new DragSource();
        this.mDragSource.createDefaultDragGestureRecognizer(this, 1, this);
        try {
            this.mDataFlavorArray[0] = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Object e = this.getSelectedValue();
        if (e != null) {
            StringSelection stringSelection = new StringSelection(e.toString());
            this.mDragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, stringSelection, this);
        } else {
            System.out.println("nothing was selected");
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        System.out.println("dragEnter");
        dropTargetDragEvent.acceptDrag(1);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        System.out.println("dragExit");
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        System.out.println("dragOver");
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(this.mDataFlavorArray[0])) {
                dropTargetDropEvent.acceptDrop(1);
                String string = (String)transferable.getTransferData(this.mDataFlavorArray[0]);
                this.addElement(string);
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("Exception" + iOException.getMessage());
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            System.err.println("Exception" + unsupportedFlavorException.getMessage());
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess()) {
            System.out.println(" dragDropEnd -> DropSuccess");
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        System.out.println(" dragEnter");
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        System.out.println("dragExit");
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        System.out.println("dragExit");
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        System.out.println("dropActionChanged");
    }

    public void addElement(Object object) {
        ((DefaultListModel)this.getModel()).addElement(object.toString());
    }

    public void removeElement() {
        ((DefaultListModel)this.getModel()).removeElement(this.getSelectedValue());
    }
}

