/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.util;

import com.nwoods.jgo.JGoDocument;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import org.netbeans.modules.soa.mapper.common.IMapperEvent;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;

public class MapperUtilities {
    private static DataFlavor[] mLocalObjectDataFlavors = new DataFlavor[1];

    private MapperUtilities() {
    }

    public static DataFlavor getJVMLocalObjectDataFlavor() {
        return mLocalObjectDataFlavors[0];
    }

    public static DataFlavor getJGoSelectionDataFlavor() {
        return JGoDocument.getStandardDataFlavor();
    }

    public static IMapperEvent getMapperEvent(final Object object, final Object object2, final String string, final String string2) {
        return new IMapperEvent(){

            public String getDesc() {
                return string2;
            }

            public String getEventType() {
                return string;
            }

            public Object getSource() {
                return object;
            }

            public Object getTransferObject() {
                return object2;
            }

            public String toString() {
                return string2;
            }
        };
    }

    public static void addDividerLocationInitializer(JSplitPane jSplitPane, double d) {
        new DividerLocationListener(jSplitPane, d);
    }

    public static void firePropertyChanged(PropertyChangeListener[] propertyChangeListenerArray, Object object, String string, Object object2, Object object3) {
        if (propertyChangeListenerArray == null || propertyChangeListenerArray.length == 0) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(object, string, object3, object2);
        for (int i = propertyChangeListenerArray.length - 1; i >= 0; --i) {
            propertyChangeListenerArray[i].propertyChange(propertyChangeEvent);
        }
    }

    public static boolean isLinkAlreadyConnected(IMapperLink iMapperLink, IMapperNode iMapperNode) {
        List list = iMapperNode.getLinks();
        if (iMapperLink.getStartNode() != null) {
            for (IMapperLink iMapperLink2 : list) {
                if (iMapperLink2.getEndNode() == null) continue;
                return true;
            }
        }
        if (iMapperLink.getEndNode() != null) {
            for (IMapperLink iMapperLink2 : list) {
                if (iMapperLink2.getStartNode() == null) continue;
                return true;
            }
        }
        return false;
    }

    public static void activateInlineMnemonics(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; componentArray != null && i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof JLabel || component instanceof AbstractButton) {
                MapperUtilities.activateInlineMnemonics(component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            MapperUtilities.activateInlineMnemonics((Container)component);
        }
    }

    public static void activateInlineMnemonics(Component component) {
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)jLabel.getText());
        } else if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Mnemonics.setLocalizedText((AbstractButton)abstractButton, (String)abstractButton.getText());
        }
    }

    public static boolean isEmpty(String string) {
        return null == string || string.trim().length() == 0;
    }

    public static String cutAmpersand(String string) {
        return Actions.cutAmpersand((String)string);
    }

    static {
        try {
            MapperUtilities.mLocalObjectDataFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("This should not happen! Can't found DataFlavor.javaJVMLocalObjectMimeType.");
            classNotFoundException.printStackTrace(System.err);
        }
    }

    public static class DividerLocationListener
    implements PropertyChangeListener {
        private double mProportion = 0.5;
        private JSplitPane mSpliter;

        public DividerLocationListener(JSplitPane jSplitPane, double d) {
            if (d < 0.0 || d > 1.0) {
                throw new IllegalArgumentException("proportion is not between 0.0 and 1.0: " + d);
            }
            this.mProportion = d;
            this.mSpliter = jSplitPane;
            this.mSpliter.addPropertyChangeListener("dividerLocation", this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.mSpliter.removePropertyChangeListener("dividerLocation", this);
            int n = 0;
            n = this.mSpliter.getOrientation() == 0 ? this.mSpliter.getHeight() : this.mSpliter.getWidth();
            this.mSpliter.setDividerLocation((int)((double)n * this.mProportion));
        }
    }
}

