/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.tree;

import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoView;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mapper.basicmapper.tree.AbstractMapperTree;
import org.netbeans.modules.soa.mapper.basicmapper.tree.BasicMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;

public class SourceTree
extends AbstractMapperTree {
    public SourceTree() {
        this(null);
    }

    public SourceTree(TreeModel treeModel) {
        super(treeModel);
        this.initialize();
    }

    public IMapperTreeNode createMapperTreeNode(TreePath treePath) {
        return this.newMapperTreeNode(treePath);
    }

    protected IMapperTreeNode newMapperTreeNode(TreePath treePath) {
        return new BasicMapperTreeNode(this, treePath, true, false);
    }

    public boolean contains(IMapperTreeNode iMapperTreeNode) {
        return iMapperTreeNode.isSourceTreeNode();
    }

    public Point getTreeNodePoint(Rectangle rectangle) {
        int n = rectangle.y + rectangle.height / 2;
        int n2 = rectangle.x + rectangle.width;
        return new Point(n2, n);
    }

    protected void drawNode(Graphics graphics, IMapperTreeNode iMapperTreeNode) {
        if (iMapperTreeNode.getLinkCount() <= 0) {
            return;
        }
        List list = iMapperTreeNode.getLinks();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((IMapperLink)list.get(i)).getStartNode().equals(iMapperTreeNode)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        TreePath treePath = iMapperTreeNode.getPath();
        Rectangle rectangle = this.getShowingPathRectBound(treePath);
        if (rectangle == null) {
            return;
        }
        Point point = this.getTreeNodePoint(rectangle);
        if (point == null) {
            return;
        }
        int n = this.getTree().getSize().width - point.x;
        boolean bl2 = !rectangle.equals(this.getTree().getPathBounds(treePath));
        this.drawLine(iMapperTreeNode, bl2, graphics, point.x, point.y, point.x + n, point.y);
        int n2 = this.getScrollerPane().getViewport().getViewPosition().y;
        iMapperTreeNode.setX(point.x);
        iMapperTreeNode.setY(point.y - n2);
    }

    private void initialize() {
        this.getScrollerPane().setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.getScrollerPane().setPreferredSize(new Dimension(250, 100));
    }

    protected void highlightSingleLink(IMapperLink iMapperLink) {
        IMapperNode iMapperNode = iMapperLink.getEndNode();
        JGoObject jGoObject = (JGoObject)this.getViewManager().getCanvasView().getCanvas().getCanvasNodeByDataObject(iMapperNode);
        if (jGoObject != null) {
            ((JGoView)this.getViewManager().getCanvasView().getCanvas()).scrollRectToVisible(jGoObject.getBoundingRect());
        } else if (iMapperNode instanceof IMapperTreeNode) {
            IMapperTreeNode iMapperTreeNode = (IMapperTreeNode)iMapperNode;
            this.highlightSingleTreeNode(iMapperTreeNode);
            this.scrollToSingleTreeNode(iMapperTreeNode);
        }
    }

    protected void unHighlightSingleLink(IMapperLink iMapperLink) {
        IMapperNode iMapperNode = iMapperLink.getEndNode();
        if (iMapperNode instanceof IMapperTreeNode) {
            IMapperTreeNode iMapperTreeNode = (IMapperTreeNode)iMapperNode;
            this.unHighlightSingleTreeNode(iMapperTreeNode);
        }
    }

    private void highlightSingleTreeNode(IMapperTreeNode iMapperTreeNode) {
        iMapperTreeNode.setHighlightLink(true);
        this.getViewManager().getDestView().getTree().repaint();
    }

    private void unHighlightSingleTreeNode(IMapperTreeNode iMapperTreeNode) {
        iMapperTreeNode.setHighlightLink(false);
        this.getViewManager().getDestView().getTree().repaint();
    }

    private void scrollToSingleTreeNode(IMapperTreeNode iMapperTreeNode) {
        this.getViewManager().getDestView().getTree().scrollPathToVisible(iMapperTreeNode.getPath());
    }
}

