/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.tree;

import com.nwoods.jgo.JGoView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.dnd.Autoscroll;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mapper.basicmapper.BasicMapperView;
import org.netbeans.modules.soa.mapper.basicmapper.MapperNode;
import org.netbeans.modules.soa.mapper.basicmapper.tree.MapperTreeAutoLayout;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.IMapperViewModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMapperLink;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeView;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasLink;
import org.netbeans.modules.soa.ui.TooltipTextProvider;

public abstract class AbstractMapperTree
extends BasicMapperView
implements IMapperTreeView {
    protected static final Stroke STROKE_SELECTED = new BasicStroke(2.0f);
    protected static final Stroke STROKE_HIGHLIGHTED = new BasicStroke(1.0f);
    protected static final Stroke STROKE_FOLDED = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
    int mScrollToVisible;
    private PropertyChangeListener mModelListener = new ViewModelChangeListener();
    private PropertyChangeListener mNodeLinkListener = new NodeLinkListener();
    private List mTreeNode;
    private JTree mTree;
    private JScrollPane mScroller;
    private TreePath lastPath;

    public AbstractMapperTree() {
        this(null);
    }

    public AbstractMapperTree(TreeModel treeModel) {
        this.initialize();
        if (treeModel != null) {
            this.mTree.setModel(treeModel);
        }
        this.setAutoLayout(new MapperTreeAutoLayout(this));
    }

    public JScrollPane getScrollerPane() {
        return this.mScroller;
    }

    public void setViewModel(IMapperViewModel iMapperViewModel) {
        IMapperViewModel iMapperViewModel2 = this.getViewModel();
        if (iMapperViewModel2 != null) {
            iMapperViewModel2.removePropertyChangeListener(this.mModelListener);
        }
        if (iMapperViewModel != null) {
            iMapperViewModel.addPropertyChangeListener(this.mModelListener);
            this.filterNodeModel(iMapperViewModel);
        } else {
            this.mTreeNode.clear();
        }
        super.setViewModel(iMapperViewModel);
        this.autoLayout();
    }

    public JTree getTree() {
        return this.mTree;
    }

    public List getCachedTreeNodes() {
        return this.mTreeNode;
    }

    public IMapperTreeNode getMapperTreeNode(TreePath treePath) {
        List list = this.getCachedTreeNodes();
        for (int i = 0; i < list.size(); ++i) {
            IMapperTreeNode iMapperTreeNode = (IMapperTreeNode)list.get(i);
            if (!iMapperTreeNode.getPath().equals(treePath)) continue;
            return iMapperTreeNode;
        }
        return this.newMapperTreeNode(treePath);
    }

    public String toString() {
        String string = super.toString() + " [link model=";
        string = this.getViewModel() != null ? string + this.getViewModel().getClass().getName() + ", node count=" + this.getViewModel().getNodeCount() + "]" : string + " null]";
        return string;
    }

    public Rectangle getShowingPathRectBound(TreePath treePath) {
        Rectangle rectangle = null;
        while (treePath != null && (rectangle = this.getTree().getPathBounds(treePath)) == null) {
            treePath = treePath.getParentPath();
        }
        if (treePath != null && treePath.getParentPath() == null && !this.getTree().isRootVisible()) {
            return null;
        }
        return rectangle;
    }

    protected abstract void highlightSingleLink(IMapperLink var1);

    protected abstract void unHighlightSingleLink(IMapperLink var1);

    public abstract Point getTreeNodePoint(Rectangle var1);

    protected void autoLayout() {
        if (this.getAutoLayout() != null) {
            this.getAutoLayout().autoLayout();
        } else {
            this.mTree.repaint();
        }
    }

    protected abstract void drawNode(Graphics var1, IMapperTreeNode var2);

    protected abstract IMapperTreeNode newMapperTreeNode(TreePath var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void filterNodeModel(IMapperViewModel iMapperViewModel) {
        List list = this.mTreeNode;
        synchronized (list) {
            Iterator iterator = this.mTreeNode.iterator();
            while (iterator.hasNext()) {
                ((IMapperNode)iterator.next()).removePropertyChangeListener(this.mNodeLinkListener);
            }
            this.mTreeNode.clear();
            for (Object e : iMapperViewModel.getNodes()) {
                if (!(e instanceof IMapperTreeNode) || !this.contains((IMapperTreeNode)e)) continue;
                ((IMapperTreeNode)e).addPropertyChangeListener(this.mNodeLinkListener);
                this.mTreeNode.add(e);
            }
        }
    }

    private void initialize() {
        this.mTreeNode = new Vector();
        this.mTree = new TreeView();
        this.mTree.addMouseMotionListener(new TreeMouseMotionAdaptor());
        this.mScroller = new JScrollPane(this.mTree);
        this.mScroller.getVerticalScrollBar().addAdjustmentListener(new VerticalBarListener());
        this.mScroller.setBorder(null);
        this.setViewComponent(this.mScroller);
    }

    public Point getViewOffset() {
        return this.getScrollerPane().getViewport().getViewPosition();
    }

    protected Color getDrawColor(IMapperTreeNode iMapperTreeNode) {
        if (iMapperTreeNode.isSelectedLink()) {
            return ICanvasMapperLink.DEFAULT_LINK_SELECTED_COLOR;
        }
        if (iMapperTreeNode.isHighlightLink()) {
            return ICanvasMapperLink.DEFAULT_LINK_SELECTED_COLOR;
        }
        return ICanvasMapperLink.DEFAULT_LINK_COLOR;
    }

    protected void drawLine(IMapperTreeNode iMapperTreeNode, boolean bl, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Color color = graphics2D.getColor();
        graphics.setColor(this.getDrawColor(iMapperTreeNode));
        if (iMapperTreeNode.isSelectedLink()) {
            graphics2D.setStroke(STROKE_SELECTED);
        } else if (iMapperTreeNode.isHighlightLink()) {
            graphics2D.setStroke(STROKE_HIGHLIGHTED);
        } else if (bl) {
            graphics2D.setStroke(STROKE_FOLDED);
        }
        graphics2D.drawLine(n, n2, n3, n4);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    private class NodeLinkListener
    implements PropertyChangeListener {
        private NodeLinkListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("MNode.AddLink") || propertyChangeEvent.getPropertyName().equals("MNode.RemoveLink")) {
                AbstractMapperTree.this.autoLayout();
            }
        }
    }

    private class ViewModelChangeListener
    implements PropertyChangeListener {
        private ViewModelChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            IMapperNode iMapperNode;
            if (propertyChangeEvent.getPropertyName().equals("MapperVM.AddNode")) {
                Object object = propertyChangeEvent.getNewValue();
                if (object instanceof IMapperTreeNode && AbstractMapperTree.this.contains((IMapperTreeNode)object)) {
                    AbstractMapperTree.this.mTreeNode.add(object);
                    ((IMapperTreeNode)object).addPropertyChangeListener(AbstractMapperTree.this.mNodeLinkListener);
                    AbstractMapperTree.this.autoLayout();
                }
            } else if (propertyChangeEvent.getPropertyName().equals("MapperVM.RemoveNode") && (iMapperNode = (IMapperNode)propertyChangeEvent.getOldValue()) instanceof IMapperTreeNode && AbstractMapperTree.this.contains((IMapperTreeNode)iMapperNode)) {
                AbstractMapperTree.this.mTreeNode.remove(iMapperNode);
                ((IMapperTreeNode)iMapperNode).removePropertyChangeListener(AbstractMapperTree.this.mNodeLinkListener);
                AbstractMapperTree.this.autoLayout();
            }
        }
    }

    private class VerticalBarListener
    implements AdjustmentListener {
        private VerticalBarListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (AbstractMapperTree.this.mScrollToVisible > 0) {
                return;
            }
            int n = AbstractMapperTree.this.getScrollerPane().getViewport().getViewPosition().y;
            Iterator iterator = AbstractMapperTree.this.mTreeNode.iterator();
            Object var4_4 = null;
            Point point = null;
            TreePath treePath = null;
            while (iterator.hasNext()) {
                var4_4 = iterator.next();
                if (!(var4_4 instanceof IMapperTreeNode)) continue;
                treePath = ((IMapperTreeNode)var4_4).getPath();
                Rectangle rectangle = AbstractMapperTree.this.getShowingPathRectBound(treePath);
                if (rectangle == null) {
                    return;
                }
                point = AbstractMapperTree.this.getTreeNodePoint(rectangle);
                if (point == null || !(var4_4 instanceof MapperNode)) continue;
                ((MapperNode)var4_4).setX(point.x);
                ((MapperNode)var4_4).setY(point.y - n);
            }
        }
    }

    protected class TreeView
    extends JTree
    implements Autoscroll {
        private int UNREALISTIC_SIZE = 99999;
        private Insets mAutoscrollInsets = new Insets(20, 20, this.UNREALISTIC_SIZE, this.UNREALISTIC_SIZE);

        public TreeView() {
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (AbstractMapperTree.this.mTreeNode == null) {
                return;
            }
            Color color = graphics.getColor();
            graphics.setColor(ICanvasMapperLink.DEFAULT_LINK_COLOR);
            List list = AbstractMapperTree.this.mTreeNode;
            synchronized (list) {
                for (IMapperTreeNode iMapperTreeNode : AbstractMapperTree.this.mTreeNode) {
                    graphics.setColor(ICanvasMapperLink.DEFAULT_LINK_COLOR);
                    AbstractMapperTree.this.drawNode(graphics, iMapperTreeNode);
                }
            }
            graphics.setColor(color);
        }

        public Insets getAutoscrollInsets() {
            return this.mAutoscrollInsets;
        }

        public void autoscroll(Point point) {
            Point point2 = new Point(point.x - 10, point.y - 10);
            this.scrollRectToVisible(new Rectangle(point2, new Dimension(30, 30)));
        }

        public void scrollPathToVisible(TreePath treePath) {
            ++AbstractMapperTree.this.mScrollToVisible;
            super.scrollPathToVisible(treePath);
            --AbstractMapperTree.this.mScrollToVisible;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string;
            Object object;
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && (object = treePath.getLastPathComponent()) != null && object instanceof TooltipTextProvider && (string = ((TooltipTextProvider)object).getTooltipText()) != null && string.length() != 0) {
                return string;
            }
            return super.getToolTipText(mouseEvent);
        }
    }

    class TreeMouseMotionAdaptor
    extends MouseMotionAdapter {
        TreeMouseMotionAdaptor() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!AbstractMapperTree.this.getViewManager().isHighlightLink() || !AbstractMapperTree.this.getViewManager().isToggleHighlighting()) {
                this.unHighlightLastPath();
                return;
            }
            TreePath treePath = AbstractMapperTree.this.mTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                if (AbstractMapperTree.this.lastPath != treePath) {
                    this.unHighlightLastPath();
                    Rectangle rectangle = AbstractMapperTree.this.mTree.getPathBounds(treePath);
                    if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                        IMapperTreeNode iMapperTreeNode = AbstractMapperTree.this.getMapperTreeNode(treePath);
                        if (iMapperTreeNode.getLinkCount() > 0) {
                            iMapperTreeNode.setHighlightLink(true);
                            AbstractMapperTree.this.mTree.repaint();
                            this.highlightCanvasLinks(iMapperTreeNode.getLinks());
                            AbstractMapperTree.this.lastPath = treePath;
                        }
                    } else {
                        this.unHighlightLastPath();
                    }
                }
            } else {
                this.unHighlightLastPath();
            }
        }

        private void unHighlightLastPath() {
            if (AbstractMapperTree.this.lastPath != null) {
                IMapperTreeNode iMapperTreeNode = AbstractMapperTree.this.getMapperTreeNode(AbstractMapperTree.this.lastPath);
                iMapperTreeNode.setHighlightLink(false);
                AbstractMapperTree.this.mTree.repaint();
                AbstractMapperTree.this.lastPath = null;
                this.unHighlightCanvasLinks(iMapperTreeNode.getLinks());
            }
        }

        private void highlightCanvasLinks(List list) {
            for (IMapperLink iMapperLink : list) {
                ICanvasLink iCanvasLink = AbstractMapperTree.this.getViewManager().getCanvasView().getCanvas().getCanvasLinkByDataObject(iMapperLink);
                if (iCanvasLink != null) {
                    iCanvasLink.startHighlighting();
                }
                if (!(AbstractMapperTree.this.getViewManager().getCanvasView().getCanvas() instanceof JGoView)) continue;
                AbstractMapperTree.this.highlightSingleLink(iMapperLink);
            }
        }

        private void unHighlightCanvasLinks(List list) {
            for (IMapperLink iMapperLink : list) {
                ICanvasLink iCanvasLink = AbstractMapperTree.this.getViewManager().getCanvasView().getCanvas().getCanvasLinkByDataObject(iMapperLink);
                if (iCanvasLink != null) {
                    iCanvasLink.stopHighlighting();
                }
                if (!(AbstractMapperTree.this.getViewManager().getCanvasView().getCanvas() instanceof JGoView)) continue;
                AbstractMapperTree.this.unHighlightSingleLink(iMapperLink);
            }
        }
    }
}

