/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasFieldNode;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasGroupNode;

public class GradientRectangle
extends JGoRectangle {
    private static final JGoPen PEN_BORDER = JGoPen.makeStockPen((Color)new Color(127, 127, 127));
    private static final Color COLOR_0 = Color.WHITE;
    private static final Color COLOR_1 = new Color(231, 241, 249);
    private static final Color COLOR_2 = new Color(184, 215, 255);
    private static final Color COLOR_3 = new Color(255, 255, 255);
    private static final Color COLOR_4 = new Color(221, 235, 246);
    private static final Color COLOR_5 = new Color(169, 197, 235);
    private Map mColorMap = new LinkedHashMap();
    private ICanvasGroupNode mGroupNode;

    public GradientRectangle(ICanvasGroupNode iCanvasGroupNode) {
        this.mGroupNode = iCanvasGroupNode;
        this.setPen(PEN_BORDER);
    }

    private void calculateColorMap() {
        this.mColorMap.clear();
        float f = this.getSpanLength();
        float f2 = this.getLeft() + this.getWidth() / 2;
        int n = this.getTop() + (int)f;
        n = this.addColorPoint(0.073f, n, COLOR_0, COLOR_1, f, f2);
        n = this.addColorPoint(0.236f, n, COLOR_1, COLOR_2, f, f2);
        n = this.addColorPoint(0.7f, n, COLOR_2, COLOR_3, f, f2);
        n = this.addColorPoint(0.95f, n, COLOR_3, COLOR_4, f, f2);
        n = this.addColorPoint(1.0f, n, COLOR_4, COLOR_5, f, f2);
    }

    private float getSpanLength() {
        float f = this.getHeight();
        if (this.mGroupNode.isExpanded() && this.mGroupNode.getNodes().size() > 0) {
            ICanvasFieldNode iCanvasFieldNode = null;
            Collection collection = this.mGroupNode.getNodes();
            for (ICanvasFieldNode iCanvasFieldNode2 : collection) {
                if (!iCanvasFieldNode2.getFieldNode().isOutput()) continue;
                iCanvasFieldNode = iCanvasFieldNode2;
                break;
            }
            if (iCanvasFieldNode != null && iCanvasFieldNode instanceof JGoArea) {
                f -= (float)((JGoArea)iCanvasFieldNode).getHeight();
            }
        }
        return f;
    }

    private int addColorPoint(float f, int n, Color color, Color color2, float f2, float f3) {
        int n2 = this.getTop() + Math.round(f2 - f2 * f);
        Rectangle rectangle = new Rectangle(this.getLeft(), n2, this.getWidth(), n - n2);
        GradientPaint gradientPaint = new GradientPaint(f3, n2, color2, f3, n, color);
        this.mColorMap.put(rectangle, gradientPaint);
        return n2;
    }

    public void setBoundingRect(int n, int n2, int n3, int n4) {
        super.setBoundingRect(n, n2, n3, n4);
        this.calculateColorMap();
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        Rectangle rectangle = this.getBoundingRect();
        this.drawGradientRect(graphics2D, this.getPen(), this.getBrush(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawGradientRect(Graphics2D graphics2D, JGoPen jGoPen, JGoBrush jGoBrush, int n, int n2, int n3, int n4) {
        Object object = this.mColorMap.keySet().iterator();
        while (object.hasNext()) {
            Rectangle rectangle = (Rectangle)object.next();
            GradientPaint gradientPaint = (GradientPaint)this.mColorMap.get(rectangle);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (jGoPen != null && (object = jGoPen.getStroke()) != null) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.drawRect(n, n2, n3, n4);
        }
    }
}

