/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.MapperCanvasView;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.AbstractCanvasView;
import org.netbeans.modules.soa.mapper.basicmapper.tree.DestTree;
import org.netbeans.modules.soa.mapper.basicmapper.tree.SourceTree;
import org.netbeans.modules.soa.mapper.common.IMapperEvent;
import org.netbeans.modules.soa.mapper.common.IMapperViewModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewManager;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.IMapperCanvasView;
import org.netbeans.modules.soa.mapper.common.basicmapper.palette.IPaletteView;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeView;

public class BasicViewManager
implements IBasicViewManager {
    protected PropertyChangeListener changeLayerListener = new ChangeLayerListener();
    private MapperCanvasView mCanvasView;
    private DestTree mDestView;
    private List mEventQueue = new Vector(){

        public synchronized boolean add(Object object) {
            if (super.add(object)) {
                this.notify();
                return true;
            }
            return false;
        }

        public synchronized void add(int n, Object object) {
            super.add(n, object);
            this.notify();
        }
    };
    private IBasicMapperModel mModel;
    private IPaletteView mPaletteToolbar;
    private SourceTree mSourceView;
    private boolean highlightLink = true;
    private boolean toggleHighlighting = true;

    public BasicViewManager() {
        this.mCanvasView = new MapperCanvasView();
        this.mCanvasView.setViewManager(this);
        this.mDestView = new DestTree();
        this.mDestView.setViewManager(this);
        this.mSourceView = new SourceTree();
        this.mSourceView.setViewManager(this);
        ToggleHighlightAction toggleHighlightAction = new ToggleHighlightAction();
        ((AbstractCanvasView)this.mCanvasView.getCanvas()).getActionMap().put("toggleHighlight", toggleHighlightAction);
        ((AbstractCanvasView)this.mCanvasView.getCanvas()).getInputMap().put(KeyStroke.getKeyStroke(72, 2, false), "toggleHighlight");
        this.mSourceView.getTree().getActionMap().put("toggleHighlight", toggleHighlightAction);
        this.mSourceView.getTree().getInputMap().put(KeyStroke.getKeyStroke(72, 2, false), "toggleHighlight");
        this.mDestView.getTree().getActionMap().put("toggleHighlight", toggleHighlightAction);
        this.mDestView.getTree().getInputMap().put(KeyStroke.getKeyStroke(72, 2, false), "toggleHighlight");
    }

    public IMapperCanvasView getCanvasView() {
        return this.mCanvasView;
    }

    public IMapperTreeView getDestView() {
        return this.mDestView;
    }

    public List getEventQueue() {
        return this.mEventQueue;
    }

    public IBasicMapperModel getMapperModel() {
        return this.mModel;
    }

    public IPaletteView getPaletteView() {
        return this.mPaletteToolbar;
    }

    public void setPaletteView(IPaletteView iPaletteView) {
        this.mPaletteToolbar = iPaletteView;
    }

    public IMapperTreeView getSourceView() {
        return this.mSourceView;
    }

    public void setMapperModel(IBasicMapperModel iBasicMapperModel) {
        if (this.mModel == iBasicMapperModel) {
            return;
        }
        if (this.mModel != null) {
            this.mModel.removePropertyChangeListener(this.changeLayerListener);
        }
        this.mModel = iBasicMapperModel;
        IBasicViewModel iBasicViewModel = null;
        if (this.mModel != null) {
            iBasicViewModel = this.mModel.getSelectedViewModel();
            this.mModel.addPropertyChangeListener(this.changeLayerListener);
        }
        this.setNewViewModel(iBasicViewModel);
    }

    public void postMapperEvent(IMapperEvent iMapperEvent) {
        if (iMapperEvent != null) {
            this.mEventQueue.add(iMapperEvent);
        }
    }

    private void setNewViewModel(IMapperViewModel iMapperViewModel) {
        this.mSourceView.setViewModel(iMapperViewModel);
        this.mDestView.setViewModel(iMapperViewModel);
        this.mCanvasView.setViewModel(iMapperViewModel);
    }

    public void setHighlightLink(boolean bl) {
        this.highlightLink = bl;
    }

    public boolean isHighlightLink() {
        return this.highlightLink;
    }

    public void setToggleHighlighting(boolean bl) {
        this.toggleHighlighting = bl;
    }

    public boolean isToggleHighlighting() {
        return this.toggleHighlighting;
    }

    class ToggleHighlightAction
    extends AbstractAction {
        ToggleHighlightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = BasicViewManager.this.isToggleHighlighting();
            BasicViewManager.this.setToggleHighlighting(!bl);
            if (bl) {
                ((AbstractCanvasView)BasicViewManager.this.mCanvasView.getCanvas()).repaint();
                BasicViewManager.this.mSourceView.getTree().repaint();
                BasicViewManager.this.mDestView.getTree().repaint();
            }
        }
    }

    private class ChangeLayerListener
    implements PropertyChangeListener {
        private ChangeLayerListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("MapperVM.VMChange")) {
                BasicViewManager.this.setNewViewModel((IMapperViewModel)propertyChangeEvent.getNewValue());
            }
        }
    }
}

