/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import java.awt.Color;
import java.awt.Point;
import java.awt.dnd.DragSourceContext;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.AbstractCanvasView;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasController;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.BasicCanvasSimpleLink;
import org.netbeans.modules.soa.mapper.basicmapper.tree.DestTreeViewController;
import org.netbeans.modules.soa.mapper.basicmapper.tree.SourceTreeViewController;
import org.netbeans.modules.soa.mapper.common.IMapperEvent;
import org.netbeans.modules.soa.mapper.common.IMapperListener;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicController;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewController;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewManager;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMapperLink;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasView;
import org.netbeans.modules.soa.mapper.common.basicmapper.dnd.IBasicDragController;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IBasicTreeViewSelectionPathController;
import org.netbeans.modules.soa.mapper.common.gtk.ICanvasLink;

public class BasicMapperController
implements IBasicController,
IBasicDragController {
    private static final int MAX_SECONDS_INVOKED_BEFORE_YIELD = 3;
    private List mEventQueue;
    private EventRunner mEventRunner;
    private List mListenersList = new Vector();
    private Map mSourceListenersMap = new Hashtable();
    private IBasicViewManager mViewManager;
    private DestTreeViewController mDestTreeController;
    private SourceTreeViewController mSourceTreeController;
    private BasicCanvasController mCanvasController;
    private Object mTransferObject;
    private IMapperNode mOriginatingDragNode;
    private BasicCanvasSimpleLink mDragLink;
    private IBasicTreeViewSelectionPathController mDragLinkSourceController;
    private DragSourceContext mLinkDragSourceContext;

    public BasicMapperController(IBasicViewManager iBasicViewManager) {
        this.mViewManager = iBasicViewManager;
        this.mEventQueue = iBasicViewManager.getEventQueue();
        this.mEventRunner = new EventRunner(3);
        this.mEventRunner.start();
        this.mDestTreeController = new DestTreeViewController();
        this.mDestTreeController.setView(this.mViewManager.getDestView());
        this.mDestTreeController.setMapperController(this);
        this.mDestTreeController.setMapperDragController(this);
        this.mSourceTreeController = new SourceTreeViewController();
        this.mSourceTreeController.setView(this.mViewManager.getSourceView());
        this.mSourceTreeController.setMapperController(this);
        this.mSourceTreeController.setMapperDragController(this);
        this.mCanvasController = new BasicCanvasController();
        this.mCanvasController.setView(this.mViewManager.getCanvasView());
        this.mCanvasController.setMapperController(this);
        this.mCanvasController.setMapperDragController(this);
        this.mViewManager.getCanvasView().getCanvas().setCanvasController(this.mCanvasController);
    }

    public IBasicMapperModel getMapperModel() {
        return this.getViewManager().getMapperModel();
    }

    public IBasicViewManager getViewManager() {
        return this.mViewManager;
    }

    public IBasicViewController getDestViewController() {
        return this.mDestTreeController;
    }

    public IBasicViewController getSourceViewController() {
        return this.mSourceTreeController;
    }

    public IBasicViewController getCanvasViewController() {
        return this.mCanvasController;
    }

    public void addMapperListener(IMapperListener iMapperListener) {
        this.mListenersList.add(iMapperListener);
    }

    public void addMapperListener(IMapperListener iMapperListener, String string) {
        List<IMapperListener> list = null;
        if (this.mSourceListenersMap.containsKey(string)) {
            list = (List)this.mSourceListenersMap.get(string);
        } else {
            list = new Vector();
            this.mSourceListenersMap.put(string, list);
        }
        list.add(iMapperListener);
    }

    public void dispatchEvent(IMapperEvent iMapperEvent) {
        List list = (List)this.mSourceListenersMap.get(iMapperEvent.getEventType());
        if (list != null && !list.isEmpty()) {
            this.invokeListeners(list, iMapperEvent);
        }
        if (!this.mListenersList.isEmpty()) {
            this.invokeListeners(this.mListenersList, iMapperEvent);
        }
    }

    public void removeMapperListener(IMapperListener iMapperListener) {
        this.mListenersList.remove(iMapperListener);
    }

    public void removeMapperListener(IMapperListener iMapperListener, String string) {
        if (this.mSourceListenersMap.containsKey(string)) {
            ((List)this.mSourceListenersMap.get(string)).remove(iMapperListener);
        }
    }

    protected void finalize() {
        this.stopDispatch();
    }

    public void stopDispatch() {
        this.mEventRunner.setShouldStop(true);
        this.mEventRunner.interrupt();
    }

    public void releaseControl() {
        this.stopDispatch();
        this.mListenersList.clear();
        this.mSourceTreeController.getDnDHandler().releaseHandler();
        this.mDestTreeController.getDnDHandler().releaseHandler();
    }

    private void invokeListeners(List list, final IMapperEvent iMapperEvent) {
        final LinkedList linkedList = new LinkedList();
        linkedList.addAll(list);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (int i = linkedList.size() - 1; i >= 0; --i) {
                    IMapperListener iMapperListener = (IMapperListener)linkedList.get(i);
                    try {
                        iMapperListener.eventInvoked(iMapperEvent);
                        continue;
                    }
                    catch (Throwable throwable) {
                        System.err.println(Thread.currentThread().getName() + " caught Exception on MapperListener:" + iMapperListener.getClass().getName());
                        throwable.printStackTrace(System.err);
                    }
                }
            }
        });
    }

    public void setTransferObject(Object object) {
        this.mTransferObject = object;
    }

    public Object getTransferObject() {
        return this.mTransferObject;
    }

    public void setOriginatingDragNode(IMapperNode iMapperNode) {
        this.mOriginatingDragNode = iMapperNode;
    }

    public IMapperNode getOriginatingDragNode() {
        return this.mOriginatingDragNode;
    }

    public void resetDragLinkEndLocation() {
        if (this.mDragLink != null) {
            JGoPort jGoPort = this.mDragLink.getFromPort();
            JGoPort jGoPort2 = this.mDragLink.getToPort();
            if (jGoPort.isValidDestination()) {
                JGoPort jGoPort3 = jGoPort2;
                jGoPort2 = jGoPort;
                jGoPort = jGoPort3;
            }
            jGoPort2.setLocation(jGoPort.getLocation());
        }
    }

    public void setDragLinkEndLocation(Point point) {
        Point point2;
        ICanvasView iCanvasView = this.mViewManager.getCanvasView().getCanvas();
        if (this.mDragLinkSourceController != null) {
            point2 = this.mDragLinkSourceController.getSelectionPathPoint();
            iCanvasView.convertViewToDoc(point2);
            this.mDragLink.getFromPort().setLocation(point2);
        }
        point2 = new Point(point);
        iCanvasView.convertViewToDoc(point2);
        if (this.mDragLink != null) {
            JGoPort jGoPort = ((AbstractCanvasView)iCanvasView).pickNearestPort(point2);
            if (jGoPort != null) {
                if (this.mDragLinkSourceController instanceof SourceTreeViewController) {
                    if (jGoPort.isValidDestination()) {
                        point2 = jGoPort.getToLinkPoint(new Point(jGoPort.getBoundingRect().x, jGoPort.getBoundingRect().y));
                    }
                } else if (this.mDragLinkSourceController instanceof DestTreeViewController && jGoPort.isValidSource()) {
                    point2 = jGoPort.getFromLinkPoint(new Point(jGoPort.getBoundingRect().x, jGoPort.getBoundingRect().y));
                }
            }
            JGoPort jGoPort2 = this.mDragLink.getFromPort();
            JGoPort jGoPort3 = this.mDragLink.getToPort();
            if (jGoPort2.isValidDestination()) {
                jGoPort3 = jGoPort2;
            }
            jGoPort3.setLocation(point2);
        }
    }

    public void setDragLink(ICanvasLink iCanvasLink) {
        this.mDragLink = (BasicCanvasSimpleLink)iCanvasLink;
        this.mDragLinkSourceController = null;
    }

    public void setDragLink(Point point, IBasicTreeViewSelectionPathController iBasicTreeViewSelectionPathController) {
        this.mDragLinkSourceController = iBasicTreeViewSelectionPathController;
        ICanvasView iCanvasView = this.mViewManager.getCanvasView().getCanvas();
        Point point2 = new Point(point);
        iCanvasView.convertViewToDoc(point2);
        JGoPort jGoPort = new JGoPort();
        jGoPort.setLocation(point2);
        jGoPort.setToSpot(-1);
        jGoPort.setFromSpot(-1);
        JGoPort jGoPort2 = new JGoPort();
        jGoPort2.setLocation(point2);
        jGoPort2.setToSpot(-1);
        jGoPort2.setFromSpot(-1);
        this.mDragLink = new BasicCanvasSimpleLink(jGoPort, jGoPort2);
        this.mDragLink.setPen(JGoPen.make((int)65535, (int)1, (Color)ICanvasMapperLink.DEFAULT_LINK_SELECTED_COLOR));
        this.mDragLink.setBrush(JGoBrush.makeStockBrush((Color)ICanvasMapperLink.DEFAULT_LINK_SELECTED_COLOR));
        iCanvasView.addRawLink(this.mDragLink);
    }

    public void clearDragLink() {
        ICanvasView iCanvasView = this.mViewManager.getCanvasView().getCanvas();
        iCanvasView.removeRawLink(this.mDragLink);
        this.mDragLink = null;
        this.mDragLinkSourceController = null;
    }

    public void setLinkDragSourceContext(DragSourceContext dragSourceContext) {
        this.mLinkDragSourceContext = dragSourceContext;
    }

    public DragSourceContext getLinkDragSourceContext() {
        return this.mLinkDragSourceContext;
    }

    private class EventRunner
    extends Thread {
        private long mStartTime;
        private long mMillisSecondsRunBeforeYield;
        private boolean mShouldStop;

        private EventRunner(int n) {
            super("Mapper Controller Event Invoker");
            this.mStartTime = 0L;
            this.mMillisSecondsRunBeforeYield = 0L;
            this.mShouldStop = false;
            this.mMillisSecondsRunBeforeYield = n * 1000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.mShouldStop) {
                IMapperEvent iMapperEvent = null;
                List list = BasicMapperController.this.mEventQueue;
                synchronized (list) {
                    while (BasicMapperController.this.mEventQueue.isEmpty()) {
                        try {
                            BasicMapperController.this.mEventQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            if (!this.mShouldStop) continue;
                            return;
                        }
                    }
                    iMapperEvent = (IMapperEvent)BasicMapperController.this.mEventQueue.remove(0);
                }
                this.startTimer();
                BasicMapperController.this.dispatchEvent(iMapperEvent);
            }
        }

        private void setShouldStop(boolean bl) {
            this.mShouldStop = bl;
        }

        private boolean shouldStop() {
            return this.mShouldStop;
        }

        private boolean shouldYeild() {
            if (this.mMillisSecondsRunBeforeYield <= 0L) {
                return false;
            }
            return System.currentTimeMillis() - this.mStartTime >= this.mMillisSecondsRunBeforeYield;
        }

        private void startTimer() {
            this.mStartTime = System.currentTimeMillis();
        }
    }
}

