/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.timers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.timers.InstanceWatcher;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimesCollectorPeer {
    private List<Reference<Object>> files = new ArrayList<Reference<Object>>();
    private Map<Object, Map<String, Description>> fo2Key2Desc = new WeakHashMap<Object, Map<String, Description>>();
    private static final TimesCollectorPeer INSTANCE = new TimesCollectorPeer();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static TimesCollectorPeer getDefault() {
        return INSTANCE;
    }

    private TimesCollectorPeer() {
    }

    public void reportTime(Object object, String string, String string2, long l) {
        Map<String, Description> map = this.getKey2Desc(object);
        Description description = new Description(string2, l);
        map.put(string, description);
        this.pcs.firePropertyChange("PROP", object, string);
    }

    public void reportReference(Object object, String string, String string2, Object object2) {
        Map<String, Description> map = this.getKey2Desc(object);
        Description description = map.get(string);
        assert (description == null || description instanceof ObjectCountDescripton) : "Illegal state";
        ObjectCountDescripton objectCountDescripton = description == null ? new ObjectCountDescripton(this, object, string, string2) : (ObjectCountDescripton)description;
        objectCountDescripton.add(object2);
        map.put(string, objectCountDescripton);
        this.pcs.firePropertyChange("PROP", object, string);
    }

    private synchronized Map<String, Description> getKey2Desc(final Object object) {
        Map<String, Description> map = this.fo2Key2Desc.get(object);
        if (map == null) {
            this.files.add(new CleanableWeakReference<Object>(object));
            map = Collections.synchronizedMap(new LinkedHashMap());
            this.fo2Key2Desc.put(object, map);
            this.pcs.firePropertyChange("fos", null, object);
            if (object instanceof FileObject) {
                ((FileObject)object).addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDeleted(FileEvent fileEvent) {
                        for (Reference reference : TimesCollectorPeer.this.files) {
                            if (reference.get() != object) continue;
                            TimesCollectorPeer.this.files.remove(reference);
                            break;
                        }
                        TimesCollectorPeer.this.fo2Key2Desc.remove(object);
                        TimesCollectorPeer.this.pcs.firePropertyChange("fos", null, null);
                    }
                });
            }
        }
        return map;
    }

    public Description getDescription(Object object, String string) {
        return this.getKey2Desc(object).get(string);
    }

    public Collection<String> getKeysForFile(Object object) {
        return this.getKey2Desc(object).keySet();
    }

    public Collection<Object> getFiles() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Reference<Object> reference : this.files) {
            Object object = reference.get();
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void select(Object object) {
        this.getKey2Desc(object);
        this.pcs.firePropertyChange("selected", null, object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CleanableWeakReference<T>
    extends WeakReference<T>
    implements Runnable {
        public CleanableWeakReference(T t) {
            super(t, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            TimesCollectorPeer.this.files.remove(this);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    TimesCollectorPeer.this.pcs.firePropertyChange("fos", null, null);
                }
            });
        }
    }

    public static class ObjectCountDescripton
    extends Description
    implements ChangeListener {
        private TimesCollectorPeer tcp;
        private Reference<Object> fo;
        private String key;
        private InstanceWatcher iw = new InstanceWatcher();

        public ObjectCountDescripton(TimesCollectorPeer timesCollectorPeer, Object object, String string, String string2) {
            super(string2, 0L);
            this.tcp = timesCollectorPeer;
            this.fo = new WeakReference<Object>(object);
            this.key = string;
            this.iw.addChangeListener(this);
        }

        public long getTime() {
            return this.iw.size();
        }

        public Collection getInstances() {
            return this.iw.getInstances();
        }

        private void add(Object object) {
            this.iw.add(object);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = this.fo.get();
            if (object != null) {
                this.tcp.pcs.firePropertyChange("PROP", object, this.key);
            }
        }
    }

    public static class Description {
        private String message;
        private long time;

        public Description(String string, long l) {
            this.message = string;
            this.time = l;
        }

        public String getMessage() {
            return this.message;
        }

        public long getTime() {
            return this.time;
        }
    }
}

