/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.extension.openide.util;

import java.awt.Component;
import java.awt.Cursor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public final class Utilities_RAVE {
    private Utilities_RAVE() {
    }

    public static void showBusyCursor(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            Utilities_RAVE.doShowBusyCursor(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Utilities_RAVE.doShowBusyCursor(bl);
                }
            });
        }
    }

    private static void doShowBusyCursor(boolean bl) {
        JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
        if (bl) {
            RepaintManager.currentManager(jFrame).paintDirtyRegions();
            jFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            jFrame.getGlassPane().setVisible(true);
            jFrame.repaint();
        } else {
            jFrame.getGlassPane().setVisible(false);
            jFrame.getGlassPane().setCursor(null);
            jFrame.repaint();
        }
    }

    public static JPopupMenu actionsToPopup(Action[] actionArray, Component component, JPopupMenu jPopupMenu) {
        Object object;
        Lookup lookup = null;
        for (object = component; !(object == null || object instanceof Lookup.Provider && (lookup = ((Lookup.Provider)object).getLookup()) != null); object = ((Component)object).getParent()) {
        }
        if (lookup == null) {
            object = Utilities_RAVE.createUtilitiesCompositeMap(component);
            lookup = object != null ? Lookups.singleton(object) : Lookups.singleton((Object)new UtilitiesCompositeActionMap(component));
        }
        object = new HashSet<Action>();
        boolean bl = false;
        for (int i = 0; i < actionArray.length; ++i) {
            boolean bl2 = true;
            Action action = actionArray[i];
            if (action != null) {
                Serializable serializable;
                if (((HashSet)object).contains(action)) continue;
                ((HashSet)object).add(action);
                if (action instanceof ContextAwareAction) {
                    action = ((ContextAwareAction)action).createContextAwareInstance(lookup);
                }
                bl2 = false;
                bl = true;
                if (action instanceof Presenter.Popup) {
                    JMenuItem jMenuItem = ((Presenter.Popup)action).getPopupPresenter();
                    if (jMenuItem == null) {
                        serializable = new NullPointerException("findContextMenuImpl, getPopupPresenter returning null for " + action);
                        ErrorManager.getDefault().notify(1, (Throwable)serializable);
                    }
                    jPopupMenu.add(jMenuItem);
                } else {
                    serializable = new JMenuItem(action);
                    jPopupMenu.add((JMenuItem)serializable);
                }
            }
            if (!bl2 || !bl) continue;
            jPopupMenu.addSeparator();
            bl = false;
        }
        return jPopupMenu;
    }

    private static Object createUtilitiesCompositeMap(Component component) {
        try {
            ClassLoader classLoader = Utilities.class.getClassLoader();
            Class<?> clazz = Class.forName("org.openide.util.UtilitiesCompositeMap", true, classLoader);
            Constructor<?> constructor = clazz.getDeclaredConstructor(Component.class);
            constructor.setAccessible(true);
            return constructor.newInstance(component);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify(1, (Throwable)noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            ErrorManager.getDefault().notify(1, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(1, (Throwable)invocationTargetException);
        }
        return null;
    }

    private static class UtilitiesCompositeActionMap
    extends ActionMap {
        private Component component;

        public UtilitiesCompositeActionMap(Component component) {
            this.component = component;
        }

        public int size() {
            return this.keys().length;
        }

        public Action get(Object object) {
            Component component = this.component;
            do {
                Action action;
                ActionMap actionMap;
                if (!(component instanceof JComponent) || (actionMap = ((JComponent)component).getActionMap()) == null || (action = actionMap.get(object)) == null) continue;
                return action;
            } while (!(component instanceof Lookup.Provider) && (component = component.getParent()) != null);
            return null;
        }

        public Object[] allKeys() {
            return this.keys(true);
        }

        public Object[] keys() {
            return this.keys(false);
        }

        private Object[] keys(boolean bl) {
            HashSet<Object> hashSet = new HashSet<Object>();
            Component component = this.component;
            do {
                ActionMap actionMap;
                if (!(component instanceof JComponent) || (actionMap = ((JComponent)component).getActionMap()) == null) continue;
                List<Object> list = bl ? Arrays.asList(actionMap.allKeys()) : Arrays.asList(actionMap.keys());
                hashSet.addAll(list);
            } while (!(component instanceof Lookup.Provider) && (component = component.getParent()) != null);
            return hashSet.toArray();
        }

        public void remove(Object object) {
        }

        public void setParent(ActionMap actionMap) {
        }

        public void clear() {
        }

        public void put(Object object, Action action) {
        }

        public ActionMap getParent() {
            return null;
        }
    }
}

