/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.extension.openide.text;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.openide.ErrorManager;
import org.openide.windows.TopComponent;

public class TextTransferHandler
extends TransferHandler
implements UIResource {
    public static boolean dontRemove = false;
    private JTextComponent exportComp;
    private boolean shouldRemove;
    private int p0;
    private int p1;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$org$netbeans$modules$visualweb$extension$openide$text$TextTransferHandler$CodeClipTransferData;

    protected DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, JTextComponent jTextComponent) {
        DataFlavor dataFlavor = null;
        DataFlavor dataFlavor2 = null;
        DataFlavor dataFlavor3 = null;
        if (jTextComponent instanceof JEditorPane) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                String string = dataFlavorArray[i].getMimeType();
                if (string.startsWith(((JEditorPane)jTextComponent).getEditorKit().getContentType())) {
                    return dataFlavorArray[i];
                }
                if (dataFlavor == null && string.startsWith("text/plain")) {
                    dataFlavor = dataFlavorArray[i];
                    continue;
                }
                if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i].getRepresentationClass() == (class$java$lang$String == null ? TextTransferHandler.class$("java.lang.String") : class$java$lang$String)) {
                    dataFlavor2 = dataFlavorArray[i];
                    continue;
                }
                if (dataFlavor3 != null || !dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                dataFlavor3 = dataFlavorArray[i];
            }
            if (dataFlavor != null) {
                return dataFlavor;
            }
            if (dataFlavor2 != null) {
                return dataFlavor2;
            }
            if (dataFlavor3 != null) {
                return dataFlavor3;
            }
            return null;
        }
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            String string = dataFlavorArray[i].getMimeType();
            if (string.startsWith("text/plain")) {
                return dataFlavorArray[i];
            }
            if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i].getRepresentationClass() == (class$java$lang$String == null ? TextTransferHandler.class$("java.lang.String") : class$java$lang$String)) {
                dataFlavor2 = dataFlavorArray[i];
                continue;
            }
            if (dataFlavor3 != null || !dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
            dataFlavor3 = dataFlavorArray[i];
        }
        if (dataFlavor2 != null) {
            return dataFlavor2;
        }
        if (dataFlavor3 != null) {
            return dataFlavor3;
        }
        return null;
    }

    protected void handleReaderImport(Reader reader, JTextComponent jTextComponent, boolean bl) throws BadLocationException, IOException {
        if (bl) {
            int n = jTextComponent.getSelectionStart();
            int n2 = jTextComponent.getSelectionEnd();
            int n3 = n2 - n;
            EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
            Document document = jTextComponent.getDocument();
            if (n3 > 0) {
                document.remove(n, n3);
            }
            editorKit.read(reader, document, n);
        } else {
            int n;
            char[] cArray = new char[1024];
            boolean bl2 = false;
            StringBuffer stringBuffer = null;
            while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n);
                }
                int n4 = 0;
                block5: for (int i = 0; i < n; ++i) {
                    switch (cArray[i]) {
                        case '\r': {
                            if (bl2) {
                                if (i == 0) {
                                    stringBuffer.append('\n');
                                    continue block5;
                                }
                                cArray[i - 1] = 10;
                                continue block5;
                            }
                            bl2 = true;
                            continue block5;
                        }
                        case '\n': {
                            if (!bl2) continue block5;
                            if (i > n4 + 1) {
                                stringBuffer.append(cArray, n4, i - n4 - 1);
                            }
                            bl2 = false;
                            n4 = i;
                            continue block5;
                        }
                        default: {
                            if (!bl2) continue block5;
                            if (i == 0) {
                                stringBuffer.append('\n');
                            } else {
                                cArray[i - 1] = 10;
                            }
                            bl2 = false;
                        }
                    }
                }
                if (n4 >= n) continue;
                if (bl2) {
                    if (n4 >= n - 1) continue;
                    stringBuffer.append(cArray, n4, n - n4 - 1);
                    continue;
                }
                stringBuffer.append(cArray, n4, n - n4);
            }
            if (bl2) {
                stringBuffer.append('\n');
            }
            jTextComponent.replaceSelection(stringBuffer != null ? stringBuffer.toString() : "");
        }
    }

    public int getSourceActions(JComponent jComponent) {
        int n = 0;
        if (!(jComponent instanceof JPasswordField)) {
            n = ((JTextComponent)jComponent).isEditable() ? 3 : 1;
        }
        return n;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        this.exportComp = (JTextComponent)jComponent;
        this.shouldRemove = true;
        dontRemove = false;
        this.p0 = this.exportComp.getSelectionStart();
        this.p1 = this.exportComp.getSelectionEnd();
        return this.p0 != this.p1 ? new TextTransferable(this.exportComp, this.p0, this.p1) : null;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (this.shouldRemove && n == 2) {
            TextTransferable textTransferable = (TextTransferable)transferable;
            if (!dontRemove) {
                textTransferable.removeText();
            }
        }
        this.exportComp = null;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (jTextComponent == this.exportComp && jTextComponent.getCaretPosition() >= this.p0 && jTextComponent.getCaretPosition() <= this.p1) {
            this.shouldRemove = false;
            return true;
        }
        boolean bl = false;
        DataFlavor dataFlavor = this.getImportFlavor(transferable.getTransferDataFlavors(), jTextComponent);
        if (dataFlavor != null) {
            try {
                Runnable runnable;
                Object object;
                boolean bl2 = false;
                if (jComponent instanceof JEditorPane) {
                    object = (JEditorPane)jComponent;
                    if (!((JEditorPane)object).getContentType().startsWith("text/plain") && dataFlavor.getMimeType().startsWith(((JEditorPane)object).getContentType())) {
                        bl2 = true;
                    }
                    if (transferable.isDataFlavorSupported(CodeClipTransferData.CODE_CLIP_DATA_FLAVOR)) {
                        try {
                            runnable = (Runnable)transferable.getTransferData(CodeClipTransferData.CODE_CLIP_DATA_FLAVOR);
                            if (runnable != null) {
                                runnable.run();
                            }
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            ErrorManager.getDefault().notify(1, (Throwable)unsupportedFlavorException);
                        }
                    }
                }
                object = dataFlavor.getReaderForText(transferable);
                this.handleReaderImport((Reader)object, jTextComponent, bl2);
                bl = true;
                runnable = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, jTextComponent);
                if (runnable != null) {
                    runnable.requestActive();
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                ErrorManager.getDefault().notify(1, (Throwable)unsupportedFlavorException);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        return bl;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
            return false;
        }
        return this.getImportFlavor(dataFlavorArray, jTextComponent) != null;
    }

    public static class CodeClipTransferData
    extends StringSelection {
        private static final DataFlavor CODE_CLIP_DATA_FLAVOR = new DataFlavor(class$org$netbeans$modules$visualweb$extension$openide$text$TextTransferHandler$CodeClipTransferData == null ? (class$org$netbeans$modules$visualweb$extension$openide$text$TextTransferHandler$CodeClipTransferData = TextTransferHandler.class$("org.netbeans.modules.visualweb.extension.openide.text.TextTransferHandler$CodeClipTransferData")) : class$org$netbeans$modules$visualweb$extension$openide$text$TextTransferHandler$CodeClipTransferData, (class$org$netbeans$modules$visualweb$extension$openide$text$TextTransferHandler$CodeClipTransferData == null ? (class$org$netbeans$modules$visualweb$extension$openide$text$TextTransferHandler$CodeClipTransferData = TextTransferHandler.class$("org.netbeans.modules.visualweb.extension.openide.text.TextTransferHandler$CodeClipTransferData")) : class$org$netbeans$modules$visualweb$extension$openide$text$TextTransferHandler$CodeClipTransferData).getName());
        private Runnable callback;
        private String data;

        public CodeClipTransferData(String string) {
            super(string);
            this.data = string;
        }

        public void setCallback(Runnable runnable) {
            this.callback = runnable;
        }

        public void resetData(String string) {
            this.data = string;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = super.getTransferDataFlavors();
            ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(Arrays.asList(dataFlavorArray));
            arrayList.add(CODE_CLIP_DATA_FLAVOR);
            return arrayList.toArray(new DataFlavor[0]);
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (dataFlavor == CODE_CLIP_DATA_FLAVOR) {
                return true;
            }
            return super.isDataFlavorSupported(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor == CODE_CLIP_DATA_FLAVOR) {
                return this.callback;
            }
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                return this.data;
            }
            if (dataFlavor.equals(DataFlavor.plainTextFlavor)) {
                return new StringReader(this.data);
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    static class TextTransferable
    implements Transferable,
    UIResource {
        protected String plainData = null;
        protected String htmlData = null;
        private static DataFlavor[] htmlFlavors;
        private static DataFlavor[] stringFlavors;
        private static DataFlavor[] plainFlavors;
        Position p0;
        Position p1;
        String mimeType;
        String richText;
        JTextComponent c;

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = this.getRicherFlavors();
            int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
            int n2 = this.isHTMLSupported() ? htmlFlavors.length : 0;
            int n3 = this.isPlainSupported() ? plainFlavors.length : 0;
            int n4 = this.isPlainSupported() ? stringFlavors.length : 0;
            int n5 = n + n2 + n3 + n4;
            DataFlavor[] dataFlavorArray2 = new DataFlavor[n5];
            int n6 = 0;
            if (n > 0) {
                System.arraycopy(dataFlavorArray, 0, dataFlavorArray2, n6, n);
                n6 += n;
            }
            if (n2 > 0) {
                System.arraycopy(htmlFlavors, 0, dataFlavorArray2, n6, n2);
                n6 += n2;
            }
            if (n3 > 0) {
                System.arraycopy(plainFlavors, 0, dataFlavorArray2, n6, n3);
                n6 += n3;
            }
            if (n4 > 0) {
                System.arraycopy(stringFlavors, 0, dataFlavorArray2, n6, n4);
                n6 += n4;
            }
            return dataFlavorArray2;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            DataFlavor[] dataFlavorArray = this.getRicherFlavors();
            if (this.isRicherFlavor(dataFlavor)) {
                return this.getRicherData(dataFlavor);
            }
            if (this.isHTMLFlavor(dataFlavor)) {
                String string = this.getHTMLData();
                string = string == null ? "" : string;
                if ((class$java$lang$String == null ? (class$java$lang$String = TextTransferHandler.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
                    return string;
                }
                if ((class$java$io$Reader == null ? (class$java$io$Reader = TextTransferHandler.class$("java.io.Reader")) : class$java$io$Reader).equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(string);
                }
                if ((class$java$io$InputStream == null ? (class$java$io$InputStream = TextTransferHandler.class$("java.io.InputStream")) : class$java$io$InputStream).equals(dataFlavor.getRepresentationClass())) {
                    return new StringBufferInputStream(string);
                }
            } else if (this.isPlainFlavor(dataFlavor)) {
                String string = this.getPlainData();
                string = string == null ? "" : string;
                if ((class$java$lang$String == null ? (class$java$lang$String = TextTransferHandler.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
                    return string;
                }
                if ((class$java$io$Reader == null ? (class$java$io$Reader = TextTransferHandler.class$("java.io.Reader")) : class$java$io$Reader).equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(string);
                }
                if ((class$java$io$InputStream == null ? (class$java$io$InputStream = TextTransferHandler.class$("java.io.InputStream")) : class$java$io$InputStream).equals(dataFlavor.getRepresentationClass())) {
                    return new StringBufferInputStream(string);
                }
            } else if (this.isStringFlavor(dataFlavor)) {
                String string = this.getPlainData();
                string = string == null ? "" : string;
                return string;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        protected boolean isRicherFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getRicherFlavors();
            int n = dataFlavorArray != null ? dataFlavorArray.length : 0;
            for (int i = 0; i < n; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isHTMLFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = htmlFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isHTMLSupported() {
            return this.htmlData != null;
        }

        protected String getHTMLData() {
            return this.htmlData;
        }

        protected boolean isPlainFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = plainFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isPlainSupported() {
            return this.plainData != null;
        }

        protected String getPlainData() {
            return this.plainData;
        }

        protected boolean isStringFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = stringFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        TextTransferable(JTextComponent jTextComponent, int n, int n2) {
            this.c = jTextComponent;
            Document document = jTextComponent.getDocument();
            try {
                this.p0 = document.createPosition(n);
                this.p1 = document.createPosition(n2);
                this.plainData = jTextComponent.getSelectedText();
                if (jTextComponent instanceof JEditorPane) {
                    JEditorPane jEditorPane = (JEditorPane)jTextComponent;
                    this.mimeType = jEditorPane.getContentType();
                    if (this.mimeType.startsWith("text/plain")) {
                        return;
                    }
                    StringWriter stringWriter = new StringWriter(this.p1.getOffset() - this.p0.getOffset());
                    jEditorPane.getEditorKit().write(stringWriter, document, this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                    if (this.mimeType.startsWith("text/html")) {
                        this.htmlData = stringWriter.toString();
                    } else {
                        this.richText = stringWriter.toString();
                    }
                }
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void removeText() {
            if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                try {
                    Document document = this.c.getDocument();
                    document.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        protected DataFlavor[] getRicherFlavors() {
            if (this.richText == null) {
                return null;
            }
            try {
                DataFlavor[] dataFlavorArray = new DataFlavor[]{new DataFlavor(this.mimeType + ";class=java.lang.String"), new DataFlavor(this.mimeType + ";class=java.io.Reader"), new DataFlavor(this.mimeType + ";class=java.io.InputStream;charset=unicode")};
                return dataFlavorArray;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (this.richText == null) {
                return null;
            }
            if ((class$java$lang$String == null ? (class$java$lang$String = TextTransferHandler.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
                return this.richText;
            }
            if ((class$java$io$Reader == null ? (class$java$io$Reader = TextTransferHandler.class$("java.io.Reader")) : class$java$io$Reader).equals(dataFlavor.getRepresentationClass())) {
                return new StringReader(this.richText);
            }
            if ((class$java$io$InputStream == null ? (class$java$io$InputStream = TextTransferHandler.class$("java.io.InputStream")) : class$java$io$InputStream).equals(dataFlavor.getRepresentationClass())) {
                return new StringBufferInputStream(this.richText);
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        static {
            try {
                htmlFlavors = new DataFlavor[3];
                TextTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
                TextTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
                TextTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
                plainFlavors = new DataFlavor[3];
                TextTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
                TextTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
                TextTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
                stringFlavors = new DataFlavor[2];
                TextTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
                TextTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("error initializing javax.swing.plaf.basic.BasicTranserable");
            }
        }
    }
}

